/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Component;
import java.util.Collection;

import javax.swing.JTable;

public class DefinitionsCellRenderer extends TextCellRenderer {

	private static final long serialVersionUID = 6529498624578089971L;

	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {

		if (value instanceof String[]) {
			String[] content = (String[]) value;
			String display = content[0];
			if (!content[1].equals("")) {
				display = display + " TO " + content[1] + " BY " + content[2];
			}
			return super.getTableCellRendererComponent(table, display, isSelected,
					hasFocus, row, column);
		} else if (column == 0 || value == null) {
			return super.getTableCellRendererComponent(table, value,
					isSelected, hasFocus, row, column);
		} else {
			String ret = null;
			for (Object val : (Collection) value) {
				if (ret == null) {
					ret = (String)val;
				} else {
					ret = ret + " OR " + val;
				}
			}
			return super.getTableCellRendererComponent(table, ret, isSelected,
					hasFocus, row, column);
		}
	}
}
