/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MonitorPanel extends JPanel {

	private static final long serialVersionUID = 4980790301779766146L;

	private JLabel studyLabel;

	private JButton refreshButton;

	private JButton selectButton;

	private JButton stopButton;

	private JButton cancelButton;

	private JButton restartButton;

	private JTable content;

	private JToolBar buttons;

	private JButton deleteButton;

	private JProgressBar bar;

	private Format timeFormat;

	public MonitorPanel() {
		// timeFormat = new SimpleDateFormat("MMM dd, HH:mm:ss");
		timeFormat = new SimpleDateFormat();
		bar = new JProgressBar(0, 100);
		bar.setStringPainted(true);
		GridBagLayout layout = new GridBagLayout();
		this.setLayout(layout);
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.BOTH;

		refreshButton = createButton(
				"toolbarButtonGraphics/general/Undo24.gif", "rollback",
				"reload");
		selectButton = createButton(
				"toolbarButtonGraphics/general/Export24.gif", "select",
				"show results for selected simulation");
		cancelButton = createButton(
				"toolbarButtonGraphics/general/Delete24.gif", "cancel",
				"cancel selected simulation");
		stopButton = createButton("toolbarButtonGraphics/general/Delete24.gif",
				"stop", "stop the wrapper executing the selected simulation");
		restartButton = createButton(
				"toolbarButtonGraphics/general/Undo24.gif", "restart",
				"restart selected simulation");
		deleteButton = createButton(
				"toolbarButtonGraphics/general/Delete24.gif", "remove",
				"delete selected simulation");

		buttons = new JToolBar();
		studyLabel = new JLabel();
		buttons.add(studyLabel);
		buttons.add(refreshButton);
		buttons.add(selectButton);
		buttons.add(stopButton);
		buttons.add(restartButton);
		buttons.add(deleteButton);
		add(buttons, c);

		c.weightx = 2.0;

		c.weighty = 2.0;
		content = new JTable();
		add(new JScrollPane(content), c);
		content.setDefaultRenderer(Float.class, new TableCellRenderer() {
			public Component getTableCellRendererComponent(JTable table,
					Object value, boolean isSelected, boolean hasFocus,
					int row, int column) {
				int val = (int) ((Float) value * 100.0);
				bar.setValue(val);
				bar.setString(val + "%");
				return bar;
			}
		});
		content.setDefaultRenderer(Timestamp.class,
				new DefaultTableCellRenderer() {
					private static final long serialVersionUID = 3969798253778193097L;

					public void setValue(Object value) {
						if (value == null)
							setText("");
						else
							setText(timeFormat.format(((Timestamp) value)
									.getTime()));
					}
				});

	}

	private JButton createButton(String icon, String command, String text) {
		JButton ret = new JButton(new ImageIcon(ClassLoader
				.getSystemResource(icon)));
		ret.setActionCommand(command);
		ret.setToolTipText(text);
		return ret;
	}

	public JTable getContent() {
		return content;
	}

	public void setStudy(String name, String version) {
		studyLabel.setText(name + " " + version);
	}

	public JButton getStopButton() {
		return stopButton;
	}

	public JButton getCancelButton() {
		return cancelButton;
	}

	public JButton getRefreshButton() {
		return refreshButton;
	}

	public JButton getRestartButton() {
		return restartButton;
	}

	public JButton getSelectButton() {
		return selectButton;
	}

	public JButton getDeleteButton() {
		return deleteButton;
	}
}
