/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PackageChooseDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 6696615208799106880L;

	private boolean valid;
	
	private JComboBox name = new JComboBox();
	
	private JComboBox version = new JComboBox();
	
	private JButton okButton = new JButton("ok");
	
	private JButton cancelButton = new JButton("cancel");
	
	private Map<String, List<String>> versions;
	
	public PackageChooseDialog(Map<String, List<String>> versions) {
		super((Frame)null, "add package", true);
		this.versions = versions;
		name.addActionListener(this);
		JPanel content = new JPanel();
		setContentPane(content);
		
		for (String n : versions.keySet()) {
			name.addItem(n);
		}
		
		content.setLayout(new BorderLayout());
		content.add(new JLabel("choose package name and version"), BorderLayout.NORTH);
		JPanel input = new JPanel();
		input.add(name);
		input.add(version);
		content.add(input, BorderLayout.CENTER);
		JPanel buttons = new JPanel();
		buttons.add(cancelButton);
		buttons.add(okButton);
		content.add(buttons, BorderLayout.SOUTH);
		cancelButton.addActionListener(this);
		okButton.addActionListener(this);
		setLocationRelativeTo( null );
		pack();
		setVisible(true);
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == cancelButton) {
			valid = false;
			setVisible(false);
		} else if (e.getSource() == okButton) {
			valid = true;
			setVisible(false);
		} else if (e.getSource() == name) {
			version.removeAllItems();
			
			List<String> currentVersions = versions.get(name.getSelectedItem());
			if (currentVersions == null) return;
			for (String v : currentVersions) {
				version.addItem(v);
			}
		}
	}

	public String getName() {
		if (valid)
			return (String)name.getSelectedItem();
		else
			return null;
	}

	public String getVersion() {
		if (valid)
			return (String)version.getSelectedItem();
		else
			return null;
	}
}
