/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PackageDefinitionDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 6696615208799106880L;

	private JComboBox names = new JComboBox();

	private JComboBox versions= new JComboBox();

	private JComboBox architectures = new JComboBox();
	
	private JTextField url = new JTextField();

	private JTextField localPath = new JTextField(16);

	private JButton chooseButton = new JButton("select");

	private JButton doneButton = new JButton("done");
	
	private JCheckBox upload = new JCheckBox();

	private JButton defineButton = new JButton("define");

	private JFileChooser fileChooser = new JFileChooser();
	
	public PackageDefinitionDialog(List<String> initNames) {
		super((Frame) null, "define packages", true);
		names.setEditable(true);
		versions.setEditable(true);
		architectures.setEditable(true);
		JPanel content = new JPanel();
		setContentPane(content);
		
		names.addItem("");
		for (String n : initNames) {
			names.addItem(n);
		}
		
		content.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.weightx = 4.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.insets = new Insets(5,5,5,5);
		content.add(new JLabel("name: "));
		content.add(names,c);
		content.add(new JLabel("version: "));
		content.add(versions, c);
		content.add(new JLabel("architecture: "));
		content.add(architectures,c);
		content.add(new JLabel("URL: "));
		content.add(url, c);
		content.add(new JLabel("upload file? "));
		content.add(upload);
		content.add(chooseButton);
		c.weightx = 1.0;
		content.add(localPath, c);
		localPath.setEnabled(false);	
		chooseButton.setEnabled(false);
		JPanel buttons = new JPanel();
		buttons.add(defineButton);
		buttons.add(doneButton);
		content.add(buttons,c);
		
		upload.addActionListener(this);
		doneButton.addActionListener(this);
		chooseButton.addActionListener(this);
		setLocationRelativeTo( null );
	//	pack();
	//	setVisible(true);
	}

	public JButton getDefineButton() {
		return defineButton;
	}
	
	public JComboBox getVersions() {
		return versions;
	}
	
	public JComboBox getArchitectures() {
		return architectures;
	}
	
	public JComboBox getNames() {
		return names;
	}
	
	public String getUrl() {
		return url.getText();
	}
	
	public String getLocalPath() {
		if (upload.isSelected()) 
			return localPath.getText();
		else 
			return null;
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == upload) {
			if (upload.isSelected()) {
				localPath.setEnabled(true);
				chooseButton.setEnabled(true);
			} else {
				localPath.setEnabled(false);
				chooseButton.setEnabled(false);
			}
		} else if (e.getSource() == doneButton) {
			setVisible(false);
		} else if (e.getSource() == chooseButton) {
			fileChooser.setSelectedFile(new File(localPath.getText()));
			int returnVal = fileChooser.showOpenDialog(null);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				localPath.setText(fileChooser.getSelectedFile().getAbsolutePath());
			}
		}
		
	}

}
