/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

import brn.distsim.client.tableModels.ParametersTableModel;


public class ParameterCellEditor extends AbstractCellEditor implements
		TableCellEditor, ActionListener {

	private boolean editingString;

	private boolean valid;

	private JTable table;

	private String result[] = new String[3];

	private JDialog dialog = new JDialog();

	private static final long serialVersionUID = 4780463575723720854L;

	private JLabel minLabel = new JLabel("min: ");

	private JLabel maxLabel = new JLabel("max: ");

	private JLabel stepLabel = new JLabel("step: ");

	private JTextField minVal = new JTextField(32);

	private JTextField maxVal = new JTextField(32);

	private JTextField stepVal = new JTextField(32);

	private JComboBox stringChooser = new JComboBox();

	private int selected;

	private JPanel content = new JPanel();

	private JPanel buttons = new JPanel();

	private JButton okButton = new JButton("ok");

	private JButton cancelButton = new JButton("cancel");

	public ParameterCellEditor() {
		dialog.setContentPane(content);
		dialog.setLocationRelativeTo(null);
		stringChooser.setEditable(true);
		stringChooser.addActionListener(this);

		content.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		content.add(minLabel);
		content.add(minVal, c);
		content.add(maxLabel);
		content.add(maxVal, c);
		content.add(stepLabel);
		content.add(stepVal, c);

		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		buttons.add(cancelButton);
		buttons.add(okButton);
		content.add(buttons, c);
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int row, int column) {
		this.table = table;

		int stringStart = ((ParametersTableModel) table.getModel())
				.getStringStart();
		if (row < stringStart) {
			if (value != null)
				result = (String[]) value;
			minVal.setText(result[0]);
			maxVal.setText(result[1]);
			if (result[2] == null || result[2].equals("")) {
				stepVal.setText("1");
			} else {
				stepVal.setText(result[2]);
			}
			editingString = false;
			valid = false;
			dialog.getRootPane().setDefaultButton(okButton);
			dialog.pack();
			dialog.setVisible(true);
			minVal.requestFocus();
			return new JLabel("editing");
		} else {
			stringChooser.removeAllItems();
			for (Object val : (Collection) value) {
				stringChooser.addItem(val);
			}
			stringChooser.addItem("");
			editingString = true;
			return stringChooser;
		}

	}

	public Object getCellEditorValue() {
		if (editingString) {
			int size = stringChooser.getItemCount();
			Set<String> val = new HashSet<String>();
			for (int i = 0; i < size; ++i) {
				String item = (String) stringChooser.getItemAt(i);
				if (i == selected) {
					val.add((String) stringChooser.getSelectedItem());
				} else if (item == null || item.equals("")) {
					continue;
				} else {
					val.add(item);
				}
			}

			return val;
		} else if (valid) {
			result[0] = minVal.getText();
			result[1] = maxVal.getText();
			result[2] = stepVal.getText();
		}
		return result;
	}

	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if (source == okButton) {
			valid = true;
			dialog.setVisible(false);
		} else if (source == cancelButton) {
			valid = false;
			dialog.setVisible(false);
		} else if (stringChooser.getSelectedIndex() != -1) {
			selected = stringChooser.getSelectedIndex();
			return;
		}
		fireEditingStopped();
		table.requestFocus();
	}

}
