/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParameterDialog extends JDialog implements ActionListener {

	public static final int NUMERIC = 1;

	public static final int STRING = 0;

	private static final long serialVersionUID = -3327828924133170221L;

	private static String[] options = { "list of literals", "range of expressions" };

	private boolean valid = false;

	private JPanel content = new JPanel();

	private GridBagConstraints c = new GridBagConstraints();

	private JComboBox type = new JComboBox(options);

	private JTextField name = new JTextField(16);

	private JPanel buttons = new JPanel();

	private JButton okButton = new JButton("ok");

	private JButton cancelButton = new JButton("cancel");

	public ParameterDialog() {
		super((Frame) null, "new parameter", true);
		content.setLayout(new GridBagLayout());
		type.addActionListener(this);

		c.gridwidth = GridBagConstraints.REMAINDER;
		setContentPane(content);
		content.add(type, c);
		content.add(new JLabel("name: "));
		content.add(name, c);

		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		buttons.add(cancelButton);
		buttons.add(okButton);
		content.add(buttons, c);
		setLocationRelativeTo( null );
		getRootPane().setDefaultButton(okButton);
		pack();
		setVisible(true);
		name.requestFocus();
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == cancelButton) {
			valid = false;
			setVisible(false);
		} else if (e.getSource() == okButton) {
			valid = true;
			setVisible(false);
		}
	}

	public int getType() {
		int selected = type.getSelectedIndex();
		if (selected == -1) return 0;
		else return type.getSelectedIndex();
	}

	public String getName() {
		if (valid)
			return name.getText();
		else
			return null;
	}
}
