/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

public class ResultsPanel extends JPanel {

	private static final long serialVersionUID = -4736197828745540013L;

	private JToolBar toolBar;

	private JComboBox tableChooser;

	private GridBagConstraints tableConstraints;

	private GridBagConstraints labelConstraints;

	private JButton focus;

	private JButton reload;

	private JPanel parents;

	private JPanel children;

	private LinkedList<JTable> parentTables;

	private LinkedList<JTable> childTables;

	private RowSelectionSynchronizer parentSynchronizer;

	public ResultsPanel() {
		GridBagLayout layout = new GridBagLayout();
		parents = new JPanel();
		parents.setLayout(new GridBagLayout());
		tableConstraints = new GridBagConstraints();
		tableConstraints.weightx = 1.0;
		tableConstraints.weighty = 1.0;
		tableConstraints.fill = GridBagConstraints.BOTH;
		labelConstraints = new GridBagConstraints();
		labelConstraints.weighty = 1.0;
		labelConstraints.fill = GridBagConstraints.BOTH;
		children = new JPanel();
		this.setLayout(layout);
		GridBagConstraints endRow = new GridBagConstraints();
		endRow.gridwidth = GridBagConstraints.REMAINDER;
		endRow.fill = GridBagConstraints.BOTH;
		tableChooser = new JComboBox();
		tableChooser.setActionCommand("select");
		reload = new JButton("reload");
		//focus = new JButton("focus");
		toolBar = new JToolBar();
		toolBar.add(tableChooser);
		//toolBar.add(focus);
		toolBar.add(reload);
		add(toolBar, endRow);
		endRow.weightx = 2.0;
		endRow.weighty = 2.0;
		add(new JScrollPane(parents), endRow);
		add(new JScrollPane(children), endRow);
		parentTables = new LinkedList<JTable>();
		childTables = new LinkedList<JTable>();
		parentSynchronizer = new RowSelectionSynchronizer();
		revalidate();
	}

	public void clearTables() {
		clearChildTables();
		parentSynchronizer.clear();
		parents.removeAll();
		parentTables.clear();
	}

	public void clearChildTables() {
		children.removeAll();
		childTables.clear();
	}

	public JTable addParentTable(String label, Vector captions, Vector data) {
		parents.add(new JLabel(verticalFormat(label)), labelConstraints);
		JTable table = new JTable(data, captions);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		if (!captions.isEmpty())
			parents.add(new JScrollPane(table), tableConstraints);
		else
			parents.add(new JLabel("   "));
		parentTables.add(table);
		parentSynchronizer.addTable(table);
		//parents.revalidate();
		revalidate();
		return table;
	}

	private String verticalFormat(String label) {
		String chars[] = label.split("");
		String formattedLabel = "<html>";

		for (String c : chars) {
			formattedLabel += (c + "<br>");
		}
		return formattedLabel + "</html>";
	}

	public JTable addChildTable(String label, Vector captions, Vector data) {
		children.add(new JLabel(verticalFormat(label)), labelConstraints);
		JTable table = new JTable(data, captions);
		if (!captions.isEmpty())
			children.add(new JScrollPane(table), tableConstraints);
		else
			children.add(new JScrollPane(table));
		//children.revalidate();
		childTables.add(table);
		revalidate();
		return table;
	}

	public JComboBox getTableChooser() {
		return tableChooser;
	}

	public JButton getFocusButton() {
		return focus;
	}

	public JButton getReloadButton() {
		return reload;
	}
}
