/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.util.HashMap;
import java.util.Map;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class SelectionSynchronizer implements TableColumnModelListener {

	Map<ListSelectionModel, JTable> tables = new HashMap<ListSelectionModel, JTable>();

	public void columnSelectionChanged(ListSelectionEvent arg0) {
		try {
			JTable source = tables.get(arg0.getSource());
			int col = source.getSelectedColumn();
			if (col >= 0) {
				for (JTable tbl : tables.values()) {
					tbl.setColumnSelectionInterval(col, col);
				}
			}
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		}
	}

	public void addTable(JTable table) {
		TableColumnModel model = table.getColumnModel();
		model.addColumnModelListener(this);
		tables.put(model.getSelectionModel(), table);
	}

	public void columnAdded(TableColumnModelEvent arg0) {
	}

	public void columnMarginChanged(ChangeEvent arg0) {
	}

	public void columnMoved(TableColumnModelEvent arg0) {
	}

	public void columnRemoved(TableColumnModelEvent arg0) {
	}
	
	public void clear() {
		tables.clear();
	}

}
