/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

public class SimulationPanel extends JPanel {

	private static final long serialVersionUID = 7137892365997004599L;

	private List<JButton> groupButtons;

	private JToolBar simulationToolBar = null;

	private AddRemoveToolBar parametersToolBar = null;

	private AddRemoveToolBar inFilesToolBar = null;

	private AddRemoveToolBar outFilesToolBar = null;

	private JTable parametersTable = null;

	private JTable filesInTable = null;

	private JTable filesOutTable = null;

	/**
	 * This is the default constructor
	 */
	public SimulationPanel() {
		super();
		groupButtons = new LinkedList<JButton>();
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		GridBagLayout gridLayout = new GridBagLayout();

		this.setLayout(gridLayout);

		GridBagConstraints c = new GridBagConstraints();
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.BOTH;

		add(getParametersToolBar());
		add(getInFilesToolBar());
		add(getOutFilesToolBar());
		add(getSimulationToolBar(), c);
		c.weightx = 2.0;

		c.weighty = 2.0;
		this.add(new JScrollPane(getParametersTable()), c);

		c.weighty = 1.0;
		this.add(new JScrollPane(getFilesInTable()), c);

		c.gridheight = GridBagConstraints.REMAINDER;
		this.add(new JScrollPane(getFilesOutTable()), c);

		SelectionSynchronizer synch = new SelectionSynchronizer();
		synch.addTable(getParametersTable());
		synch.addTable(getFilesInTable());
		synch.addTable(getFilesOutTable());
		revalidate();
	}

	public List<JButton> getGroupButtons() {
		return groupButtons;
	}

	private JButton createButton(String text, String command, String iconPath) {
		JButton button = new JButton(new ImageIcon(ClassLoader
				.getSystemResource(iconPath)));
		button.setToolTipText(text);
		button.setActionCommand(command);
		groupButtons.add(button);
		return button;
	}

	/**
	 * This method initializes simulationToolBar
	 *
	 * @return javax.swing.JToolBar
	 */
	public JToolBar getSimulationToolBar() {
		if (simulationToolBar == null) {
			simulationToolBar = new JToolBar();
			simulationToolBar.add(new JLabel("Groups"));
			simulationToolBar.add(createButton("commit", "commit",
					"toolbarButtonGraphics/general/Save24.gif"));
			simulationToolBar.add(createButton("rollback", "rollback",
					"toolbarButtonGraphics/general/Undo24.gif"));
			simulationToolBar.add(createButton("create group", "create",
					"toolbarButtonGraphics/general/Add24.gif"));
			simulationToolBar.add(createButton("clone group", "clone",
					"toolbarButtonGraphics/general/Copy24.gif"));
			simulationToolBar.add(createButton("delete group", "remove",
					"toolbarButtonGraphics/general/Delete24.gif"));
			simulationToolBar.add(createButton(
					"create and start simulations for ALL groups",
					"select", "toolbarButtonGraphics/general/Export24.gif"));
			simulationToolBar.add(createButton(
					"create and start simulations for SELECTED group",
					"selectSingle", "toolbarButtonGraphics/general/Export24.gif"));

		}
		return simulationToolBar;
	}

	public AddRemoveToolBar getParametersToolBar() {
		if (parametersToolBar == null) {
			parametersToolBar = new AddRemoveToolBar("Parameters", "parameter");
		}
		return parametersToolBar;
	}

	public AddRemoveToolBar getInFilesToolBar() {
		if (inFilesToolBar == null) {
			inFilesToolBar = new AddRemoveToolBar("Configuration Files",
					"configuration file");
		}
		return inFilesToolBar;
	}

	public AddRemoveToolBar getOutFilesToolBar() {
		if (outFilesToolBar == null) {
			outFilesToolBar = new AddRemoveToolBar("Results Files",
					"results file");
		}
		return outFilesToolBar;
	}

	/**
	 * This method initializes optionsTable
	 *
	 * @return javax.swing.JTable
	 */
	public JTable getParametersTable() {
		if (parametersTable == null) {
			parametersTable = new JTable();

			parametersTable.setColumnSelectionAllowed(true);
			parametersTable.setRowSelectionAllowed(false);
			parametersTable
					.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			parametersTable.setDefaultEditor(Object.class,
					new ParameterCellEditor());
			parametersTable.setDefaultRenderer(Object.class,
					new DefinitionsCellRenderer());
			//parametersTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			parametersTable.setSurrendersFocusOnKeystroke(true);
			parametersTable.getTableHeader().setReorderingAllowed(false);
		}
		return parametersTable;
	}

	/**
	 * This method initializes filesInTable
	 *
	 * @return javax.swing.JTable
	 */
	public JTable getFilesInTable() {
		if (filesInTable == null) {
			filesInTable = new JTable();
			filesInTable.setColumnSelectionAllowed(true);
			filesInTable.setRowSelectionAllowed(false);
			filesInTable.setDefaultEditor(Object.class, new FileCellEditor());
			filesInTable.setDefaultRenderer(Object.class,
					new TextCellRenderer());
			filesInTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			filesInTable.getTableHeader().setReorderingAllowed(false);
			//filesInTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		}
		return filesInTable;
	}

	/**
	 * This method initializes filesOutTable
	 *
	 * @return javax.swing.JTable
	 */
	public JTable getFilesOutTable() {
		if (filesOutTable == null) {
			filesOutTable = new JTable();
			filesOutTable.setColumnSelectionAllowed(true);
			filesOutTable.setRowSelectionAllowed(false);
			filesOutTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			filesOutTable.setDefaultRenderer(Boolean.class,
					new CheckBoxCellRenderer());
			filesOutTable.setDefaultRenderer(String.class,
					new TextCellRenderer());
			filesOutTable.getTableHeader().setReorderingAllowed(false);
			//filesOutTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		}
		return filesOutTable;
	}

} // @jve:decl-index=0:visual-constraint="10,10"
