/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

public class StudyPanel extends JPanel {

	private static final long serialVersionUID = 1L;

	private JToolBar studyToolBar = null;

	private JButton commitButton = null;

	private JButton rollbackButton = null;

	private JButton createButton = null;

	private JButton removeButton = null;

	private JButton selectStudyButton = null;

	private JButton definePackagesButton = null;

	private AddRemoveToolBar packagesToolBar = null;

	private JTable packagesTable = null;

	private JComboBox studyNameComboBox = null;

	private JTable studyTable = null;

	/**
	 * This is the default constructor
	 */
	public StudyPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		GridBagConstraints tableConstraints = new GridBagConstraints();
		tableConstraints.fill = GridBagConstraints.BOTH;
		tableConstraints.weightx = 1.0;
		tableConstraints.weighty = 1.0;
		tableConstraints.gridwidth = GridBagConstraints.REMAINDER;
		GridBagConstraints toolBarConstraints = new GridBagConstraints();
		toolBarConstraints.fill = GridBagConstraints.BOTH;
		this.setLayout(new GridBagLayout());
		this.add(getStudyToolBar(), toolBarConstraints);
		toolBarConstraints.gridwidth = GridBagConstraints.REMAINDER;
		this.add(getPackagesToolBar(), toolBarConstraints);
		this.add(new JScrollPane(getStudyTable()), tableConstraints);

		tableConstraints.gridheight = GridBagConstraints.REMAINDER;
		this.add(new JScrollPane(getPackagesTable()), tableConstraints);
		revalidate();
	}

	public JToolBar getStudyToolBar() {
		if (studyToolBar == null) {
			studyToolBar = new JToolBar();
			studyToolBar.add(getCommitButton());
			studyToolBar.add(getRollbackButton());
			studyToolBar.add(getCreateButton());
			studyToolBar.add(getRemoveButton());
			studyToolBar.add(getStudyNameComboBox());
			studyToolBar.add(getSelectStudyButton());
		}
		return studyToolBar;
	}

	public JComboBox getStudyNameComboBox() {
		if (studyNameComboBox == null) {
			studyNameComboBox = new JComboBox();
			studyNameComboBox.setActionCommand("display");
			studyNameComboBox.setEditable(true);
		}
		return studyNameComboBox;
	}

	public JButton getDefinePackagesButton() {
		if (definePackagesButton == null) {
			definePackagesButton = createButton("define packages", "define",
					"toolbarButtonGraphics/general/Add24.gif");
		}
		return definePackagesButton;
	}

	/**
	 * This method initializes commitButton
	 *
	 * @return javax.swing.JButton
	 */
	public JButton getCommitButton() {
		if (commitButton == null) {
			commitButton = createButton("save studies", "commit",
					"toolbarButtonGraphics/general/Save24.gif");
		}
		return commitButton;
	}

	private JButton createButton(String text, String command, String iconPath) {
		JButton button = new JButton(new ImageIcon(ClassLoader
				.getSystemResource(iconPath)));
		button.setToolTipText(text);
		button.setActionCommand(command);
		return button;
	}

	public JButton getSelectStudyButton() {
		if (selectStudyButton == null) {
			selectStudyButton = createButton(
					"load simulation groups for the selected study", "select",
					"toolbarButtonGraphics/general/Export24.gif");
		}
		return selectStudyButton;
	}

	public JButton getRemoveButton() {
		if (removeButton == null) {
			removeButton = createButton("remove study", "remove",
					"toolbarButtonGraphics/general/Delete24.gif");
		}
		return removeButton;
	}

	/**
	 * This method initializes rollBackButton
	 *
	 * @return javax.swing.JButton
	 */
	public JButton getRollbackButton() {
		if (rollbackButton == null) {
			rollbackButton = createButton("undo changes", "rollback",
					"toolbarButtonGraphics/general/Undo24.gif");
		}
		return rollbackButton;
	}

	public JButton getCreateButton() {
		if (createButton == null) {
			createButton = createButton("branch study", "clone",
					"toolbarButtonGraphics/general/Copy24.gif");
		}
		return createButton;
	}

	/**
	 * This method initializes typeTable
	 *
	 * @return javax.swing.JTable
	 */
	public JTable getStudyTable() {
		if (studyTable == null) {
			studyTable = new JTable();
			studyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
		return studyTable;
	}

	public AddRemoveToolBar getPackagesToolBar() {
		if (packagesToolBar == null) {
			packagesToolBar = new AddRemoveToolBar("Packages", "package");
			packagesToolBar.add(getDefinePackagesButton());
		}
		return packagesToolBar;
	}

	/**
	 * This method initializes packageTable
	 *
	 * @return javax.swing.JTable
	 */
	public JTable getPackagesTable() {
		if (packagesTable == null) {
			packagesTable = new JTable();
			packagesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
		return packagesTable;
	}
}
