/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.class2hbm;

/**
 * @version 1.x
 * @author <a href="mailto:doug.currie@alum.mit.edu">e</a>
 * @auther <a href="mailto:uhermann@informatik.hu-berlin.de">Ulf Hermann</a>
 */
class ReflectedArrayProperty extends ReflectedProperty {

	protected ReflectedProperty element;

	/**
	 * Constructor for ReflectedArrayProperty.
	 * 
	 * @param name
	 * @param type
	 */
	ReflectedArrayProperty(String name, Class type, MapGenerator map,
			String className) {
		super(name, type, map, "array", className, true);
		this.element = null;
		Class elmcls = type.getComponentType();
		if (elmcls == null) {
			// huh! not an array after all!?
			// use type.getName() in case tynm modified
			return;
		}
		String roleName = elmcls.getName();
		this.element = map.makeProperty("", roleName, elmcls);
		// TO DO
		// if elmcls is a collection, it would be nice to make
		// the top level collection template here with role name roleName
	}

	protected void getXMLinArray(int level, StringBuffer buf) {
		this.buf = buf;
		throw new IllegalArgumentException("can't map multidimensional arrays");
	}

	protected void getXMLinComposite(int level, StringBuffer buf) {
		this.buf = buf;
		emitCollectionInCompositeStr(level);
	}

	// <!ELEMENT array (key, index,
	// (element|one-to-many|many-to-many|subcollection|composite-element))>
	// <!ATTLIST array role CDATA #REQUIRED>
	// <!ATTLIST array table CDATA #IMPLIED>

	protected void getXML(int level, StringBuffer buf) {
		this.buf = buf;
		if (element != null) {
			boolean p = element.type.isPrimitive();
			emitCollectionStrL(level, p ? "primitive-array" : "array", name);
			emitCollectionStrK(level + 1, "uid");
			emitCollectionStrI(level + 1, "idx");
			element.getXMLinArray(level + 1, buf);
			emitCollectionStrR(level, p ? "primitive-array" : "array");
		}
	}

	protected void emitCollectionStrL(int level, String collection, String name) {
		if (element.type.isPrimitive() || isHbmType(element.tynm)) {
			map.emitPrefix(level);
			buf.append("<").append(collection).append(" name=\"").append(name)
					.append("\" table=\"").append(subTableName).append(
							"\" access=\"field");
			buf.append("\">\n");
		} else {
			super.emitCollectionStrL(level, collection, name, false, false);
		}

	}
}
