/*
 * This file is part of the DistSim distributed simulation framework (wrapper)
 * Copyright (C) 2008 Mathias Kurth
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package brn.distsim;

import brn.distsim.jmx.Description;
import brn.distsim.jmx.Name;

/**
 * TODO display wrapper state (running, paused, stopped)
 * TODO display no. wrappers per distsim
 *
 * @author kurth
 */
@Description("MXBean for the federated management of Distsim server instances")
public interface DistsimManagerMXBean {


  @Description("Shut down the local server process")
  public void shutDown();

  @Description("Currently running wrappers")
  WrapperData[] getActiveWrappers();


  @Description("Currently running distsim servers")
  String[] getActiveDistsims();


  @Description("Point in time the wrapper was started")
  String getStartTime();


  @Description("Manage another distsim server on the specified host using the default port")
  void addDistsim(
      @Name("hostList") @Description("List of socket addresses of the servers") String host);


//  @Description("Manage another distsim server on the specified host and port")
//  void addDistsim(
//      @Name("host") @Description("Host name of the server") String host,
//      @Name("port") @Description("Port number of the server") int port);


  @Description("Manages all distsim servers specified in the database")
  void addDistsimFromDb(
      @Name("dbHost") @Description("Host name of the database server") String dbHost,
      @Name("dbName") @Description("Definitions database name") String dbName,
      @Name("dbUser") @Description("Definitions database user name") String dbUser,
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd);


  @Description("Exclude the specified server from management")
  void removeDistsim(
      @Name("host") @Description("Socket address of the server") String host);


  @Description("Exclude all connected servers from management")
  void removeDistsimAll();


  @Description("Stop the specififed distsim server and associated wrappers")
  void stopDistsim(
      @Name("host") @Description("Host name of the server") String host);


  @Description("Stop all distsim servers and wrappers")
  void stopDistsimAll();

  @Description("Restart the local server process and refresh sources")
  public void restart();

  @Description("Restart all server process and refresh sources")
  public void restartAll();

  @Description("Start the given number of wrappers on the given host")
  void startWrapper(
      @Name("host") @Description("Host name of the server") String host,
      @Name("idStart") @Description("Start if of the wrapper") int idStart,
      @Name("number") @Description("Number of wrappers to start") int number,
      @Name("dbHost") @Description("Host name of the database server") String dbHost,
      @Name("dbName") @Description("Definitions database name") String dbName,
      @Name("dbUser") @Description("Definitions database user name") String dbUser,
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd);


  @Description("Start the given number of wrappers on the given host")
  void startWrapperAll(
      @Name("startString") @Description("Enumeration of 'host[:rmi-port] start-id:number-of'") String startString,
      @Name("dbHost") @Description("Host name of the database server") String dbHost,
      @Name("dbName") @Description("Definitions database name") String dbName,
      @Name("dbUser") @Description("Definitions database user name") String dbUser,
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd);


  @Description("Stop the wrappers on the given host")
  void stopWrapper(
      @Name("host") @Description("Host name of the server") String host);


  @Description("Stop all wrappers on all hosts")
  void stopWrapperAll();


  @Description("Pause all wrappers on all hosts")
  void pauseWrapperAll();


  @Description("Continue all wrappers on all hosts")
  void continueWrapperAll();


  @Description("Change the database on all wrappers.")
  void changeDatabaseAll(
      @Name("dbHost") @Description("Definitions database host name") String dbHost,
      @Name("dbName") @Description("Definitions database name") String dbName,
      @Name("dbUser") @Description("Definitions database user name") String dbUser,
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd,

      @Name("dbResHost") @Description("Result database host name") String dbResHost,
      @Name("dbResName") @Description("Result database name") String dbResName,
      @Name("dbResUser") @Description("Result database user name") String dbResUser,
      @Name("dbResPasswd") @Description("Result database password") String dbResPasswd);

}
