/*
 * This file is part of the DistSim distributed simulation framework (wrapper)
 * Copyright (C) 2008 Mathias Kurth
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package brn.distsim;

import brn.distsim.jmx.Description;
import brn.distsim.jmx.Name;

@Description("MXBean for the management of local Wrapper instances")
public interface WrapperManagerMXBean {

  @Description("Currently running wrappers")
  WrapperData[] getActiveWrappers();

  
  @Description("Start wrapper instance (definition = result database)")
  void startWrapper(
      @Name("idStart") @Description("Start if of the wrapper") int idStart, 
      @Name("number") @Description("Number of wrappers to start") int number, 

      @Name("dbHost") @Description("Definitions database host name") String dbHost, 
      @Name("dbName") @Description("Definitions database name") String dbName, 
      @Name("dbUser") @Description("Definitions database user name") String dbUser, 
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd);
  
  
  @Description("Start wrapper instance")
  void startWrapper(
      @Name("idStart") @Description("Start if of the wrapper") int idStart, 
      @Name("number") @Description("Number of wrappers to start") int number, 

      @Name("dbHost") @Description("Definitions database host name") String dbHost, 
      @Name("dbName") @Description("Definitions database name") String dbName, 
      @Name("dbUser") @Description("Definitions database user name") String dbUser, 
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd,
      
      @Name("dbResHost") @Description("Result database host name") String dbResHost, 
      @Name("dbResName") @Description("Result database name") String dbResName, 
      @Name("dbResUser") @Description("Result database user name") String dbResUser, 
      @Name("dbResPasswd") @Description("Result database password") String dbResPasswd);

  
  @Description("Stop the wrappers with the given id")
  void stopWrapper(
      @Name("id") @Description("Id of the wrapper") int id);

  
  @Description("Stop all wrappers")
  void stopWrapperAll();


  @Description("Pause all local wrappers")
  void pauseWrapperAll();


  @Description("Resume all local wrappers")
  void continueWrapperAll();
  

  @Description("Change the database on all local wrappers")
  void changeDatabaseAll( 
      @Name("dbHost") @Description("Definitions database host name") String dbHost, 
      @Name("dbName") @Description("Definitions database name") String dbName, 
      @Name("dbUser") @Description("Definitions database user name") String dbUser, 
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd,
      
      @Name("dbResHost") @Description("Result database host name") String dbResHost, 
      @Name("dbResName") @Description("Result database name") String dbResName, 
      @Name("dbResUser") @Description("Result database user name") String dbResUser, 
      @Name("dbResPasswd") @Description("Result database password") String dbResPasswd);

}
