/*
 * This file is part of the DistSim distributed simulation framework (wrapper)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.wrapper;

import brn.distsim.jmx.Description;
import brn.distsim.jmx.Name;


public interface MainMXBean {

  /**
   * @return true if successful, else false
   */
  @Description("stop the wrapper immediately and don't accept any more simulations")
  boolean stop();

  
  /**
   * @return true if successful, else false
   */
  @Description("stop the wrapper after finishing the currently running simulation")
  boolean stopLater();

  
  @Description("Pause the simulation execution after finishing the current one.")
  void pauseSim();

  
  @Description("Continue after pause.")
  void continueSim();

  
  /**
   * @return true if the simulation is canceled, false otherwise
   */
  @Description("cancel the current simulation, but keep the host running and accept new jobs")
  boolean cancelSim();


  @Description("Current simulation information")
  String getCurrentSimulation();
  
  @Description("Change the database on all local wrappers")
  void changeDatabase( 
      @Name("dbHost") @Description("Definitions database host name") String dbHost, 
      @Name("dbName") @Description("Definitions database name") String dbName, 
      @Name("dbUser") @Description("Definitions database user name") String dbUser, 
      @Name("dbPasswd") @Description("Definitions database password") String dbPasswd,
      
      @Name("dbResHost") @Description("Result database host name") String dbResHost, 
      @Name("dbResName") @Description("Result database name") String dbResName, 
      @Name("dbResUser") @Description("Result database user name") String dbResUser, 
      @Name("dbResPasswd") @Description("Result database password") String dbResPasswd);

  
  @Description("Current configuration")
  Main.ConfigData getConfig();
  
  @Description("Current wrapper blacklist of simulations")
  Integer[] getBlackList();
}
