/*
 * This file is part of the DistSim distributed simulation framework (wrapper)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.wrapper;

import java.rmi.Remote;
import java.rmi.RemoteException;

public interface RemoteSimulation extends Remote {

	/**
	 * cancel the current simulation, but keep the host running and accept new jobs
	 * @return true if the simulation is canceled, false otherwise
	 */
	public boolean cancel() throws RemoteException;
	
	/**
	 * stop the wrapper immediately and don't accept any more simulations
	 * @return true if successful, else false
	 */
	public boolean stop() throws RemoteException;
	
	/**
	 * stop the wrapper after finishing the currently running simulation
	 * @return true if successful, else false
	 */
	public boolean stopLater() throws RemoteException;
	
}
