package brn.gui.fwdgraph.diagram.part;

import brn.gui.fwdgraph.diagram.edit.parts.GraphEditPart;

import org.eclipse.core.resources.IFile;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.emf.transaction.TransactionalEditingDomain;

import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;

import org.eclipse.jface.action.IAction;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * @generated
 */
public class ModelInitDiagramFileAction implements IObjectActionDelegate {

  /**
   * @generated
   */
  private IWorkbenchPart myPart;

  /**
   * @generated
   */
  private IFile mySelectedModelFile;

  /**
   * @generated
   */
  private IStructuredSelection mySelection;

  /**
   * @generated
   */
  public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    myPart = targetPart;
  }

  /**
   * @generated
   */
  public void selectionChanged(IAction action, ISelection selection) {
    mySelectedModelFile = null;
    mySelection = StructuredSelection.EMPTY;
    action.setEnabled(false);
    if (selection instanceof IStructuredSelection == false
        || selection.isEmpty()) {
      return;
    }
    mySelection = (IStructuredSelection) selection;
    mySelectedModelFile = (IFile) ((IStructuredSelection) selection)
        .getFirstElement();
    action.setEnabled(true);
  }

  /**
   * @generated
   */
  public void run(IAction action) {
    TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE
        .createEditingDomain();
    ResourceSet resourceSet = editingDomain.getResourceSet();
    EObject diagramRoot = null;
    try {
      Resource resource = resourceSet.getResource(URI
          .createPlatformResourceURI(mySelectedModelFile.getFullPath()
              .toString()), true);
      diagramRoot = (EObject) resource.getContents().get(0);
    } catch (WrappedException ex) {
      FwdGraphDiagramEditorPlugin
          .getInstance()
          .logError(
              "Unable to load resource: " + mySelectedModelFile.getFullPath().toString(), ex); //$NON-NLS-1$
    }
    if (diagramRoot == null) {
      MessageDialog.openError(myPart.getSite().getShell(), "Error",
          "Model file loading failed");
      return;
    }
    Wizard wizard = new ModelNewDiagramFileWizard(mySelectedModelFile, myPart
        .getSite().getPage(), mySelection, diagramRoot, editingDomain);
    IDialogSettings pluginDialogSettings = FwdGraphDiagramEditorPlugin
        .getInstance().getDialogSettings();
    IDialogSettings initDiagramFileSettings = pluginDialogSettings
        .getSection("InisDiagramFile"); //$NON-NLS-1$
    if (initDiagramFileSettings == null) {
      initDiagramFileSettings = pluginDialogSettings
          .addNewSection("InisDiagramFile"); //$NON-NLS-1$
    }
    wizard.setDialogSettings(initDiagramFileSettings);
    wizard.setForcePreviousAndNextButtons(false);
    wizard.setWindowTitle("Initialize new " + GraphEditPart.MODEL_ID
        + " diagram file");

    WizardDialog dialog = new WizardDialog(myPart.getSite().getShell(), wizard);
    dialog.create();
    dialog.getShell()
        .setSize(Math.max(500, dialog.getShell().getSize().x), 500);
    dialog.open();
  }

}