package brn.gui.fwdgraph.diagram.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import brn.gui.fwdgraph.diagram.part.FwdGraphDiagramEditorPlugin;

import brn.gui.fwdgraph.diagram.part.ModelDiagramEditorPlugin;

import brn.gui.graph.model.ModelPackage;

/**
 * @generated
 */
public class ModelElementTypes {

  /**
   * @generated
   */
  private ModelElementTypes() {
  }

  /**
   * @generated
   */
  private static Map elements;

  /**
   * @generated
   */
  private static ImageRegistry imageRegistry;

  /**
   * @generated
   */
  private static ImageRegistry getImageRegistry() {
    if (imageRegistry == null) {
      imageRegistry = new ImageRegistry();
    }
    return imageRegistry;
  }

  /**
   * @generated
   */
  private static String getImageRegistryKey(ENamedElement element) {
    return element.getName();
  }

  /**
   * @generated
   */
  private static ImageDescriptor getProvidedImageDescriptor(
      ENamedElement element) {
    if (element instanceof EStructuralFeature) {
      element = ((EStructuralFeature) element).getEContainingClass();
    }
    if (element instanceof EClass) {
      EClass eClass = (EClass) element;
      if (!eClass.isAbstract()) {
        return FwdGraphDiagramEditorPlugin.getInstance()
            .getItemImageDescriptor(
                eClass.getEPackage().getEFactoryInstance().create(eClass));
      }
    }
    // TODO : support structural features
    return null;
  }

  /**
   * @generated
   */
  public static ImageDescriptor getImageDescriptor(ENamedElement element) {
    String key = getImageRegistryKey(element);
    ImageDescriptor imageDescriptor = getImageRegistry().getDescriptor(key);
    if (imageDescriptor == null) {
      imageDescriptor = getProvidedImageDescriptor(element);
      if (imageDescriptor == null) {
        imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
      }
      getImageRegistry().put(key, imageDescriptor);
    }
    return imageDescriptor;
  }

  /**
   * @generated
   */
  public static Image getImage(ENamedElement element) {
    String key = getImageRegistryKey(element);
    Image image = getImageRegistry().get(key);
    if (image == null) {
      ImageDescriptor imageDescriptor = getProvidedImageDescriptor(element);
      if (imageDescriptor == null) {
        imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
      }
      getImageRegistry().put(key, imageDescriptor);
      image = getImageRegistry().get(key);
    }
    return image;
  }

  /**
   * @generated
   */
  public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
    ENamedElement element = getElement(hint);
    if (element == null) {
      return null;
    }
    return getImageDescriptor(element);
  }

  /**
   * @generated
   */
  public static Image getImage(IAdaptable hint) {
    ENamedElement element = getElement(hint);
    if (element == null) {
      return null;
    }
    return getImage(element);
  }

  /**
   * Returns 'type' of the ecore object associated with the hint.
   * 
   * @generated
   */
  public static ENamedElement getElement(IAdaptable hint) {
    Object type = hint.getAdapter(IElementType.class);
    if (elements == null) {
      elements = new IdentityHashMap();
      elements.put(Graph_79, ModelPackage.eINSTANCE.getGraph());
      elements.put(Node_1001, ModelPackage.eINSTANCE.getNode());
      elements.put(FwdLink_3001, ModelPackage.eINSTANCE.getFwdLink());
    }
    return (ENamedElement) elements.get(type);
  }

  /**
   * @generated
   */
  public static final IElementType Graph_79 = getElementType("brn.gui.fwdgraph.diagram.Graph_79"); //$NON-NLS-1$

  /**
   * @generated
   */
  public static final IElementType Node_1001 = getElementType("brn.gui.fwdgraph.diagram.Node_1001"); //$NON-NLS-1$

  /**
   * @generated
   */
  public static final IElementType FwdLink_3001 = getElementType("brn.gui.fwdgraph.diagram.FwdLink_3001"); //$NON-NLS-1$

  /**
   * @generated
   */
  private static IElementType getElementType(String id) {
    return ElementTypeRegistry.getInstance().getType(id);
  }

  /**
   * @generated
   */
  private static Set KNOWN_ELEMENT_TYPES;

  /**
   * @generated
   */
  public static boolean isKnownElementType(IElementType elementType) {
    if (KNOWN_ELEMENT_TYPES == null) {
      KNOWN_ELEMENT_TYPES = new HashSet();
      KNOWN_ELEMENT_TYPES.add(Graph_79);
      KNOWN_ELEMENT_TYPES.add(Node_1001);
      KNOWN_ELEMENT_TYPES.add(FwdLink_3001);
    }
    return KNOWN_ELEMENT_TYPES.contains(elementType);
  }
}
