/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package brn.gui.graph.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see brn.gui.graph.model.ModelFactory
 * @model kind="package"
 * @generated
 */
public interface ModelPackage extends EPackage {
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "model";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http:///brn/gui/graph/model.ecore";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "brn.gui.graph.model";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  ModelPackage eINSTANCE = brn.gui.graph.model.impl.ModelPackageImpl.init();

  /**
   * The meta object id for the '{@link brn.gui.graph.model.impl.GraphImpl <em>Graph</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see brn.gui.graph.model.impl.GraphImpl
   * @see brn.gui.graph.model.impl.ModelPackageImpl#getGraph()
   * @generated
   */
  int GRAPH = 0;

  /**
   * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GRAPH__NODES = 0;

  /**
   * The number of structural features of the '<em>Graph</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int GRAPH_FEATURE_COUNT = 1;

  /**
   * The meta object id for the '{@link brn.gui.graph.model.impl.LinkImpl <em>Link</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see brn.gui.graph.model.impl.LinkImpl
   * @see brn.gui.graph.model.impl.ModelPackageImpl#getLink()
   * @generated
   */
  int LINK = 1;

  /**
   * The feature id for the '<em><b>Source</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK__SOURCE = 0;

  /**
   * The feature id for the '<em><b>Target</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK__TARGET = 1;

  /**
   * The number of structural features of the '<em>Link</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_FEATURE_COUNT = 2;

  /**
   * The meta object id for the '{@link brn.gui.graph.model.impl.NodeImpl <em>Node</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see brn.gui.graph.model.impl.NodeImpl
   * @see brn.gui.graph.model.impl.ModelPackageImpl#getNode()
   * @generated
   */
  int NODE = 2;

  /**
   * The feature id for the '<em><b>Id</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE__ID = 0;

  /**
   * The feature id for the '<em><b>X</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE__X = 1;

  /**
   * The feature id for the '<em><b>Y</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE__Y = 2;

  /**
   * The feature id for the '<em><b>Source Connections</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE__SOURCE_CONNECTIONS = 3;

  /**
   * The feature id for the '<em><b>Target Connections</b></em>' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE__TARGET_CONNECTIONS = 4;

  /**
   * The number of structural features of the '<em>Node</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int NODE_FEATURE_COUNT = 5;

  /**
   * The meta object id for the '{@link brn.gui.graph.model.impl.FwdLinkImpl <em>Fwd Link</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see brn.gui.graph.model.impl.FwdLinkImpl
   * @see brn.gui.graph.model.impl.ModelPackageImpl#getFwdLink()
   * @generated
   */
  int FWD_LINK = 3;

  /**
   * The feature id for the '<em><b>Source</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__SOURCE = LINK__SOURCE;

  /**
   * The feature id for the '<em><b>Target</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__TARGET = LINK__TARGET;

  /**
   * The feature id for the '<em><b>Source Channel</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__SOURCE_CHANNEL = LINK_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Target Channel</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__TARGET_CHANNEL = LINK_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Flow Id</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__FLOW_ID = LINK_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Duplicate</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__DUPLICATE = LINK_FEATURE_COUNT + 3;

  /**
   * The feature id for the '<em><b>No Packets</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK__NO_PACKETS = LINK_FEATURE_COUNT + 4;

  /**
   * The number of structural features of the '<em>Fwd Link</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FWD_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 5;

  /**
   * The meta object id for the '{@link brn.gui.graph.model.impl.LinkTableLinkImpl <em>Link Table Link</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see brn.gui.graph.model.impl.LinkTableLinkImpl
   * @see brn.gui.graph.model.impl.ModelPackageImpl#getLinkTableLink()
   * @generated
   */
  int LINK_TABLE_LINK = 4;

  /**
   * The feature id for the '<em><b>Source</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__SOURCE = LINK__SOURCE;

  /**
   * The feature id for the '<em><b>Target</b></em>' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__TARGET = LINK__TARGET;

  /**
   * The feature id for the '<em><b>Metric</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__METRIC = LINK_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Seq</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__SEQ = LINK_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Age</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__AGE = LINK_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Permanent</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__PERMANENT = LINK_FEATURE_COUNT + 3;

  /**
   * The feature id for the '<em><b>Last Updated</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK__LAST_UPDATED = LINK_FEATURE_COUNT + 4;

  /**
   * The number of structural features of the '<em>Link Table Link</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LINK_TABLE_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 5;


  /**
   * Returns the meta object for class '{@link brn.gui.graph.model.Graph <em>Graph</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Graph</em>'.
   * @see brn.gui.graph.model.Graph
   * @generated
   */
  EClass getGraph();

  /**
   * Returns the meta object for the containment reference list '{@link brn.gui.graph.model.Graph#getNodes <em>Nodes</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Nodes</em>'.
   * @see brn.gui.graph.model.Graph#getNodes()
   * @see #getGraph()
   * @generated
   */
  EReference getGraph_Nodes();

  /**
   * Returns the meta object for class '{@link brn.gui.graph.model.Link <em>Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Link</em>'.
   * @see brn.gui.graph.model.Link
   * @generated
   */
  EClass getLink();

  /**
   * Returns the meta object for the reference '{@link brn.gui.graph.model.Link#getSource <em>Source</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Source</em>'.
   * @see brn.gui.graph.model.Link#getSource()
   * @see #getLink()
   * @generated
   */
  EReference getLink_Source();

  /**
   * Returns the meta object for the reference '{@link brn.gui.graph.model.Link#getTarget <em>Target</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference '<em>Target</em>'.
   * @see brn.gui.graph.model.Link#getTarget()
   * @see #getLink()
   * @generated
   */
  EReference getLink_Target();

  /**
   * Returns the meta object for class '{@link brn.gui.graph.model.Node <em>Node</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Node</em>'.
   * @see brn.gui.graph.model.Node
   * @generated
   */
  EClass getNode();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.Node#getId <em>Id</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id</em>'.
   * @see brn.gui.graph.model.Node#getId()
   * @see #getNode()
   * @generated
   */
  EAttribute getNode_Id();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.Node#getX <em>X</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>X</em>'.
   * @see brn.gui.graph.model.Node#getX()
   * @see #getNode()
   * @generated
   */
  EAttribute getNode_X();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.Node#getY <em>Y</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Y</em>'.
   * @see brn.gui.graph.model.Node#getY()
   * @see #getNode()
   * @generated
   */
  EAttribute getNode_Y();

  /**
   * Returns the meta object for the containment reference list '{@link brn.gui.graph.model.Node#getSourceConnections <em>Source Connections</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Source Connections</em>'.
   * @see brn.gui.graph.model.Node#getSourceConnections()
   * @see #getNode()
   * @generated
   */
  EReference getNode_SourceConnections();

  /**
   * Returns the meta object for the reference list '{@link brn.gui.graph.model.Node#getTargetConnections <em>Target Connections</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference list '<em>Target Connections</em>'.
   * @see brn.gui.graph.model.Node#getTargetConnections()
   * @see #getNode()
   * @generated
   */
  EReference getNode_TargetConnections();

  /**
   * Returns the meta object for class '{@link brn.gui.graph.model.FwdLink <em>Fwd Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Fwd Link</em>'.
   * @see brn.gui.graph.model.FwdLink
   * @generated
   */
  EClass getFwdLink();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.FwdLink#getSourceChannel <em>Source Channel</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Source Channel</em>'.
   * @see brn.gui.graph.model.FwdLink#getSourceChannel()
   * @see #getFwdLink()
   * @generated
   */
  EAttribute getFwdLink_SourceChannel();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.FwdLink#getTargetChannel <em>Target Channel</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Target Channel</em>'.
   * @see brn.gui.graph.model.FwdLink#getTargetChannel()
   * @see #getFwdLink()
   * @generated
   */
  EAttribute getFwdLink_TargetChannel();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.FwdLink#getFlowId <em>Flow Id</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Flow Id</em>'.
   * @see brn.gui.graph.model.FwdLink#getFlowId()
   * @see #getFwdLink()
   * @generated
   */
  EAttribute getFwdLink_FlowId();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.FwdLink#isDuplicate <em>Duplicate</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Duplicate</em>'.
   * @see brn.gui.graph.model.FwdLink#isDuplicate()
   * @see #getFwdLink()
   * @generated
   */
  EAttribute getFwdLink_Duplicate();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.FwdLink#getNoPackets <em>No Packets</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>No Packets</em>'.
   * @see brn.gui.graph.model.FwdLink#getNoPackets()
   * @see #getFwdLink()
   * @generated
   */
  EAttribute getFwdLink_NoPackets();

  /**
   * Returns the meta object for class '{@link brn.gui.graph.model.LinkTableLink <em>Link Table Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Link Table Link</em>'.
   * @see brn.gui.graph.model.LinkTableLink
   * @generated
   */
  EClass getLinkTableLink();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.LinkTableLink#getMetric <em>Metric</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Metric</em>'.
   * @see brn.gui.graph.model.LinkTableLink#getMetric()
   * @see #getLinkTableLink()
   * @generated
   */
  EAttribute getLinkTableLink_Metric();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.LinkTableLink#getSeq <em>Seq</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Seq</em>'.
   * @see brn.gui.graph.model.LinkTableLink#getSeq()
   * @see #getLinkTableLink()
   * @generated
   */
  EAttribute getLinkTableLink_Seq();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.LinkTableLink#getAge <em>Age</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Age</em>'.
   * @see brn.gui.graph.model.LinkTableLink#getAge()
   * @see #getLinkTableLink()
   * @generated
   */
  EAttribute getLinkTableLink_Age();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.LinkTableLink#isPermanent <em>Permanent</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Permanent</em>'.
   * @see brn.gui.graph.model.LinkTableLink#isPermanent()
   * @see #getLinkTableLink()
   * @generated
   */
  EAttribute getLinkTableLink_Permanent();

  /**
   * Returns the meta object for the attribute '{@link brn.gui.graph.model.LinkTableLink#getLastUpdated <em>Last Updated</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Last Updated</em>'.
   * @see brn.gui.graph.model.LinkTableLink#getLastUpdated()
   * @see #getLinkTableLink()
   * @generated
   */
  EAttribute getLinkTableLink_LastUpdated();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  ModelFactory getModelFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals  {
    /**
     * The meta object literal for the '{@link brn.gui.graph.model.impl.GraphImpl <em>Graph</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see brn.gui.graph.model.impl.GraphImpl
     * @see brn.gui.graph.model.impl.ModelPackageImpl#getGraph()
     * @generated
     */
    EClass GRAPH = eINSTANCE.getGraph();

    /**
     * The meta object literal for the '<em><b>Nodes</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference GRAPH__NODES = eINSTANCE.getGraph_Nodes();

    /**
     * The meta object literal for the '{@link brn.gui.graph.model.impl.LinkImpl <em>Link</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see brn.gui.graph.model.impl.LinkImpl
     * @see brn.gui.graph.model.impl.ModelPackageImpl#getLink()
     * @generated
     */
    EClass LINK = eINSTANCE.getLink();

    /**
     * The meta object literal for the '<em><b>Source</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference LINK__SOURCE = eINSTANCE.getLink_Source();

    /**
     * The meta object literal for the '<em><b>Target</b></em>' reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference LINK__TARGET = eINSTANCE.getLink_Target();

    /**
     * The meta object literal for the '{@link brn.gui.graph.model.impl.NodeImpl <em>Node</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see brn.gui.graph.model.impl.NodeImpl
     * @see brn.gui.graph.model.impl.ModelPackageImpl#getNode()
     * @generated
     */
    EClass NODE = eINSTANCE.getNode();

    /**
     * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute NODE__ID = eINSTANCE.getNode_Id();

    /**
     * The meta object literal for the '<em><b>X</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute NODE__X = eINSTANCE.getNode_X();

    /**
     * The meta object literal for the '<em><b>Y</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute NODE__Y = eINSTANCE.getNode_Y();

    /**
     * The meta object literal for the '<em><b>Source Connections</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference NODE__SOURCE_CONNECTIONS = eINSTANCE.getNode_SourceConnections();

    /**
     * The meta object literal for the '<em><b>Target Connections</b></em>' reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference NODE__TARGET_CONNECTIONS = eINSTANCE.getNode_TargetConnections();

    /**
     * The meta object literal for the '{@link brn.gui.graph.model.impl.FwdLinkImpl <em>Fwd Link</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see brn.gui.graph.model.impl.FwdLinkImpl
     * @see brn.gui.graph.model.impl.ModelPackageImpl#getFwdLink()
     * @generated
     */
    EClass FWD_LINK = eINSTANCE.getFwdLink();

    /**
     * The meta object literal for the '<em><b>Source Channel</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FWD_LINK__SOURCE_CHANNEL = eINSTANCE.getFwdLink_SourceChannel();

    /**
     * The meta object literal for the '<em><b>Target Channel</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FWD_LINK__TARGET_CHANNEL = eINSTANCE.getFwdLink_TargetChannel();

    /**
     * The meta object literal for the '<em><b>Flow Id</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FWD_LINK__FLOW_ID = eINSTANCE.getFwdLink_FlowId();

    /**
     * The meta object literal for the '<em><b>Duplicate</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FWD_LINK__DUPLICATE = eINSTANCE.getFwdLink_Duplicate();

    /**
     * The meta object literal for the '<em><b>No Packets</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FWD_LINK__NO_PACKETS = eINSTANCE.getFwdLink_NoPackets();

    /**
     * The meta object literal for the '{@link brn.gui.graph.model.impl.LinkTableLinkImpl <em>Link Table Link</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see brn.gui.graph.model.impl.LinkTableLinkImpl
     * @see brn.gui.graph.model.impl.ModelPackageImpl#getLinkTableLink()
     * @generated
     */
    EClass LINK_TABLE_LINK = eINSTANCE.getLinkTableLink();

    /**
     * The meta object literal for the '<em><b>Metric</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LINK_TABLE_LINK__METRIC = eINSTANCE.getLinkTableLink_Metric();

    /**
     * The meta object literal for the '<em><b>Seq</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LINK_TABLE_LINK__SEQ = eINSTANCE.getLinkTableLink_Seq();

    /**
     * The meta object literal for the '<em><b>Age</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LINK_TABLE_LINK__AGE = eINSTANCE.getLinkTableLink_Age();

    /**
     * The meta object literal for the '<em><b>Permanent</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LINK_TABLE_LINK__PERMANENT = eINSTANCE.getLinkTableLink_Permanent();

    /**
     * The meta object literal for the '<em><b>Last Updated</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LINK_TABLE_LINK__LAST_UPDATED = eINSTANCE.getLinkTableLink_LastUpdated();

  }

} //ModelPackage
