/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package brn.gui.graph.model.impl;

import brn.gui.graph.model.Link;
import brn.gui.graph.model.ModelPackage;
import brn.gui.graph.model.Node;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link brn.gui.graph.model.impl.NodeImpl#getId <em>Id</em>}</li>
 *   <li>{@link brn.gui.graph.model.impl.NodeImpl#getX <em>X</em>}</li>
 *   <li>{@link brn.gui.graph.model.impl.NodeImpl#getY <em>Y</em>}</li>
 *   <li>{@link brn.gui.graph.model.impl.NodeImpl#getSourceConnections <em>Source Connections</em>}</li>
 *   <li>{@link brn.gui.graph.model.impl.NodeImpl#getTargetConnections <em>Target Connections</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NodeImpl extends EObjectImpl implements Node {
  /**
   * The default value of the '{@link #getId() <em>Id</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getId()
   * @generated
   * @ordered
   */
  protected static final int ID_EDEFAULT = 0;

  /**
   * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getId()
   * @generated
   * @ordered
   */
  protected int id = ID_EDEFAULT;

  /**
   * The default value of the '{@link #getX() <em>X</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getX()
   * @generated
   * @ordered
   */
  protected static final double X_EDEFAULT = 0.0;

  /**
   * The cached value of the '{@link #getX() <em>X</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getX()
   * @generated
   * @ordered
   */
  protected double x = X_EDEFAULT;

  /**
   * The default value of the '{@link #getY() <em>Y</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getY()
   * @generated
   * @ordered
   */
  protected static final double Y_EDEFAULT = 0.0;

  /**
   * The cached value of the '{@link #getY() <em>Y</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getY()
   * @generated
   * @ordered
   */
  protected double y = Y_EDEFAULT;

  /**
   * The cached value of the '{@link #getSourceConnections() <em>Source Connections</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getSourceConnections()
   * @generated
   * @ordered
   */
  protected EList sourceConnections = null;

  /**
   * The cached value of the '{@link #getTargetConnections() <em>Target Connections</em>}' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getTargetConnections()
   * @generated
   * @ordered
   */
  protected EList targetConnections = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected NodeImpl() {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass() {
    return ModelPackage.Literals.NODE;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public int getId() {
    return id;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setId(int newId) {
    int oldId = id;
    id = newId;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.NODE__ID, oldId, id));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public double getX() {
    return x;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setX(double newX) {
    double oldX = x;
    x = newX;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.NODE__X, oldX, x));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public double getY() {
    return y;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setY(double newY) {
    double oldY = y;
    y = newY;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, ModelPackage.NODE__Y, oldY, y));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList getSourceConnections() {
    if (sourceConnections == null) {
      sourceConnections = new EObjectContainmentEList(Link.class, this, ModelPackage.NODE__SOURCE_CONNECTIONS);
    }
    return sourceConnections;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList getTargetConnections() {
    if (targetConnections == null) {
      targetConnections = new EObjectResolvingEList(Link.class, this, ModelPackage.NODE__TARGET_CONNECTIONS);
    }
    return targetConnections;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
    switch (featureID) {
      case ModelPackage.NODE__SOURCE_CONNECTIONS:
        return ((InternalEList)getSourceConnections()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(int featureID, boolean resolve, boolean coreType) {
    switch (featureID) {
      case ModelPackage.NODE__ID:
        return new Integer(getId());
      case ModelPackage.NODE__X:
        return new Double(getX());
      case ModelPackage.NODE__Y:
        return new Double(getY());
      case ModelPackage.NODE__SOURCE_CONNECTIONS:
        return getSourceConnections();
      case ModelPackage.NODE__TARGET_CONNECTIONS:
        return getTargetConnections();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(int featureID, Object newValue) {
    switch (featureID) {
      case ModelPackage.NODE__ID:
        setId(((Integer)newValue).intValue());
        return;
      case ModelPackage.NODE__X:
        setX(((Double)newValue).doubleValue());
        return;
      case ModelPackage.NODE__Y:
        setY(((Double)newValue).doubleValue());
        return;
      case ModelPackage.NODE__SOURCE_CONNECTIONS:
        getSourceConnections().clear();
        getSourceConnections().addAll((Collection)newValue);
        return;
      case ModelPackage.NODE__TARGET_CONNECTIONS:
        getTargetConnections().clear();
        getTargetConnections().addAll((Collection)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(int featureID) {
    switch (featureID) {
      case ModelPackage.NODE__ID:
        setId(ID_EDEFAULT);
        return;
      case ModelPackage.NODE__X:
        setX(X_EDEFAULT);
        return;
      case ModelPackage.NODE__Y:
        setY(Y_EDEFAULT);
        return;
      case ModelPackage.NODE__SOURCE_CONNECTIONS:
        getSourceConnections().clear();
        return;
      case ModelPackage.NODE__TARGET_CONNECTIONS:
        getTargetConnections().clear();
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(int featureID) {
    switch (featureID) {
      case ModelPackage.NODE__ID:
        return id != ID_EDEFAULT;
      case ModelPackage.NODE__X:
        return x != X_EDEFAULT;
      case ModelPackage.NODE__Y:
        return y != Y_EDEFAULT;
      case ModelPackage.NODE__SOURCE_CONNECTIONS:
        return sourceConnections != null && !sourceConnections.isEmpty();
      case ModelPackage.NODE__TARGET_CONNECTIONS:
        return targetConnections != null && !targetConnections.isEmpty();
    }
    return super.eIsSet(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String toString() {
    if (eIsProxy()) return super.toString();

    StringBuffer result = new StringBuffer(super.toString());
    result.append(" (id: ");
    result.append(id);
    result.append(", x: ");
    result.append(x);
    result.append(", y: ");
    result.append(y);
    result.append(')');
    return result.toString();
  }

} //NodeImpl