package brn.gui.linktable.diagram.edit.parts;

import brn.gui.linktable.diagram.edit.policies.NodeCanonicalEditPolicy;
import brn.gui.linktable.diagram.edit.policies.NodeGraphicalNodeEditPolicy;
import brn.gui.linktable.diagram.edit.policies.NodeItemSemanticEditPolicy;

import brn.gui.linktable.diagram.part.ModelVisualIDRegistry;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.StackLayout;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

import org.eclipse.gef.commands.Command;

import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;

import org.eclipse.gef.requests.CreateRequest;

import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;

import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;

import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

import org.eclipse.gmf.runtime.notation.View;

/**
 * @generated
 */
public class NodeEditPart extends ShapeNodeEditPart {

  /**
   * @generated
   */
  public static final int VISUAL_ID = 1001;

  /**
   * @generated
   */
  protected IFigure contentPane;

  /**
   * @generated
   */
  protected IFigure primaryShape;

  /**
   * @generated
   */
  public NodeEditPart(View view) {
    super(view);
  }

  /**
   * @generated
   */
  protected void createDefaultEditPolicies() {
    super.createDefaultEditPolicies();
    installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
        new NodeItemSemanticEditPolicy());
    installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
        new NodeGraphicalNodeEditPolicy());
    installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
        new NodeCanonicalEditPolicy());
    installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
  }

  /**
   * @generated
   */
  protected LayoutEditPolicy createLayoutEditPolicy() {
    LayoutEditPolicy lep = new LayoutEditPolicy() {

      protected EditPolicy createChildEditPolicy(EditPart child) {
        EditPolicy result = child.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
        if (result == null) {
          result = new NonResizableEditPolicy();
        }
        return result;
      }

      protected Command getMoveChildrenCommand(Request request) {
        return null;
      }

      protected Command getCreateCommand(CreateRequest request) {
        return null;
      }
    };
    return lep;
  }

  /**
   * @generated
   */
  protected IFigure createNodeShape() {
    NodeFigure figure = new NodeFigure();
    return primaryShape = figure;
  }

  /**
   * @generated
   */
  public NodeFigure getPrimaryShape() {
    return (NodeFigure) primaryShape;
  }

  /**
   * @generated
   */
  protected boolean addFixedChild(EditPart childEditPart) {
    if (childEditPart instanceof NodeIdEditPart) {
      ((NodeIdEditPart) childEditPart).setLabel(getPrimaryShape()
          .getFigureNodeLabelFigure());
      return true;
    }
    return false;
  }

  /**
   * @generated
   */
  protected boolean removeFixedChild(EditPart childEditPart) {
    return false;
  }

  /**
   * @generated
   */
  protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {
    return new DefaultSizeNodeFigure(getMapMode().DPtoLP(40), getMapMode()
        .DPtoLP(40));
  }

  /**
   * @generated
   */
  public EditPolicy getPrimaryDragEditPolicy() {
    ResizableEditPolicy ep = (ResizableEditPolicy) super
        .getPrimaryDragEditPolicy();

    ep.setResizeDirections(PositionConstants.NONE);

    return ep;
  }

  /**
   * Creates figure for this edit part.
   * 
   * Body of this method does not depend on settings in generation model
   * so you may safely remove <i>generated</i> tag and modify it.
   * 
   * @generated
   */
  protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodeFigure() {
    org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = createNodePlate();
    figure.setLayoutManager(new StackLayout());
    IFigure shape = createNodeShape();
    figure.add(shape);
    contentPane = setupContentPane(shape);
    return figure;
  }

  /**
   * Default implementation treats passed figure as content pane.
   * Respects layout one may have set for generated figure.
   * @param nodeShape instance of generated figure class
   * @generated
   */
  protected IFigure setupContentPane(IFigure nodeShape) {
    if (nodeShape.getLayoutManager() == null) {
      ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
      layout.setSpacing(getMapMode().DPtoLP(5));
      nodeShape.setLayoutManager(layout);
    }
    return nodeShape; // use nodeShape itself as contentPane
  }

  /**
   * @generated
   */
  public IFigure getContentPane() {
    if (contentPane != null) {
      return contentPane;
    }
    return super.getContentPane();
  }

  /**
   * @generated
   */
  public EditPart getPrimaryChildEditPart() {
    return getChildBySemanticHint(ModelVisualIDRegistry
        .getType(NodeIdEditPart.VISUAL_ID));
  }

  /**
   * @generated
   */
  protected void addChildVisual(EditPart childEditPart, int index) {
    if (addFixedChild(childEditPart)) {
      return;
    }
    super.addChildVisual(childEditPart, -1);
  }

  /**
   * @generated
   */
  protected void removeChildVisual(EditPart childEditPart) {
    if (removeFixedChild(childEditPart)) {
      return;
    }
    super.removeChildVisual(childEditPart);
  }

  /**
   * @generated
   */
  public class NodeFigure extends org.eclipse.draw2d.Ellipse {

    /**
     * @generated
     */
    public NodeFigure() {

      org.eclipse.draw2d.StackLayout myGenLayoutManager = new org.eclipse.draw2d.StackLayout();

      this.setLayoutManager(myGenLayoutManager);

      this.setBackgroundColor(NODEFIGURE_BACK

      );
      createContents();
    }

    /**
     * @generated
     */
    private void createContents() {
      org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig_0 = new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel();

      setFigureNodeLabelFigure(fig_0);

      Object layData0 = null;

      this.add(fig_0, layData0);
    }

    /**
     * @generated
     */
    private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fNodeLabelFigure;

    /**
     * @generated
     */
    public org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel getFigureNodeLabelFigure() {
      return fNodeLabelFigure;
    }

    /**
     * @generated
     */
    private void setFigureNodeLabelFigure(
        org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fig) {
      fNodeLabelFigure = fig;
    }

    /**
     * @generated
     */
    private boolean myUseLocalCoordinates = false;

    /**
     * @generated
     */
    protected boolean useLocalCoordinates() {
      return myUseLocalCoordinates;
    }

    /**
     * @generated
     */
    protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
      myUseLocalCoordinates = useLocalCoordinates;
    }

  }

  /**
   * @generated
   */
  public static final org.eclipse.swt.graphics.Color NODEFIGURE_BACK = new org.eclipse.swt.graphics.Color(
      null, 220, 220, 250);

}
