package brn.gui.linktable.diagram.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import brn.gui.linktable.diagram.edit.parts.GraphEditPart;
import brn.gui.linktable.diagram.edit.parts.LinkTableLinkEditPart;
import brn.gui.linktable.diagram.edit.parts.LinkTableLinkMetricEditPart;
import brn.gui.linktable.diagram.edit.parts.NodeEditPart;
import brn.gui.linktable.diagram.edit.parts.NodeIdEditPart;

import brn.gui.linktable.diagram.part.ModelVisualIDRegistry;

import brn.gui.linktable.diagram.view.factories.GraphViewFactory;
import brn.gui.linktable.diagram.view.factories.LinkTableLinkMetricViewFactory;
import brn.gui.linktable.diagram.view.factories.LinkTableLinkViewFactory;
import brn.gui.linktable.diagram.view.factories.NodeIdViewFactory;
import brn.gui.linktable.diagram.view.factories.NodeViewFactory;

/**
 * @generated
 */
public class ModelViewProvider extends AbstractViewProvider {

  /**
   * @generated
   */
  protected Class getDiagramViewClass(IAdaptable semanticAdapter,
      String diagramKind) {
    EObject semanticElement = getSemanticElement(semanticAdapter);
    if (GraphEditPart.MODEL_ID.equals(diagramKind)
        && ModelVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
      return GraphViewFactory.class;
    }
    return null;
  }

  /**
   * @generated
   */
  protected Class getNodeViewClass(IAdaptable semanticAdapter,
      View containerView, String semanticHint) {
    if (containerView == null) {
      return null;
    }
    IElementType elementType = getSemanticElementType(semanticAdapter);
    if (elementType != null
        && !ModelElementTypes.isKnownElementType(elementType)) {
      return null;
    }
    EClass semanticType = getSemanticEClass(semanticAdapter);
    EObject semanticElement = getSemanticElement(semanticAdapter);
    int nodeVID = ModelVisualIDRegistry.getNodeVisualID(containerView,
        semanticElement, semanticType, semanticHint);
    switch (nodeVID) {
    case NodeEditPart.VISUAL_ID:
      return NodeViewFactory.class;
    case NodeIdEditPart.VISUAL_ID:
      return NodeIdViewFactory.class;
    case LinkTableLinkMetricEditPart.VISUAL_ID:
      return LinkTableLinkMetricViewFactory.class;
    }
    return null;
  }

  /**
   * @generated
   */
  protected Class getEdgeViewClass(IAdaptable semanticAdapter,
      View containerView, String semanticHint) {
    IElementType elementType = getSemanticElementType(semanticAdapter);
    if (elementType != null
        && !ModelElementTypes.isKnownElementType(elementType)) {
      return null;
    }
    EClass semanticType = getSemanticEClass(semanticAdapter);
    if (semanticType == null) {
      return null;
    }
    EObject semanticElement = getSemanticElement(semanticAdapter);
    int linkVID = ModelVisualIDRegistry.getLinkWithClassVisualID(
        semanticElement, semanticType);
    switch (linkVID) {
    case LinkTableLinkEditPart.VISUAL_ID:
      return LinkTableLinkViewFactory.class;
    }
    return getUnrecognizedConnectorViewClass(semanticAdapter, containerView,
        semanticHint);
  }

  /**
   * @generated
   */
  private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
    if (semanticAdapter == null) {
      return null;
    }
    return (IElementType) semanticAdapter.getAdapter(IElementType.class);
  }

  /**
   * @generated
   */
  private Class getUnrecognizedConnectorViewClass(IAdaptable semanticAdapter,
      View containerView, String semanticHint) {
    // Handle unrecognized child node classes here
    return null;
  }

}
