package brn.gui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import brn.gui.datasource.Provider;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "brn.gui";

	// The shared instance
	private static Activator plugin;

	private Provider dataProvider;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

  /**
   * @generated
   */
  public void logError(String error) {
    logError(error, null);
  }

  /**
   * @param throwable actual error or null could be passed
   * @generated
   */
  public void logError(String error, Throwable throwable) {
    if (error == null && throwable != null) {
      error = throwable.getMessage();
    }
    log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK,
            error, throwable));
    debug(error, throwable);
  }

  /**
   * @generated
   */
  public void logInfo(String message) {
    logInfo(message, null);
  }

  /**
   * @param throwable actual error or null could be passed
   * @generated
   */
  public void logInfo(String message, Throwable throwable) {
    if (message == null && message != null) {
      message = throwable.getMessage();
    }
    log(new Status(IStatus.INFO, PLUGIN_ID, IStatus.OK,
            message, throwable));
  }

  public void log(IStatus status) {
    getLog().log(status);
    debug(status.getMessage(), status.getException());
  }

  /**
   * @generated
   */
  private void debug(String message, Throwable throwable) {
    if (!isDebugging()) {
      return;
    }
    if (message != null) {
      System.err.println(message);
    }
    if (throwable != null) {
      throwable.printStackTrace();
    }
  }
  /*
   * Create and return an IStatus object with ERROR severity and the
   * given message and exception.
   */
  public static IStatus createError(String message, Throwable e) {
    return new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, message, e);
  }

  public static void log(CoreException e) {
    Activator.getDefault().log(e.getStatus());
  }

  public static IStatus createError(String string) {
    return createError(string, null);
  }

  /**
   * @return the dataProvider
   */
  public Provider getDataProvider() {
    if (null == dataProvider) {
      dataProvider = new Provider();
    }

    return dataProvider;
  }

}
