package brn.gui;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

import brn.gui.actions.DebugSimAction;
import brn.gui.actions.ListenSimAction;
import brn.gui.actions.OpenConfigViewAction;
import brn.gui.actions.OpenDataViewAction;
import brn.gui.actions.OpenDatabaseBrowserAction;
import brn.gui.actions.OpenOutlineViewAction;
import brn.gui.actions.OpenPropertiesViewAction;
import brn.gui.actions.PauseSimAction;
import brn.gui.actions.RunSimAction;
import brn.gui.actions.StopSimAction;
import brn.gui.actions.UnlistenSimAction;
import brn.gui.datasource.Provider;
import brn.gui.views.ConfigView;
import brn.gui.views.DataView;

/**
 * An action bar advisor is responsible for creating, adding, and disposing of the
 * actions added to a workbench window. Each window will be populated with
 * new actions.
 */
public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

  private static final String ID_VIEW = "view";

  private static final String ID_SIMULATION = "simulation";

  // Actions - important to allocate these only in makeActions, and then use them
  // in the fill methods.  This ensures that the actions aren't recreated
  // when fillActionBars is called with FILL_PROXY.
  private IWorkbenchAction newAction;

  private IWorkbenchAction newWindowAction;

  private IWorkbenchAction exitAction;

  private IWorkbenchAction aboutAction;

  //    private IWorkbenchAction newWindowAction;
  private OpenConfigViewAction openConfigViewAction;

  private OpenDataViewAction openDataViewAction;

  private ListenSimAction listenSimAction;

  private UnlistenSimAction unlistenSimAction;

  private RunSimAction runSimAction;

  private DebugSimAction debugSimAction;

  private PauseSimAction pauseSimAction;

  private StopSimAction stopSimAction;

  private OpenOutlineViewAction openOutline;

  private OpenPropertiesViewAction openProperties;

  private IWorkbenchAction preferencesAction;
  
  private MenuManager changePerspMenuMgr;

  private MenuManager showViewMenuMgr;

  private OpenDatabaseBrowserAction openDatabaseBrowserAction;
 
  public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
    super(configurer);
  }

  protected void makeActions(final IWorkbenchWindow window) {
    // Creates the actions and registers them.
    // Registering is needed to ensure that key bindings work.
    // The corresponding commands keybindings are defined in the plugin.xml file.
    // Registering also provides automatic disposal of the actions when
    // the window is closed.

    newAction = ActionFactory.NEW.create(window);
    register(newAction);
    
    newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
    register(newWindowAction);

    exitAction = ActionFactory.QUIT.create(window);
    register(exitAction);

    aboutAction = ActionFactory.ABOUT.create(window);
    register(aboutAction);
    
    preferencesAction = ActionFactory.PREFERENCES.create(window);
    register(preferencesAction);
   
    changePerspMenuMgr = new MenuManager("Open Perspective", "openPerspective"); 
    IContributionItem changePerspMenuItem = ContributionItemFactory.
      PERSPECTIVES_SHORTLIST.create(window);
    changePerspMenuMgr.add(changePerspMenuItem);
      
    showViewMenuMgr = new MenuManager("Show View", "showView"); 
    IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST
              .create(window);
    showViewMenuMgr.add(showViewMenu);
    
    openConfigViewAction = new OpenConfigViewAction(window, "Open Config View",
        ConfigView.ID);
    register(openConfigViewAction);

    openDataViewAction = new OpenDataViewAction(window, "Open Data View",
        DataView.ID);
    register(openDataViewAction);

    openOutline = new OpenOutlineViewAction(window, "Open Outline View",
        IPageLayout.ID_OUTLINE);

    openProperties = new OpenPropertiesViewAction(window, "Open Properties View",
        IPageLayout.ID_PROP_SHEET);

    // Simulator
    Provider provider = Activator.getDefault().getDataProvider();
    listenSimAction = new ListenSimAction("Listen", provider);
    register(listenSimAction);

    unlistenSimAction = new UnlistenSimAction("Unlisten", provider);
    register(unlistenSimAction);

    openDatabaseBrowserAction = new OpenDatabaseBrowserAction(
        "Open Database Browser", window);
    register(openDatabaseBrowserAction);

    runSimAction = new RunSimAction("Run", provider);
    register(runSimAction);

    debugSimAction = new DebugSimAction("Debug", provider);
    register(debugSimAction);

    pauseSimAction = new PauseSimAction("Pause", provider);
    register(pauseSimAction);

    stopSimAction = new StopSimAction("Stop", provider);
    register(stopSimAction);
  }

  protected void fillMenuBar(IMenuManager menuBar) {
    MenuManager fileMenu = new MenuManager("&File",
        IWorkbenchActionConstants.M_FILE);
    MenuManager viewMenu = new MenuManager("&View", ID_VIEW);
    MenuManager simMenu = new MenuManager("&Simulation", ID_SIMULATION);
    MenuManager helpMenu = new MenuManager("&Help",
        IWorkbenchActionConstants.M_HELP);

    menuBar.add(fileMenu);
    // Add a group marker indicating where action set menus will appear.
    menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
    menuBar.add(viewMenu);
    menuBar.add(simMenu);
    menuBar.add(helpMenu);

    // File
    fileMenu.add(newAction);
    fileMenu.add(newWindowAction);
    fileMenu.add(new Separator());
    fileMenu.add(exitAction);

    // View
    viewMenu.add(openConfigViewAction);
    viewMenu.add(openDataViewAction);
    viewMenu.add(openOutline);
    viewMenu.add(openProperties);

    // Simulation
    simMenu.add(listenSimAction);
    simMenu.add(unlistenSimAction);
    simMenu.add(new Separator());
    simMenu.add(openDatabaseBrowserAction);
    simMenu.add(new Separator());
    simMenu.add(runSimAction);
    simMenu.add(debugSimAction);
    simMenu.add(pauseSimAction);
    simMenu.add(stopSimAction);

    // Help
    helpMenu.add(aboutAction);
    helpMenu.add(new Separator());
    helpMenu.add(changePerspMenuMgr);
    helpMenu.add(showViewMenuMgr);
    helpMenu.add(preferencesAction);
  }

  protected void fillCoolBar(ICoolBarManager coolBar) {
    IToolBarManager toolbar = new ToolBarManager(SWT.FLAT | SWT.RIGHT);
    toolbar.add(openConfigViewAction);
    toolbar.add(openDataViewAction);
    toolbar.add(openOutline);
    toolbar.add(openProperties);
    coolBar.add(new ToolBarContributionItem(toolbar, ID_VIEW));

    IToolBarManager toolbarSim = new ToolBarManager(SWT.FLAT | SWT.RIGHT);
    toolbarSim.add(listenSimAction);
    toolbarSim.add(unlistenSimAction);
    toolbarSim.add(new Separator());
    toolbarSim.add(openDatabaseBrowserAction);
    toolbarSim.add(new Separator());
    toolbarSim.add(runSimAction);
    toolbarSim.add(debugSimAction);
    toolbarSim.add(pauseSimAction);
    toolbarSim.add(stopSimAction);
    coolBar.add(new ToolBarContributionItem(toolbarSim, ID_SIMULATION));
  }
}
