package brn.gui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import brn.gui.views.BreakpointView;
import brn.gui.views.ConfigView;
import brn.gui.views.DataView;
import brn.gui.views.EventView;
import brn.gui.views.HandlerView;

public class Perspective implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(true);

		IFolderLayout folder = layout.createFolder("main folder", IPageLayout.LEFT,
				0.3f, editorArea);
		folder.addView(ConfigView.ID);
    folder.addView(BreakpointView.ID);
    folder.addPlaceholder(IPageLayout.ID_OUTLINE);

    folder = layout.createFolder("data folder", IPageLayout.BOTTOM,
        0.3f, "main folder");
    folder.addView(DataView.ID);
    folder.addView(EventView.ID);
    folder.addView(HandlerView.ID);

//    layout.addPlaceholder(IPageLayout.ID_OUTLINE,
//        IPageLayout.BOTTOM, 0.6f, "main folder");

    layout.addPlaceholder(IPageLayout.ID_PROP_SHEET, IPageLayout.BOTTOM, 0.7f,
        editorArea);
	}
}
