package brn.gui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

import brn.gui.commands.ICommandIds;

public class OpenDataViewAction extends Action {

	private final static String IMAGE = "/icons/data2.gif";

	private final IWorkbenchWindow window;
	private final String viewId;

	public OpenDataViewAction(IWorkbenchWindow window, String label,
			String viewId) {
		this.window = window;
		this.viewId = viewId;
		setText(label);
		// The id is used to refer to the action in a menu or toolbar
		setId(ICommandIds.CMD_OPEN_DATA);
		// Associate the action with a pre-defined command, to allow key bindings.
		setActionDefinitionId(ICommandIds.CMD_OPEN_DATA);
		setImageDescriptor(brn.gui.Activator.getImageDescriptor(IMAGE));
	}

	public void run() {
		if (window != null) {
			try {
				window.getActivePage().showView(viewId);
			} catch (PartInitException e) {
				MessageDialog.openError(window.getShell(), "Error",
						"Error opening view:" + e.getMessage());
			}
		}
	}
}
