package brn.gui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import brn.gui.commands.ICommandIds;
import brn.gui.datasource.Provider;

public class StopSimAction extends Action implements IPropertyChangeListener {

	private final static String IMAGE = "/icons/stop.gif";

	private Provider provider;

	public StopSimAction(String label, Provider provider) {
		super();
		this.provider = provider;

		setText(label);
		// The id is used to refer to the action in a menu or toolbar
		setId(ICommandIds.CMD_STOP_SIM);
		// Associate the action with a pre-defined command, to allow key bindings.
		setActionDefinitionId(ICommandIds.CMD_STOP_SIM);
		setImageDescriptor(brn.gui.Activator.getImageDescriptor(IMAGE));

    setEnabled(null != provider.getDataSource()
        &&provider.getDataSource().isStopPossible());
    provider.addPropertyChangeListener(this);
	}

  @Override
	public void run() {
    provider.getDataSource().stopSim();
	}

	public void propertyChange(PropertyChangeEvent event) {
    setEnabled(null != provider.getDataSource()
        &&provider.getDataSource().isStopPossible());
	}


}
