package brn.gui.datasource;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IWorkbenchWindow;

import brn.sim.DataManager.DataContribution;

public interface Source {

  public static final String CONNECTED = "connected";
  public static final String PAUSED = "paused";
  public static final String DATA_ADDED = "data_added";
  public static final String CONFIG_ADDED = "config_added";
  public static final String FWDGRAPH_ADDED = "fwdgraph_added";
  public static final String LISTENING = "listening";
  public static final String ARP_TABLE_ADDED = "arp_table";
  public static final String LINK_TABLE_ADDED = "link_table";
  public static final String TIMEBAR_ADDED = "time_bar";
  public static final String PROPERTIES_ADDED = "properties";
  public static final String DATASOURCE_CREATED = "datasource_created";
  public static final String DATASOURCE_DISPOSED = "datasource_disposed";
  public static final String DATASOURCE_BATCH = "datasource_batch";
  public static final String XPLOT_ADDED = "xplot_added";

  public interface Item extends IAdaptable {
    int getId();
    String[] getPath();
    void openInEditor(IWorkbenchWindow workbenchWindow);
  }

  public interface ArpTableItem extends Item {}
  public interface FwdGraphItem extends Item {}
  public interface LinkTableItem extends Item {}
  public interface DataItem extends Item {}
  public interface ConfigItem extends Item {}
  public interface TimeBarItem extends Item {}
  public interface PropertiesItem extends Item {}

  public abstract List<Item> getItems();

  public abstract long getTime();

  public abstract boolean isConnected();

  public abstract boolean isPaused();

  public abstract boolean isRunning();

  public abstract boolean isListening();

  public abstract boolean isListenPossible();

  public abstract boolean isRunPossible();

  public abstract boolean isStopPossible();

  public abstract boolean isPausePossible();

  public abstract void listen();

  public abstract void unlisten();

  public abstract void runSim();

  public abstract void runSimDebug();

  public abstract void pauseSim();

  public abstract void stopSim();

  public abstract int getConfigId();

  public abstract void addPropertyChangeListener(IPropertyChangeListener action);

  public abstract void removePropertyChangeListener(IPropertyChangeListener view);

  public abstract DataContribution getContribution(int id) throws CoreException;

  public abstract void dispose();
}