package brn.gui.datasource.actions;

import org.eclipse.jface.action.Action;

import brn.gui.datasource.ItemImpl;
import brn.gui.datasource.Source;

public class ProviderAction extends Action {

  public void simListening() {
    firePropertyChange(Source.LISTENING, null, null);
  }

  public void simConnected(String string) {
    firePropertyChange(Source.CONNECTED, null, string);
  }

  public void simPaused(long time) {
    firePropertyChange(Source.PAUSED, null, time);
  }

  public void dataAdded(ItemImpl item) {
    firePropertyChange(Source.DATA_ADDED, null, item);
  }

  public void arpTableAdded(ItemImpl item) {
    firePropertyChange(Source.ARP_TABLE_ADDED, null, item);
  }

  public void linkTableAdded(ItemImpl item) {
    firePropertyChange(Source.LINK_TABLE_ADDED, null, item);
  }

  public void addConfig(ItemImpl item) {
    firePropertyChange(Source.CONFIG_ADDED, null, item);
  }

  public void fwdGraphAdded(ItemImpl item) {
    firePropertyChange(Source.FWDGRAPH_ADDED, null, item);
  }

  public void addTimeBar(ItemImpl item) {
    firePropertyChange(Source.TIMEBAR_ADDED, null, item);
  }

  public void addProperties(ItemImpl item) {
    firePropertyChange(Source.PROPERTIES_ADDED, null, item);
  }

  public void dataSourceCreated(Source source) {
    firePropertyChange(Source.DATASOURCE_CREATED, null, source);
  }

  public void dataSourceDisposed(Source source) {
    firePropertyChange(Source.DATASOURCE_DISPOSED, source, null);
  }

  public void setBatch(boolean b) {
    firePropertyChange(Source.DATASOURCE_BATCH, null, b);
  }

  public void xplotAdded(ItemImpl item) {
    firePropertyChange(Source.XPLOT_ADDED, null, item);
  }

}
