package brn.gui.diagram;

import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import brn.gui.datasource.Source;

public class SimulatorResource extends GMFResource {

  protected Source simulator;

  public SimulatorResource(URI uri, Source simulator) {
    super(uri);
    this.simulator = simulator;
    simulator.addPropertyChangeListener(new IPropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(Source.DATASOURCE_DISPOSED)) {
          SimulatorResource.this.simulator.removePropertyChangeListener(this);
          SimulatorResource.this.simulator = null;
        }
      }
    });
  }

  public Source getSimulator() {
    return simulator;
  }

}