/**
 *
 */
package brn.gui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author kurth
 *
 */
public class DataEditorActionBarContributor implements
    IEditorActionBarContributor {

  private static final String IMAGE_REFRESH_DATA = "/icons/refresh.gif";  //  @jve:decl-index=0:
  private static final String IMAGE_OPEN_TREE = "/icons/tree.gif";
  private static final String IMAGE_RESET_ZOOM = "/icons/zoom.gif";
  private static final String IMAGE_SAVE_TEXT_ZOOM = "/icons/saveall.gif";
  private static final String IMAGE_SAVE_CSV = "/icons/saveall.gif";
  private static final String IMAGE_SAVE_IMAGE_ZOOM = "/icons/save.gif";

  private static final String ID_DATA = "brn.gui.editors.dataeditor.data";
  private static final String DATA_REFRESH_ID = "brn.gui.editors.dataeditor.data.refresh";
  private static final String DATA_OPENTREE_ID = "brn.gui.editors.dataeditor.data.opentree";
  private static final String DATA_RESET_ZOOM_ID = "brn.gui.editors.dataeditor.data.zoom";
  private static final String DATA_SAVE_TEXT_ID = "brn.gui.editors.dataeditor.data.savetext";
  private static final String DATA_SAVE_CSV_ID = "brn.gui.editors.dataeditor.data.savecsv";
  private static final String DATA_SAVE_IMAGE_ID = "brn.gui.editors.dataeditor.data.saveimage";

  private Action refreshAction;
  private Action openTreeAction;
  private Action resetZoomAction;
  private Action saveTextAction;
  private Action saveCsvAction;
  private Action saveImageAction;

  private IEditorPart editorPart;

  /* (non-Javadoc)
   * @see org.eclipse.ui.IEditorActionBarContributor#dispose()
   */
  public void dispose() {
    // TODO Auto-generated method stub

  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.IEditorActionBarContributor#init(org.eclipse.ui.IActionBars, org.eclipse.ui.IWorkbenchPage)
   */
  public void init(IActionBars bars, IWorkbenchPage page) {
    init(bars);
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.IEditorActionBarContributor#setActiveEditor(org.eclipse.ui.IEditorPart)
   */
  public void setActiveEditor(IEditorPart targetEditor) {
    editorPart = targetEditor;

    if (editorPart instanceof DataEditor) {
      DataEditor editor = (DataEditor) editorPart;
      refreshAction.setChecked(editor.isRefresh());
    }
  }

  public void init(IActionBars bars) {
    IToolBarManager tbm = bars.getToolBarManager();
    IMenuManager xmlMenu = bars.getMenuManager().findMenuUsingPath("org.eclipse.core.runtime.srgxml.design.xmlmenu"); //$NON-NLS-1$

    if (xmlMenu == null) {
      xmlMenu = new MenuManager("Data", ID_DATA);
      bars.getMenuManager().insertBefore(IWorkbenchActionConstants.M_HELP, xmlMenu);
    } else {
      removeContributions(xmlMenu);
    }

    refreshAction = new Action("Refresh Data", SWT.CHECK) {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.refresh(refreshAction.isChecked());
        }
      }
    };
    refreshAction.setId(DATA_REFRESH_ID);
    refreshAction.setChecked(true);
    refreshAction.setToolTipText("Refresh Data in Editor");
    refreshAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_REFRESH_DATA));
    xmlMenu.add(refreshAction);
    tbm.add(refreshAction);

    openTreeAction = new Action() {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.openTree();
        }
      }
    };
    openTreeAction.setId(DATA_OPENTREE_ID);
    openTreeAction.setText("Open Tree");
    openTreeAction.setToolTipText("Open Tree");
    openTreeAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_OPEN_TREE));
    xmlMenu.add(openTreeAction);
    tbm.add(openTreeAction);

    resetZoomAction = new Action() {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.resetZoom();
        }
      }
    };
    resetZoomAction.setId(DATA_RESET_ZOOM_ID);
    resetZoomAction.setText("Reset Zoom");
    resetZoomAction.setToolTipText("Reset Zoom");
    resetZoomAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_RESET_ZOOM));
    xmlMenu.add(resetZoomAction);
    tbm.add(resetZoomAction);

    saveTextAction = new Action() {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.saveText();
        }
      }
    };
    saveTextAction.setId(DATA_SAVE_TEXT_ID);
    saveTextAction.setText("Save as Text");
    saveTextAction.setToolTipText("Save as Text");
    saveTextAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_SAVE_TEXT_ZOOM));
    xmlMenu.add(saveTextAction);
    tbm.add(saveTextAction);

    
    saveCsvAction = new Action() {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.saveCvs();
        }
      }
    };
    saveCsvAction.setId(DATA_SAVE_CSV_ID);
    saveCsvAction.setText("Save as CSV");
    saveCsvAction.setToolTipText("Save as CSV");
    saveCsvAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_SAVE_CSV));
    xmlMenu.add(saveCsvAction);
    tbm.add(saveCsvAction);
    
    
    
    saveImageAction = new Action() {
      public void run() {
        if (editorPart instanceof DataEditor) {
          DataEditor editor = (DataEditor) editorPart;
          editor.saveImage();
        }
      }
    };
    saveImageAction.setId(DATA_SAVE_IMAGE_ID);
    saveImageAction.setText("Save as Image");
    saveImageAction.setToolTipText("Save as Image");
    saveImageAction.setImageDescriptor(
        brn.gui.Activator.getImageDescriptor(IMAGE_SAVE_IMAGE_ZOOM));
    xmlMenu.add(saveImageAction);
    tbm.add(saveImageAction);
  }

  private void removeContributions(IContributionManager manager) {
    doRemove(manager, ID_DATA);
    doRemove(manager, DATA_REFRESH_ID);
    doRemove(manager, DATA_OPENTREE_ID);
    doRemove(manager, DATA_RESET_ZOOM_ID);
  }

  protected void doRemove(IContributionManager manager, String id) {
    try {
      if (manager.find(id) != null) {
        manager.remove(id);
      }
    } catch (Exception e) {}
  }

}
