package brn.gui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import brn.gui.datasource.Source;

public class SimulatorItemInput implements IEditorInput {

  private static final String IMAGE = "/icons/openeditor.gif";
  private int id;
  private Source simulator;

  public SimulatorItemInput(int id, Source simulator) {
    super();
    this.id = id;
    this.simulator = simulator;

    simulator.addPropertyChangeListener(new IPropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(Source.DATASOURCE_DISPOSED)) {
          SimulatorItemInput.this.simulator.removePropertyChangeListener(this);
          SimulatorItemInput.this.simulator = null;
        }
      }
    });
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IEditorInput#exists()
   */
  public boolean exists() {
    return false;
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
   */
  public ImageDescriptor getImageDescriptor() {
    return brn.gui.Activator.getImageDescriptor(IMAGE);
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IEditorInput#getName()
   */
  public String getName() {
    return String.valueOf(id);
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IEditorInput#getPersistable()
   */
  public IPersistableElement getPersistable() {
    // TODO Auto-generated method stub
    return null;
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.IEditorInput#getToolTipText()
   */
  public String getToolTipText() {
    return String.valueOf(id);
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
   */
  @SuppressWarnings("unchecked")
  public Object getAdapter(Class adapter) {
    // TODO Auto-generated method stub
    return null;
  }

  @Override
  public int hashCode() {
    final int PRIME = 31;
    int result = 1;
    result = PRIME * result + id;
    result = PRIME * result + ((simulator == null) ? 0 : simulator.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    final SimulatorItemInput other = (SimulatorItemInput) obj;
    if (id != other.id)
      return false;
    if (simulator == null) {
      if (other.simulator != null)
        return false;
    } else if (!simulator.equals(other.simulator))
      return false;
    return true;
  }

  public int getId() {
    return id;
  }

  public Source getSimulator() {
    return simulator;
  }

}
