package brn.gui.editors.timebar;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;

import brn.gui.views.BeanPropertySource;

import de.jaret.util.date.IntervalImpl;
import de.jaret.util.date.JaretDate;

public class Interval extends IntervalImpl implements IAdaptable {

  protected int color;
  protected String text;
  protected String detail;
  protected IPropertySource propertySource;

  public Interval(long start, long end, int color, String text, String detail) {
    super(new JaretDate(start/1000), new JaretDate(end/1000));
    this.color = color;
    this.text = text;
    this.detail = detail;
  }

  /**
   * @return the type
   */
  public int getColor() {
    return color;
  }

  /**
   * @return the text
   */
  public String getText() {
    return text;
  }

  public Object getAdapter(Class adapter) {
    if (adapter == IPropertySource.class) {
      if (null == propertySource) {
        propertySource = new BeanPropertySource(this);
      }
      return propertySource;
    }
    return null;
  }

  /**
   * @return the detail
   */
  public String getDetail() {
    return detail;
  }

}
