package brn.gui.editors.timebar;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

import de.jaret.util.date.Interval;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.model.TimeBarRow;
import de.jaret.util.ui.timebars.swt.renderer.DefaultGapRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarGapRenderer;

public class IntervalGapRenderer extends DefaultGapRenderer implements
    TimeBarGapRenderer {

  /** linewidth used when printing. */
  private static final int PRINTING_LINEWIDTH = 3;
  /** color the arrow is rendered in. */
  private static final Color COLOR = Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GRAY);

  public IntervalGapRenderer() {
  }

  public IntervalGapRenderer(Printer printer) {
    super(printer);
  }

  public void draw(GC gc, TimeBarViewerDelegate tbv, TimeBarRow row, Interval i1,
      Interval i2, Rectangle drawingArea, boolean printing) {
    int ox = drawingArea.x;
    int oy = drawingArea.y;
    int width = drawingArea.width;
    int height = drawingArea.height;

    Color fg = gc.getForeground();

    double diff = i2.getBegin().diffMilliSeconds(i1.getEnd()) / 1000000.;
    String timeString = String.valueOf(diff);
    int twidth = SwtGraphicsHelper.getStringDrawingWidth(gc, timeString);
    int theight = SwtGraphicsHelper.getStringDrawingHeight(gc, timeString);

    gc.setForeground(COLOR);
    // center the timeString
    if (width > twidth + 3 && height / 2 >= theight) {
        SwtGraphicsHelper.drawStringCentered(gc, timeString, ox + width / 2, oy + height / 2 - 2);
    }
    // draw a line with arrow endings
    if (printing) {
        gc.setLineWidth(PRINTING_LINEWIDTH);
    }
    if (width > 15) {
        SwtGraphicsHelper
                .drawArrowLine(gc, ox + 2, oy + height / 2, ox + width - 3, oy + height / 2, scaleX(4), scaleY(3), true, true);
    }
    gc.setLineWidth(1);

    gc.setForeground(fg);
  }


}
