package brn.gui.editors.timebar;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

import de.jaret.util.date.Interval;
import de.jaret.util.swt.SwtGraphicsHelper;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.swt.renderer.DefaultRenderer;
import de.jaret.util.ui.timebars.swt.renderer.TimeBarRenderer;

public class IntervalRenderer extends DefaultRenderer implements
    TimeBarRenderer {

  public void draw(GC gc, Rectangle drawingArea,
      TimeBarViewerDelegate delegate, Interval interval, boolean selected,
      boolean printing, boolean overlap) {
    defaultDraw(gc, drawingArea, delegate, interval, selected, printing,
        overlap);
  }

  private void defaultDraw(GC gc, Rectangle drawingArea, TimeBarViewerDelegate
      delegate, Interval interval, boolean selected, boolean printing, boolean overlap)
  {
    brn.gui.editors.timebar.Interval intv = (brn.gui.editors.timebar.Interval) interval;

      drawFocus(gc, drawingArea, delegate, interval, selected, printing, overlap);
      int div = overlap ? 1 : 2;
      int y = drawingArea.y + (overlap ? 0 : drawingArea.height / 4);
      int h = drawingArea.height / div;

      org.eclipse.swt.graphics.Color bg = gc.getBackground();
      if (selected)
        gc.setBackground(Display.getCurrent().getSystemColor(15));
      else
          gc.setBackground(Display.getCurrent().getSystemColor(intv.getColor()));
      gc.fillRectangle(drawingArea.x, y, drawingArea.width - 1, h - 1);
      gc.drawRectangle(drawingArea.x, y, drawingArea.width - 1, h - 1);
      String str = intv.getText();
      SwtGraphicsHelper.drawStringCentered(gc, str, drawingArea);
      gc.setBackground(bg);
  }
}
