/*
 *  File: TickScaler.java
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package brn.gui.editors.timebar;

/**
 * Simple helper for scaling minor and major tick distances for pixelpersecond
 * value.
 *
 * @author Peter Kliem
 * @version $Id: TickScaler.java 160 2007-01-02 22:02:40Z olk $
 */
public class TickScaler {

  private static final double _pixPerSecondLimits[] = { .2, .5, 1, 2, 5, 10, 20, 50, 100, 250, 500, 1000, 2000, 4000, 8000, 20000 };

  private static final int _majorTick[] = { 1000000, 400000, 200000, 100000, 40000, 20000, 10000, 4000, 2000, 800, 400, 200, 100, 50, 20, 10 };

  private static final int _minorTick[] = { 100000, 40000, 20000, 10000, 4000, 2000, 1000, 400, 200, 80, 40, 20, 10, 5, 2, 1 };

  public static int getTickIdx(double pixPerSecond) {
//    System.out.println(pixPerSecond);
    for (int i = 0; i < _pixPerSecondLimits.length; i++) {
      if (pixPerSecond <= _pixPerSecondLimits[i]) {
        return i;
      }
    }
    return _pixPerSecondLimits.length - 1;
  }

  public static int getMajorTick(int idx) {
    return _majorTick[idx];
  }

  public static int getMinorTick(int idx) {
    return _minorTick[idx];
  }

}
