package brn.gui.editors.timebar.action;

import org.eclipse.jface.action.Action;

import de.jaret.util.date.JaretDate;
import de.jaret.util.ui.timebars.TimeBarViewerDelegate;
import de.jaret.util.ui.timebars.swt.TimeBarViewer;

public class ZoomInAction extends Action {
  /** the timebarviewer th action has been constructed for. */
  private final TimeBarViewer _viewer;
  /** the delegate of the timebarviewer. */
  private final TimeBarViewerDelegate _delegate;

  /**
   * Constructor.
   *
   * @param viewer timebar viewer
   * @param delegate delegate of the viewer.
   */
  public ZoomInAction(TimeBarViewer viewer, TimeBarViewerDelegate delegate) {
      _viewer = viewer;
      _delegate = delegate;
  }

  /**
   * {@inheritDoc}
   */
  public void run() {
    JaretDate date = _delegate.dateForX(_delegate.getCtxCoordinate().x);
    JaretDate oldStart = _viewer.getStartDate();

    double pps = _viewer.getPixelPerSecond() * 2;
    _viewer.setPixelPerSecond(pps);

    oldStart.advanceMillis(date.diffMilliSeconds(oldStart)/2);
    _viewer.setStartDate(oldStart);
  }

  /**
   * {@inheritDoc}
   */
  public String getText() {
      return "Zoom In";
  }

}
