package brn.gui.fwdgraph.diagram.custom.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import brn.gui.graph.model.FwdLink;

public class FwdLinkEditPart extends
brn.gui.fwdgraph.diagram.edit.parts.FwdLinkEditPart {

  public FwdLinkEditPart(View view) {
    super(view);
  }

  protected Connection createConnectionFigure() {
    return new FwdLinkFigure();
  }

  public class FwdLinkFigure extends
    brn.gui.fwdgraph.diagram.edit.parts.FwdLinkEditPart.FwdLinkFigure {

    @Override
    public void validate() {
      super.validate();
      updateFace();
    }

    org.eclipse.draw2d.PolylineDecoration df;

    public FwdLinkFigure() {
      super();
      df = new org.eclipse.draw2d.PolylineDecoration();
      setTargetDecoration(df);
      updateFace();
    }

    public void updateFace() {
      FwdLink fwdLink = (FwdLink) ((Edge)FwdLinkEditPart.this.getModel()).getElement();

      int widthSize = (int) (Math.log(fwdLink.getNoPackets()) / Math.log(10.0)) + 1;
      this.setLineWidth(widthSize);
      if (df != null)
        df.setLineWidth(widthSize);
      if (fwdLink.isDuplicate())
        this.setLineStyle(Graphics.LINE_DASH);
      else
        this.setLineStyle(Graphics.LINE_SOLID);

      Color color = ColorConstants.lightGray;
      switch (fwdLink.getFlowId()) {
      case 0: color = ColorConstants.black; break;
      case 1: color = ColorConstants.red; break;
      case 2: color = ColorConstants.green; break;
      case 3: color = ColorConstants.blue; break;
      case 4: color = ColorConstants.cyan; break;
      case 5: color = ColorConstants.yellow; break;
      case 6: color = ColorConstants.darkGreen; break;
      case 7: color = ColorConstants.darkBlue; break;
      case 8: color = ColorConstants.lightGreen; break;
      case 9: color = ColorConstants.lightBlue; break;
      default: color = ColorConstants.lightGray; break;
      }
      setForegroundColor(color);
    }
  }

  @Override
  protected void handleNotificationEvent(Notification notification) {
    if (notification.getNotifier() instanceof FwdLink) {
      ((FwdLinkFigure)getFigure()).updateFace();
    }
    super.handleNotificationEvent(notification);
  }
}
