package brn.gui.fwdgraph.diagram.custom.editors;

import java.util.Iterator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import brn.gui.commands.ICommandIds;
import brn.gui.fwdgraph.diagram.custom.layout.SimulationPlacementLayoutProvider;

public class IncreaseDisplayedSizeAction extends Action {

  private final static String IMAGE = "/icons/outline_co.gif";

  /**
   * Constructor
   */
  public IncreaseDisplayedSizeAction() {
    setText("Increase Displayed Size");
    // The id is used to refer to the action in a menu or toolbar
    setId(ICommandIds.CMD_LAYOUT_SIMULATION_PLACEMENT);
    // Associate the action with a pre-defined command, to allow key bindings.
    setActionDefinitionId(ICommandIds.CMD_LAYOUT_SIMULATION_PLACEMENT);
    setImageDescriptor(brn.gui.Activator.getImageDescriptor(IMAGE));
  }

  /* (non-Javadoc)
   * @see org.eclipse.jface.action.Action#run()
   */
  @Override
  public void run() {
    /* Get selection */
    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    // Get selection from the window
    final ISelection selection = window.getSelectionService().getSelection();
        Diagram diagramView = null;

        // get the editing domain
        if (selection instanceof IStructuredSelection) {

            IStructuredSelection structuredSelection = (IStructuredSelection) selection;

            // Walk selection
            for (Iterator i = structuredSelection.iterator(); i.hasNext();) {

                // Try to adapt the selection to a view
                Object selectedObject = i.next();
                if (selectedObject instanceof IAdaptable) {

                    // Try to get a View (new notation)
                    Object object = ((IAdaptable) selectedObject)
                        .getAdapter(View.class);

                    diagramView = ((View)object).getDiagram();
                }
            }
        }

        if (diagramView != null) {
            final Diagram diag = diagramView;
//            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain(diagramView);
//            AbstractEMFOperation operation = new AbstractEMFOperation(
//                ted, KEY_PLACEMENT_LAYOUT, null) {
//
//                protected IStatus doExecute(IProgressMonitor monitor,
//                        IAdaptable info)
//                    throws ExecutionException {
//
//                    // TODO
//                    return Status.OK_STATUS;
//                }
//            };
//            try {
//                operation.execute(new NullProgressMonitor(), null);
//            }
//            catch (Exception e) {
//                throw new RuntimeException(e.getCause());
//            }
        }
  }

}
