package brn.gui.reports;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;

import brn.gui.Activator;

/**
 * This utility class is used to place the sample report or its resources onto
 * assigned path
 */
public class PlaceResources
{

//	public static void copy( Shell shell, String path, String reportName,
//			String reportDesignFile )
//	{
//		URL sampleReportURL = null;
//		try
//		{
//			sampleReportURL = new URL( reportDesignFile );
//		}
//		catch ( IOException e )
//		{
//			ExceptionHandler.handle( e );
//		}
//		copy( shell, path, reportName, sampleReportURL );
//	}

	public static void copy( Shell shell, String path, String desFileName,
			URL srcURL ) throws CoreException
	{
		final File targetfile = new File( path, desFileName );
//		if ( targetfile.exists( ) )
//		{
//			if ( !MessageDialog.openConfirm( shell,
//					Messages.getString( "SampleReportsView.MessageDialog.Title" ), //$NON-NLS-1$
//					Messages.getFormattedString( "SampleReportsView.MessageDialog.Message", //$NON-NLS-1$
//							new Object[]{
//								desFileName
//							} ) ) )
//			{
//				return;
//			}
//		}

		OutputStream output = null;
		InputStream input = null;
		// URL sampleReportURL = null;
		try
		{
			output = new FileOutputStream( targetfile );
			// sampleReportURL = new URL( reportDesignFile );
			input = srcURL.openStream( );
			int offset;
			byte[] buf = new byte[1024 * 4];
			while ( ( offset = input.read( buf ) ) > -1 )
			{
				output.write( buf, 0, offset );
			}
		}
		catch ( IOException e )
		{
      throw new CoreException(Activator.createError("Error copying reports", e));
		}
		finally
		{
			try
			{
				input.close( );
				output.close( );
			}
			catch ( IOException e )
			{
	      throw new CoreException(Activator.createError("Error copying reports", e));
			}
		}
	}

//	public static void copyIncludedLibraries( Shell shell, String projectPath )
//	{
//		Enumeration enumeration = SampleIncludedSourceEntry.getIncludedLibraries( );
//		while ( enumeration.hasMoreElements( ) )
//		{
//			URL libraryURL = (URL) enumeration.nextElement( );
//			String filename = libraryURL.getFile( );
//			String desFileName = filename.substring( filename.lastIndexOf( '/' ) + 1 );
//
//			PlaceResources.copy( shell, projectPath, desFileName, libraryURL );
//		}
//	}

//	public static void copyIncludedPng( Shell shell, String projectPath )
//	{
//		Enumeration enumeration = SampleIncludedSourceEntry.getIncludedPng( );
//		while ( enumeration.hasMoreElements( ) )
//		{
//			URL pngURL = (URL) enumeration.nextElement( );
//			String filename = pngURL.getFile( );
//			String desFileName = filename.substring( filename.lastIndexOf( '/' ) + 1 );
//
//			PlaceResources.copy( shell, projectPath, desFileName, pngURL );
//		}
//	}

	public static void copyReports(Shell shell, String projectPath) throws CoreException
	{
		Enumeration enumeration = SampleIncludedSourceEntry.getReports();
		while ( enumeration.hasMoreElements( ) )
		{
			URL reportURL = (URL) enumeration.nextElement( );
			String filename = reportURL.getFile( );
			String desFileName = filename.substring( filename.lastIndexOf( '/' ) + 1 );
      PlaceResources.copy( shell, projectPath, desFileName, reportURL );
		}
	}

//	public static void copyExcludedRptDesignes( Shell shell,
//			String projectPath, String fileName )
//	{
//		try
//		{
//			String path = new URL( fileName ).getPath( );
//			if ( path == null )
//				return;
//			path = path.substring( 0, path.lastIndexOf( '/' ) );
//			Enumeration enumeration = SampleIncludedSourceEntry.getEntries( path );
//			if ( enumeration == null )
//				return;
//			while ( enumeration.hasMoreElements( ) )
//			{
//				URL reportURL = (URL) enumeration.nextElement( );
//				String filename = reportURL.getFile( );
//				String desFileName = filename.substring( filename.lastIndexOf( '/' ) + 1 );
//				if ( !desFileName.toLowerCase( ).endsWith( ".rptdesign" ) ) //$NON-NLS-1$
//				{
//					PlaceResources.copy( shell,
//							projectPath,
//							desFileName,
//							reportURL );
//				}
//			}
//		}
//		catch ( Exception e )
//		{
//			ExceptionHandler.handle( e );
//		}
//	}
}
