/**
 *
 */
package brn.gui.views;

import java.lang.reflect.Array;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * @author kurth
 *
 */
public class ArrayPropertySource implements IPropertySource {

  protected Object array;

  protected IPropertyDescriptor[] propertyDescriptors;

  public ArrayPropertySource(Object array) {
    this.array = array;
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#getEditableValue()
   */
  public Object getEditableValue() {
    // TODO Auto-generated method stub
    return null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
   */
  public IPropertyDescriptor[] getPropertyDescriptors() {
    if (null == propertyDescriptors) {
      int length = Array.getLength(array);
      propertyDescriptors = new PropertyDescriptor[length];

      for (int i = 0; i < length; i++)
        propertyDescriptors[i] = new PropertyDescriptor(i, String.valueOf(i));
    }

    return propertyDescriptors;
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
   */
  public Object getPropertyValue(Object id) {
    Object o = Array.get(array, (Integer) id);//  public LabelProvider getLabelProvider() {
//  return new LabelProvider() {
//  public String getText(Object element) {
//    StringBuffer buf = new StringBuffer();
//    buf.append("class: ");
//    buf.append(element.getClass());
//    buf.append(", value: ");
//    buf.append(element.toString());
//    return buf.toString();
//  }
//};
//}


    if (null == o)
      return "null";
    else if (o.getClass().isArray())
      return new ArrayPropertySource(o);
    else if (o instanceof Number
        ||o instanceof String
        ||o instanceof Boolean)
      return o.toString();

    return new BeanPropertySource(o);
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
   */
  public boolean isPropertySet(Object id) {
    return true;
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
   */
  public void resetPropertyValue(Object id) {
    // TODO Auto-generated method stub
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
   */
  public void setPropertyValue(Object id, Object value) {
    // TODO Auto-generated method stub
  }

//  public LabelProvider getLabelProvider() {
//    return new LabelProvider() {
//      public String getText(Object element) {
//        StringBuffer buf = new StringBuffer();
//        buf.append("class: ");
//        buf.append(element.getClass());
//        buf.append(", value: ");
//        buf.append(element.toString());
//        return buf.toString();
//      }
//    };
//  }
}
