/**
 *
 */
package brn.gui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

import brn.gui.Activator;
import brn.gui.datasource.Source;
import brn.sim.AbstractParams;

/**
 * @author kurth
 *
 */
public class ConfigPropertySource extends BeanPropertySource {

  private Source simulator;

  public ConfigPropertySource(Source simulator) {
    this.simulator = simulator;
    setBean(getConfig());
  }

  public AbstractParams getConfig() {
    AbstractParams config =  null;
    // Set config
    if (simulator.isConnected()) {
      try {
        config = (AbstractParams) simulator.getContribution(simulator.getConfigId());
      } catch (CoreException e) {
        Activator.log(e);
      }
    }
    return config;
  }

  /* (non-Javadoc)
   * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
   */
  public IPropertyDescriptor[] getPropertyDescriptors() {
    if (!simulator.isConnected()) {
      setBean(null);
    }
    else if (null == bean /* && simulator.isConnected() */) {
      setBean(getConfig());
    }

    return super.getPropertyDescriptors();
  }

  /* (non-Javadoc)
   * @see brn.gui.views.BeanPropertySource#isPropertyIgnored(java.lang.String)
   */
  @Override
  protected boolean isPropertyIgnored(String name) {
    if (name.equals("path") || name.equals("type") || name.equals("content"))
      return true;

    return super.isPropertyIgnored(name);
  }

}
