package jplot;
/*
 * This file is part of jPlot
 *
 * jPlot is a Java version of Tim Shepard's xplot which is distributed 
 * under the M.I.T. license (as below).
 *
 * Tim Shepard's original xplot is an amazing piece of software. It was
 * designed to be extraordinarily fast and efficient and as such, it has
 * only a very thin user interface. Those design goals, however, make
 * xplot extremely difficult to port to new architectures and also make it
 * difficult to use for the casual user. jPlot was designed to address
 * these limitations while keeping as much of the original efficiency as
 * possible. We thank Tim Shepard for his hard work on xplot and hope that
 * jPlot can live up to his high standards.
 *
 * jPlot was developed by Avinash Lakhiani at the Internetworking Research
 * Lab (IRG), Ohio University, as part of Dr. Shawn Ostermann's tcptrace
 * project. The main goal behind the development of jPlot was to make the 
 * plotting tool used with tcptrace more portable. As a result, jPlot
 * retains many of the original algorithms implemented in xplot, and as per
 * the terms and conditions of the M.I.T. license, continue to remain under
 * that license. The M.I.T license is as follows:
 *
 * --- M.I.T License Begin ---
 * 
 * Copyright 1992,1993 by the Massachusetts Institute of Technology.
 *                   All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
 * OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
 * limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
 * OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
 * PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 *
 * The name of the Massachusetts Institute of Technology or M.I.T. may
 * NOT be used in advertising or publicity pertaining to distribution of
 * the software.  Title to copyright in this software and any associated
 * documentation shall at all times remain with M.I.T., and USER agrees
 * to preserve same.
 * 
 * --- M.I.T. License End ---
 * 
 * jPlot also has a lot of added features that are not part of the original
 * xplot code. Those sections of code are distributed under the following
 * BSD License:
 *
 * --- BSD License Begin ---
 *
 * Copyright (c) 2002, 2003 by Avinash Lakhiani
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *	
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution. 
 *   - Neither the name of Ohio University nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission. 
 *	   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * --- BSD License End ---
 * 
 * You should have received a file named "DISTINCTION" along with this
 * distribution, that clearly identifies all the algorithms that were
 * retained from the original xplot code, and remain under the M.I.T.
 * license. The rest of the code was written for jPlot, and falls under
 * the BSD license.
 * 
 * jPlot is free software; you can redistribute it and/or modify it under the
 * terms and conditions of both the above licenses.
 *
 * jPlot is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the above licenses for more details.
 *
 * Author:  Avinash Lakhiani
 *          Internetworking Research Group
 *          Ohio University
 *          Athens, OH
 *          avinash.lakhiani@ohiou.edu
 *          http://www.tcptrace.org/jPlot
 *
 */

/*
 * $Id: Command.java,v 1.2 2002/12/04 01:58:52 alakhian Exp $
 */ 

/* Import Packages */
import java.awt.Color;
import java.awt.*;
import java.awt.geom.*;

/* Class       - Command 
 * Description - an instance of this class holds one command (e.g. line, dot etc.)
 * Extends     - NULL
 * Implements  - NULL
 */
public class Command
{
   /* Member variables */
   protected int type;               // command type
   /*
    {
    X, DOT, PLUS, BOX, DIAMOND,                                                    
    UTICK, DTICK, LTICK, RTICK, HTICK, VTICK,                                      
    UARROW, DARROW, LARROW, RARROW,                                                
    INVISIBLE, LINE, DLINE,                                                        
    TEXT, TITLE, XLABEL, YLABEL 
    }
    */
   protected int position;          // text position
   protected boolean mapped;        // mapped/unmapped flag 
   protected boolean decoration;    // is it a decoration command? flag
   protected Color color;           // color to be used during rendering
   protected Coord xa, ya;          // point one unmapped
   protected Coord xb, yb;          // point two unmapped
   protected Point2D a, b;          // mapped coordinates
   protected String text;           // associated text (if any)
   
   /* Method      - Command (Constructor)
    * Parameters  - all the above fields to be set
    * Returns     - NULL
    * Description - this constructor is called during input parsing, each time a new 
    * command line is read in. Also used during axis creation.
    */
   public Command(int type,
		  int position,
		  boolean mapped,
		  boolean decoration,
		  Color color,
		  Coord xa, Coord ya,
		  Coord xb, Coord yb,
		  String text
		  )
     {
	this.type       = type;
	this.position   = position;
	this.mapped     = mapped;
	this.decoration = decoration;
	this.color      = color;
	this.xa         = xa;
	this.ya         = ya;
	this.xb         = xb;
	this.yb         = yb;
	this.a    = new Point2D.Double(0.0, 0.0);
	this.b    = new Point2D.Double(0.0, 0.0);
	this.text = new String(text);

     } // End of constructor Command
   
   public String toString()
     {
	if(xa == null || ya == null)
	  return(new String("type:" + type + " " +
			    "position:" + position + " " +
			    "mapped:" + mapped + " " +
			    "decoration:" + decoration + " " +
			    "color:" + color + " " +
			    "xa:0" + " " +
			    "ya:0" + " " +  
			    "xb:0" + " " + 
			    "yb:0" + " " + 
			    "a.x:" + a.getX()     + " " +
			    "a.y:" + a.getY()     + " " +
			    "b.x:" + b.getX()     + " " +
			    "b.y:" + b.getY()     + " " +			    
			    "text:" + text
			    )
		 );
	else if(xb == null || yb == null)
	  return(new String("type:" + type + " " +
			    "position:" + position + " " +
			    "mapped:" + mapped + " " +
			    "decoration:" + decoration + " " +
			    "color:" + color + " " +
			    "xa:" + xa.toString() + " " +
			    "ya:" + ya.toString() + " " +
			    "xb:" + " " +
			    "yb:" + " " +
			    "a.x:" + a.getX()     + " " +
			    "a.y:" + a.getY()     + " " +
			    "b.x:" + b.getX()     + " " +
			    "b.y:" + b.getY()     + " " +			    
			    "text:" + text
			    )
		 );	  
	else
	  return(new String("type:" + type + " " +
			    "position:" + position + " " +
			    "mapped:" + mapped + " " +
			    "decoration:" + decoration + " " +
			    "color:" + color + " " +
			    "xa:" + xa.toString() + " " +
			    "ya:" + ya.toString() + " " +
			    "xb:" + xb.toString() + " " +
			    "yb:" + yb.toString() + " " +
			    "a.x:" + a.getX()     + " " +
			    "a.y:" + a.getY()     + " " +
			    "b.x:" + b.getX()     + " " +
			    "b.y:" + b.getY()     + " " +			    
			    "text:" + text
			    )
		 );
     }

} // End of class Command
