package jplot;
/*
 * This file is part of jPlot
 *
 * jPlot is a Java version of Tim Shepard's xplot which is distributed 
 * under the M.I.T. license (as below).
 *
 * Tim Shepard's original xplot is an amazing piece of software. It was
 * designed to be extraordinarily fast and efficient and as such, it has
 * only a very thin user interface. Those design goals, however, make
 * xplot extremely difficult to port to new architectures and also make it
 * difficult to use for the casual user. jPlot was designed to address
 * these limitations while keeping as much of the original efficiency as
 * possible. We thank Tim Shepard for his hard work on xplot and hope that
 * jPlot can live up to his high standards.
 *
 * jPlot was developed by Avinash Lakhiani at the Internetworking Research
 * Lab (IRG), Ohio University, as part of Dr. Shawn Ostermann's tcptrace
 * project. The main goal behind the development of jPlot was to make the 
 * plotting tool used with tcptrace more portable. As a result, jPlot
 * retains many of the original algorithms implemented in xplot, and as per
 * the terms and conditions of the M.I.T. license, continue to remain under
 * that license. The M.I.T license is as follows:
 *
 * --- M.I.T License Begin ---
 * 
 * Copyright 1992,1993 by the Massachusetts Institute of Technology.
 *                   All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
 * OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
 * limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
 * OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
 * PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 *
 * The name of the Massachusetts Institute of Technology or M.I.T. may
 * NOT be used in advertising or publicity pertaining to distribution of
 * the software.  Title to copyright in this software and any associated
 * documentation shall at all times remain with M.I.T., and USER agrees
 * to preserve same.
 * 
 * --- M.I.T. License End ---
 * 
 * jPlot also has a lot of added features that are not part of the original
 * xplot code. Those sections of code are distributed under the following
 * BSD License:
 *
 * --- BSD License Begin ---
 *
 * Copyright (c) 2002, 2003 by Avinash Lakhiani
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *	
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution. 
 *   - Neither the name of Ohio University nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission. 
 *	   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * --- BSD License End ---
 * 
 * You should have received a file named "DISTINCTION" along with this
 * distribution, that clearly identifies all the algorithms that were
 * retained from the original xplot code, and remain under the M.I.T.
 * license. The rest of the code was written for jPlot, and falls under
 * the BSD license.
 * 
 * jPlot is free software; you can redistribute it and/or modify it under the
 * terms and conditions of both the above licenses.
 *
 * jPlot is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the above licenses for more details.
 *
 * Author:  Avinash Lakhiani
 *          Internetworking Research Group
 *          Ohio University
 *          Athens, OH
 *          avinash.lakhiani@ohiou.edu
 *          http://www.tcptrace.org/jPlot
 *
 */

/*
 * $Id: Constant.java,v 1.2 2002/12/04 01:58:52 alakhian Exp $
 */ 

/* Import packages */

/* Class       - Constant
 * Description - this class implements many of the constants used throughout
 * the project. It is a clean way of localizing all constants at one place.
 * Extends     - NULL
 * Implements  - NULL
 */
public class Constant 
{
   /* Integer Constants */
   public static final int NUMVIEWS  = 10;             // Maximum number of views allowed while zooming
   public static final int MIDLEVEL  = 60;             // Used as a constant while computing the axis ticks
   public static final int MAX_TOKENS_PER_LINE = 6;    // Maximum tokens that may be seen on a line  
   public static final int CLAMP     = 3000;           // Clamping factor used during clipping of coordinates agains upper bound of 3000x3000
   public static final int MAXTICKS  = 6;              // Used while computing the ticks for the axis
   public static final int POINTER_MARK_LENGTH = 6;    // Length of the pointer marks
   public static final int BOXRADIUS = 3;              // The radius for the box drawn by the command "box"
   public static final int D         = 3;              // the tick length 
   public static final int U         = 2;              // the arrow head distance 
   public static final int DOT       = 1;              // decides the type of dot {dense : 0, medium: 1, light: 2} CHANGE HERE FOR PREFERRED TYPE OF DOT.
   public static final int FONTSIZE  = 10;             // Sets the font size for all text on the plot. CHANGE HERE FOR PREFERRED SIZE.
   public static final int MOUSE_MOTION_THRESHOLD = 7; // The mouse motion threshold used to decide whether to change state of the plot or not
   public static final int DEFAULT_ORIGIN_X = 100;     // Default origin point coordinates   
   public static final int DEFAULT_ORIGIN_Y = 40;
   public static final int DEFAULT_WIDTH    = 800;     // Default display dimensions
   public static final int DEFAULT_HEIGHT   = 600;
   public static final int FC_WIDTH         = 640;     // File chooser size (set for proper display)
   public static final int FC_HEIGHT        = 320;
   public static final int TP_WIDTH         = 810;     // Tabbed Pane size (set for proper display)
   public static final int TP_HEIGHT        = 160;
   public static final int COLUMN_0_WIDTH   = 100;     // Table column widths (set for proper display)
   public static final int COLUMN_1_WIDTH   = 700;
   public static final int TILE_WIDTH       = 320;     // Tiling display dimensions
   public static final int TILE_HEIGHT      = 240;
   public static final int CASCADE_WIDTH    = 640;     // Cascading display dimensions
   public static final int CASCADE_HEIGHT   = 480;
   public static final int CASCADE_OFFSET   = 30;      // The offset in pixels, by which to cascade the frames
   public static final int CASCADE_LIMIT    = 200;     // The offset in pixels for the cascade limit
   public static final int PIXELS_PER_INCH  = 7200;    // Used while generation postscript files
   public static final int NCOLORS          = 10;      // Count of colors available
   public static final int PS_FILE_COUNT_LIMIT = 1000; // Maximum limit of versions of postscript file for a plot.
   public static final int PNG_FILE_COUNT_LIMIT = 1000;// Maximum limit of versions of png file for a plot.   
   
   /* Used during mapping of coordinates, to decide
    * if the point will be seen or not
    */
   public static final int NO        = 0;              
   public static final int MAYBE     = 1;
   public static final int YES       = 2;   

   /* Double Constants */
   public static final double MARGIN         = 0.1;    /* This is the margin to be left on all sides of the window.
							* (This is a fix to the problem with the labels being clipped off if at the end of the window).
							* Specified as the % of the window size.
							*/
							  
   /* String Constants */
   /* jPlot's version string */
   public static final String AUTHOR            = new String("Avinash Lakhiani (avinash.lakhiani@ohiou.edu)");
   public static final String PROGRAM_NAME_SHORT= new String("jPlot");
   public static final String PROGRAM_NAME_LONG = new String("Avinash Lakhiani's jPlot (tcptrace's java version of Tim Shepard's xplot)");
   public static final String COPYRIGHT         = new String("Copyright (c) 2002, 2003");
   public static final String VERSION_MAJOR     = new String("1");
   public static final String VERSION_MINOR     = new String("0");
   public static final String VERSION_BUGFIX    = new String("2");
   public static final String RELEASE_DATE      = new String("01 Dec 2002");

   public static final String A4_PS_EXTENSION   = new String(".a4.ps");
   public static final String TEX3_PS_EXTENSION = new String(".tex3.ps");
   public static final String LVS_PS_EXTENSION  = new String(".lvs.ps");   
   public static final String PNG_EXTENSION    = new String(".png");   
     
} //End of class Constant
