package jplot;
/*
 * This file is part of jPlot
 *
 * jPlot is a Java version of Tim Shepard's xplot which is distributed
 * under the M.I.T. license (as below).
 *
 * Tim Shepard's original xplot is an amazing piece of software. It was
 * designed to be extraordinarily fast and efficient and as such, it has
 * only a very thin user interface. Those design goals, however, make
 * xplot extremely difficult to port to new architectures and also make it
 * difficult to use for the casual user. jPlot was designed to address
 * these limitations while keeping as much of the original efficiency as
 * possible. We thank Tim Shepard for his hard work on xplot and hope that
 * jPlot can live up to his high standards.
 *
 * jPlot was developed by Avinash Lakhiani at the Internetworking Research
 * Lab (IRG), Ohio University, as part of Dr. Shawn Ostermann's tcptrace
 * project. The main goal behind the development of jPlot was to make the
 * plotting tool used with tcptrace more portable. As a result, jPlot
 * retains many of the original algorithms implemented in xplot, and as per
 * the terms and conditions of the M.I.T. license, continue to remain under
 * that license. The M.I.T license is as follows:
 *
 * --- M.I.T License Begin ---
 *
 * Copyright 1992,1993 by the Massachusetts Institute of Technology.
 *                   All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
 * OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
 * limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
 * OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
 * PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 *
 * The name of the Massachusetts Institute of Technology or M.I.T. may
 * NOT be used in advertising or publicity pertaining to distribution of
 * the software.  Title to copyright in this software and any associated
 * documentation shall at all times remain with M.I.T., and USER agrees
 * to preserve same.
 *
 * --- M.I.T. License End ---
 *
 * jPlot also has a lot of added features that are not part of the original
 * xplot code. Those sections of code are distributed under the following
 * BSD License:
 *
 * --- BSD License Begin ---
 *
 * Copyright (c) 2002, 2003 by Avinash Lakhiani
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *   - Neither the name of Ohio University nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * --- BSD License End ---
 *
 * You should have received a file named "DISTINCTION" along with this
 * distribution, that clearly identifies all the algorithms that were
 * retained from the original xplot code, and remain under the M.I.T.
 * license. The rest of the code was written for jPlot, and falls under
 * the BSD license.
 *
 * jPlot is free software; you can redistribute it and/or modify it under the
 * terms and conditions of both the above licenses.
 *
 * jPlot is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the above licenses for more details.
 *
 * Author:  Avinash Lakhiani
 *          Internetworking Research Group
 *          Ohio University
 *          Athens, OH
 *          avinash.lakhiani@ohiou.edu
 *          http://www.tcptrace.org/jPlot
 *
 */

/*
 * $Id: HelpMenu.java,v 1.2 2002/12/04 01:58:52 alakhian Exp $
 */

/* Import Packages */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.System;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.JButton;

/* Class       - HelpMenu
 * Description - this class implements the help menu
 * Extends     - jDialog
 * Implements  - NULL
 */
public class HelpMenu extends JDialog
{
   /* Member Variables */
   String optionsData[][] =
     {	  {"-1"              , "show each file one at a time, rather than all at once"},
	  {"-e"              , "leave an extra margin around the plot (useful if some of the labels are getting clipped off the edges)"},
	  {"-t, -[-]tile"    , "tile the plots so that they can all be seen when displayed, rather than being displayed one on top of the other"},
	  {"-c, -[-]cascade" , "cascade the plots"},
	  {"-v, -[-]version" , "print version information"},
	  {"-h, -[-]help"    , "display a help screen"}
     };
   String mouseBindingsData[][] =
     {
	  {"left"            , "draw rectangle to zoom in, click to zoom out"},
	  {"SHIFT + left"    , "drag to scroll window"},
	  {"CTRL  + left"    , "drag out a box showing dimensions"},
	  {"right"           , "cycle between files  (if the \'-1\' option is used)"},
	  {"right"           , "quit  (if the \'-1\' option is NOT used)"}
     };
   String colorsData[][] =
     {
	  {"White on Black"  , "the plotter would use a WHITE stroke on a BLACK background"},
	  {"Black on White"  , "the plotter would use a BLACK stroke on a WHITE background"},
	  {"Black on Gray"   , "the plotter would use a BLACK stroke on a GRAY  background"},
	  {"NOTE:"           , "colors other than BLACK and WHITE would remain the same"}
     };
   String saveAsData[][] =
     {
	  {".png"            , "Portable Network Graphics (PNG) Format"},
	  {".a4.ps"          , "A4 size postscript image"},
	  {".tex3.ps"        , "3 plots per latex page size postscript image"},
	  {".lvs.ps"         , "less vertical space postscript image (image occupies less vertical space)"}
     };
   String buttonsData[][] =
     {
	  {"Refresh"         , "refresh the screen"},
	  {"Original"        , "zoom back to the original view of the plot"},
	  {"Resync"          , "re-read the data from the file and display a fresh plot"},
	  {"Close"           , "close the current window"},
	  {"Exit"            , "close all the windows and exit"}
     };
   String acceleratorKeysData[][] =
     {
	  {"CTRL + S"        , "Save As..."},
	  {"CTRL + C"        , "close current window"},
	  {"CTRL + X"        , "close all windows and exit"},
	  {"CTRL + R"        , "refresh the screen"},
	  {"CTRL + L"        , "resync i.e re-read the data from the file and display a fresh plot"},
	  {"CTRL + H"        , "display this help dialog"}
     };

   /* Table Models for help information */
   private DataTableModel optionsTableModel       = new DataTableModel(optionsData);
   private DataTableModel mouseBindingsTableModel = new DataTableModel(mouseBindingsData);
   private DataTableModel colorsDataModel         = new DataTableModel(colorsData);
   private DataTableModel saveAsDataModel         = new DataTableModel(saveAsData);
   private DataTableModel buttonsDataModel        = new DataTableModel(buttonsData);
   private DataTableModel acceleratorKeysModel    = new DataTableModel(acceleratorKeysData);

   /* Tables for all the help information */
   private JTable optionsTable         = new JTable(optionsTableModel);
   private JTable mouseBindingsTable   = new JTable(mouseBindingsTableModel);
   private JTable colorsTable          = new JTable(colorsDataModel);
   private JTable saveAsTable          = new JTable(saveAsDataModel);
   private JTable buttonsTable         = new JTable(buttonsDataModel);
   private JTable acceleratorKeysTable = new JTable(acceleratorKeysModel);

   /* Scroll panes for all the tables */
   private JScrollPane optionsScrollPane         = new JScrollPane();
   private JScrollPane mouseBindingsScrollPane   = new JScrollPane();
   private JScrollPane colorsScrollPane          = new JScrollPane();
   private JScrollPane saveAsScrollPane          = new JScrollPane();
   private JScrollPane buttonsScrollPane         = new JScrollPane();
   private JScrollPane acceleratorKeysScrollPane = new JScrollPane();

   /* Tabbed pane for all the help tables */
   private JTabbedPane tabbedPane = new JTabbedPane();

   /* The OK button panel and button */
   private JPanel buttonPanel = new JPanel();
   private JButton okButton   = new JButton("OK");

   /* Method      - HelpMenu (Constructor)
    * Parameters  - the owner frame, the title of the jDialog, and a flag specifying whether
    * the JDialog is modal or not.
    * Returns     - NULL
    * Description - initializes the jDialog and sets the JOptionsPane
    */
   public HelpMenu(Frame owner, String title, boolean modal)
     {
	super(owner, title, modal);
	try
	  {
	     /* Initialize the help frame */
	     jbInit();
	     this.pack();
	  }
	catch(Exception e)
	  {
	     e.printStackTrace();
	  }
     } // End of constructor Helpmenu

   /* Method      - jbInit
    * Parameters  - NULL
    * Returns     - NULL
    * Description - this method creates the frame and sets the help text
    */
   private void jbInit() throws Exception
     {
	/* Add the jTables to the JOptionPane */
	okButton.addActionListener(new java.awt.event.ActionListener()
				   {
				      public void actionPerformed(ActionEvent e)
					{
					   okButton_actionPerformed(e);
					}
				   }
				  );
	this.getContentPane().add(tabbedPane, BorderLayout.CENTER);
	this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
	buttonPanel.add(okButton, null);

	/* Set properties for each table */
	optionsTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	optionsTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	optionsTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	mouseBindingsTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	mouseBindingsTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	mouseBindingsTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	colorsTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	colorsTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	colorsTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	saveAsTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	saveAsTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	saveAsTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	buttonsTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	buttonsTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	buttonsTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	acceleratorKeysTable.getColumn(optionsTable.getColumnName(0)).setMinWidth(Constant.COLUMN_0_WIDTH);
	acceleratorKeysTable.getColumn(optionsTable.getColumnName(1)).setMinWidth(Constant.COLUMN_1_WIDTH);
	acceleratorKeysTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

	/* Set the size of the tabbed pane */
	tabbedPane.setPreferredSize(new Dimension(Constant.TP_WIDTH, Constant.TP_HEIGHT));

	/* Set properties for the scroll panes */
	optionsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	mouseBindingsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	colorsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	saveAsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	buttonsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	acceleratorKeysScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

	/* Adding the tables to the scroll panes */
	optionsScrollPane.getViewport().add(optionsTable, null);
	mouseBindingsScrollPane.getViewport().add(mouseBindingsTable, null);
	colorsScrollPane.getViewport().add(colorsTable, null);
	saveAsScrollPane.getViewport().add(saveAsTable, null);
	buttonsScrollPane.getViewport().add(buttonsTable, null);
	acceleratorKeysScrollPane.getViewport().add(acceleratorKeysTable, null);

	/* Adding the scoll panes to the tabbed pane */
	tabbedPane.addTab("Command Line Options" , optionsScrollPane);
	tabbedPane.addTab("Mouse Bindings"       , mouseBindingsScrollPane);
	tabbedPane.addTab("Color Options"        , colorsScrollPane);
	tabbedPane.addTab("Save As... Options"   , saveAsScrollPane);
	tabbedPane.addTab("Buttons"              , buttonsScrollPane);
	tabbedPane.addTab("Accelerator Keys"     , acceleratorKeysScrollPane);

     }  // End of method jbInit()

   void okButton_actionPerformed(ActionEvent e)
     {
	setVisible(false);
     }

} // End of class HelpMenu

/* Class       - DataTableModel
 * Description - this class implements the table data structure used to store the contents of the help menu
 * Extends     - AbstractTableModel
 * Implements  - NULL
 */
class DataTableModel extends AbstractTableModel
{
   /* Holds the options and their descriptions for the help menu, in a two-dimensional string array */
   String data[][];

   /* Method      - DataTableModel( Default constructor)
    * Parameters  - The array from which the structure is to be populated
    * Returns     - NULL
    * Description - populates the data structure from the supplied string array, for the help menu
    */
   public DataTableModel(String optionsData[][])
     {
	this.data = new String[optionsData.length][optionsData[0].length];
	try
	  {
	     for(int i = 0; i < optionsData.length; i++)
	       System.arraycopy(optionsData[i], 0, this.data[i], 0, optionsData[i].length);
	  }
	catch(IndexOutOfBoundsException e)
	  {
	     System.out.println(e.toString());
       throw new RuntimeException(e);
//	     System.exit(1);
	  }
	catch(ArrayStoreException e)
	  {
	     System.out.println(e.toString());
       throw new RuntimeException(e);
//	     System.exit(1);
	  }
	catch(NullPointerException e)
	  {
	     System.out.println(e.toString());
       throw new RuntimeException(e);
//	     System.exit(1);
	  }
	catch(Exception e)
	  {
	     System.out.println(e.toString());
       throw new RuntimeException(e);
//	     System.exit(1);
	  }

     }

   /* Method      - getData
    * Parameters  - NULL
    * Returns     - the data structure
    * Description - returns the data structure
    */
   public String[][] getData()
     {
	return(data);
     }

   /* Method      - getRowCount
    * Parameters  - NULL
    * Returns     - the number of rows present in the data table
    * Description - returns the number of rows present in the data table
    */
   public int getRowCount()
     {
	return(data.length);
     }

   /* Method      - getColumnCount
    * Parameters  - NULL
    * Returns     - the number of columns present in the data table
    * Description - returns the number of data columns present in the data table
    */
   public int getColumnCount()
     {
	return(data[0].length);
     }

   /* Method      - getColumnClass
    * Parameters  - the column number for which the class is requested
    * Returns     - the class representing the column specified, in the data table
    * Description - returns the class representing the column specified, in the data table
    */
   public Class getColumnClass(int column)
     {
	return(String.class);
     }

   /* Method      - getValueAt
    * Parameters  - the row and column of the data cell requested
    * Returns     - the data in the specified cell
    * Description - returns the data in the specified cell
    */
   public Object getValueAt(int row, int column)
     {
	return(data[row][column]);
     }

   /* Method      - getColumnName
    * Parameters  - column number
    * Returns     - the name of the specified column
    * Description - returns the name of the specified column
    */
   public String getColumnName(int col)
     {
	switch(col)
	  {
	   case 0:  return("Option");
	   case 1:  return("Option Description");
	   default: return("");
	  }
     }

   /* Method      - isCellEditable
    * Parameters  - the row and column of the cell
    * Returns     - the boolean value representing whether the cell is editable or not
    * Description - returns the boolean value representing whether the cell is editable or not
    */
   public boolean isCellEditable(int row , int column )
     {
	return(false);
     }

   /* Method      - setValueAt
    * Parameters  - the value, the row and column of the cell at which the value is to be set
    * Returns     - NULL
    * Description - this method is suppose to set the specified cell to the specified value,
    * but does not in this case, since it is not needed.
    */
   public void setValueAt(Object value , int row , int column)
     {
	return;
     }

} // End of class DataTableModel
