package jplot;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PlotterFile extends Plotter {

  private String plotFile;          // plotter file to read the commands from

  public PlotterFile(String file, boolean isMargin) {
    super(isMargin);
    /* Initializations */
    plotFile        = new String(file);
    /* Read the commands from the file */
    readInput();
  }

  /* Method      - readInput
   * Parameters  - NULL
   * Returns     - NULL
   * Description - opens the specified input file and reads the plotter
   * arributes and commands.
   */
  protected int readInput()
    {
 BufferedReader input = null;
 String line;
 int lineNo = 0;
 StringTokenizer st;

 try
   {
      input = new BufferedReader(new FileReader(plotFile));
   }
 catch(FileNotFoundException e)
   {
      System.out.println(e.toString());
      throw new RuntimeException(e);
//      System.exit(1);
   }

 try
   {
      /* Process commands */

      /* Declarations & Initializations */
      int nTokens = 0;                           // Count of tokens in one line
      String token[] = {"", "", "", "", "", ""}; // tokens read in one line (max tokens relevant could be 6)

      /* Looking for the string "new_plotter".
       * (allowing multiple instances of that string)
       */
      do
        {
     line = input.readLine(); lineNo++;
     if(line == null) parseError(lineNo, line, "EOF before first line of input");
     st = new StringTokenizer(line);
     nTokens = st.countTokens();
        }
      while ((nTokens == 1) && (st.nextToken().compareTo("new_plotter") == 0));

      /* Check if we possibly have the coordinate types in the next line */
      if(nTokens != 2) parseError(lineNo, line, "invalid input format -- expecting coord type names");

      /* Process coordinate types */
      xType = cType.toInt(st.nextToken());
      yType = cType.toInt(st.nextToken());
      if(xType < 0 || yType < 0) parseError(lineNo, line, "unknown coord type");

      /* Loop and process commands */
      for( ; ; )
        {
     line = input.readLine(); lineNo++;
     if(line == null) break;
     st = new StringTokenizer(line);
     nTokens = st.countTokens();

     /* DEBUGGING
      System.out.println(lineNo + " : " + line + " : " + nTokens);
      */

     /* Look for blank lines */
     if (nTokens == 0) continue;

     /* Look for empty command lines */
     token[0] = new String(st.nextToken());
     if(token[0].compareTo(";") == 0) continue;

     /* Look for default color alone on a line */
     if(nTokens == 1)
       {
          Color c = parseColor(token[0]);
          if(c != null)
      {
         currentColor = c;
         continue;
      }
       }

     /* Coordinate types may be specified after default color */
     if(nTokens == 2)
       {
          token[1] = new String(st.nextToken());
          if((xType == cType.toInt(token[0])) &&
       (yType == cType.toInt(token[1]))
       )
      continue;
       }

     /* Parsing the different commands in the input file */
     if(token[0].compareToIgnoreCase("aspect_ratio") == 0)  // Type "aspect_ratio"
       {
          if(nTokens != 2) parseError(lineNo, line, "input format error");
          if(xType != yType)
      parseError(lineNo, line, "aspect_ratio requires identical coordinate types");
          Double dObj = new Double(token[1]);
          aspectRatio = dObj.doubleValue();

       }else
       if(token[0].compareToIgnoreCase("x") == 0)  // Type "x"
       {
          Color c = currentColor;
          Coord x1;
          Coord y1;
          if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
          token[1] = new String(st.nextToken());
          token[2] = new String(st.nextToken());
          x1 = newCoord(xType, token[1]);
          y1 = newCoord(yType, token[2]);
          if(nTokens == 4)
      {
         token[3] = new String(st.nextToken());
         c = parseColor(token[3]);
      }
       /* arguments for this constructor
                    * Command(type, position, mappped, decoration, color, coord1, coord2, text)
        */
          Command cmd = new Command(cmdType.X, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
          commands.add(0, cmd);

       }else
       if((token[0].compareToIgnoreCase(".") == 0)  || (token[0].compareToIgnoreCase("dot") == 0))// Type ". & dot"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.DOT, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if((token[0].compareToIgnoreCase("+") == 0) || (token[0].compareToIgnoreCase("plus") == 0))  // Type "+ & plus"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.PLUS, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("box") == 0)  // Type "box"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.BOX, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("diamond") == 0)  // Type "diamond"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.DIAMOND, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("utick") == 0)  // Type "utick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.UTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("dtick") == 0)  // Type "dtick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.DTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("ltick") == 0)  // Type "ltick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.LTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("rtick") == 0)  // Type "rtick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.RTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("htick") == 0)  // Type "htick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.HTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("vtick") == 0)  // Type "vtick"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.VTICK, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("uarrow") == 0)  // Type "uarrow"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.UARROW, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("darrow") == 0)  // Type "darrow"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.DARROW, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("larrow") == 0)  // Type "larrow"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.LARROW, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("rarrow") == 0)  // Type "rarrow"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.RARROW, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("line") == 0)  // Type "line"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      Coord x2;
      Coord y2;
      if((nTokens != 5) && (nTokens != 6)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      token[3] = new String(st.nextToken());
      token[4] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      x2 = newCoord(xType, token[3]);
      y2 = newCoord(yType, token[4]);
      if(nTokens == 6)
        {
           token[5] = new String(st.nextToken());
           c = parseColor(token[5]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.LINE, Position.UNDEFINED, false, false, c, x1, y1, x2, y2, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("dline") == 0)  // Type "dline"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      Coord x2;
      Coord y2;
      if((nTokens != 5) && (nTokens != 6)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      token[3] = new String(st.nextToken());
      token[4] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      x2 = newCoord(xType, token[3]);
      y2 = newCoord(yType, token[4]);
      if(nTokens == 6)
        {
           token[5] = new String(st.nextToken());
           c = parseColor(token[5]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.DLINE, Position.UNDEFINED, false, false, c, x1, y1, x2, y2, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("title") == 0)  // Type "title"
         {
      String title = new String("");
      /* The next line holds the title */
      if(nTokens == 1)
        {
           title = input.readLine(); lineNo++;
           if(title == null) break;
        }
      else if(nTokens == 2) title = new String(token[1]);
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TITLE, Position.UNDEFINED, false, false, null, null, null, null, null, title);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("ctext") == 0)  // Type "ctext"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      String text = new String("");
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* The next line holds the text to be displayed at the specified location */
      text = input.readLine(); lineNo++;
      if(text == null) break;

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TEXT, Position.CENTERED, false, false, c, x1, y1, null, null, text);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("atext") == 0)  // Type "atext"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      String text = new String("");
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* The next line holds the text to be displayed at the specified location */
      text = input.readLine(); lineNo++;
      if(text == null) break;

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TEXT, Position.ABOVE, false, false, c, x1, y1, null, null, text);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("btext") == 0)  // Type "btext"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      String text = new String("");
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* The next line holds the text to be displayed at the specified location */
      text = input.readLine(); lineNo++;
      if(text == null) break;

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TEXT, Position.BELOW, false, false, c, x1, y1, null, null, text);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("ltext") == 0)  // Type "ltext"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      String text = new String("");
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* The next line holds the text to be displayed at the specified location */
      text = input.readLine(); lineNo++;
      if(text == null) break;

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TEXT, Position.LEFT, false, false, c, x1, y1, null, null, text);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("rtext") == 0)  // Type "rtext"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      String text = new String("");
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* The next line holds the text to be displayed at the specified location */
      if(nTokens == 5) text = new String(st.nextToken());
      else
        {
           text = input.readLine(); lineNo++;
           if(text == null) break;
        }

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.TEXT, Position.RIGHT, false, false, c, x1, y1, null, null, text);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("xlabel") == 0)  // Type "xlabel"
         {
      String xlabel = new String("");
      /* The next line holds the xlabel */
      if(nTokens == 1)
        {
           xlabel = input.readLine(); lineNo++;
           if(xlabel == null) break;
        }
      else if(nTokens == 2) xlabel = new String(token[1]);

      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.XLABEL, Position.UNDEFINED, false, false, null, null, null, null, null, xlabel);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("ylabel") == 0)  // Type "ylabel"
         {
      String ylabel = new String("");
      /* The next line holds the ylabel */
      if(nTokens == 1)
        {
           ylabel = input.readLine(); lineNo++;
           if(ylabel == null) break;
        }
      else if(nTokens == 2) ylabel = new String(token[1]);
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.YLABEL, Position.UNDEFINED, false, false, null, null, null, null, null, ylabel);
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("xunits") == 0)  // Type "xunits"
         {
      String xunits = new String("");
      /* The next line holds the xunits */
      if(nTokens == 1)
        {
           xunits = input.readLine(); lineNo++;
           if(xunits == null) break;
        }
      else if(nTokens == 2) xunits = new String(token[1]);
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      xUnits = xunits;

         }else
       if(token[0].compareToIgnoreCase("yunits") == 0)  // Type "yunits"
         {
      String yunits = new String("");
      /* The next line holds the ylabel */
      if(nTokens == 1)
        {
           yunits = input.readLine(); lineNo++;
           if(yunits == null) break;
        }
      else if(nTokens == 2) yunits = new String(token[1]);
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      yUnits = yunits;

         }else
       if(token[0].compareToIgnoreCase("invisible") == 0)  // Type "invisible"
         {
      Color c = currentColor;
      Coord x1;
      Coord y1;
      if((nTokens != 3) && (nTokens != 4)) parseError(lineNo, line, "input format error");
      token[1] = new String(st.nextToken());
      token[2] = new String(st.nextToken());
      x1 = newCoord(xType, token[1]);
      y1 = newCoord(yType, token[2]);
      if(nTokens == 4)
        {
           token[3] = new String(st.nextToken());
           c = parseColor(token[3]);
        }
      /* arguments for this constructor
       * Command(type, position, mappped, decoration, color, coord1, coord2, text)
       */
      Command cmd = new Command(cmdType.INVISIBLE, Position.UNDEFINED, false, false, c, x1, y1, null, null, "");
      commands.add(0, cmd);

         }else
       if(token[0].compareToIgnoreCase("go") == 0)  // Type "go"
         {
      System.out.println("Plotting file \"" + plotFile + "\"");
      break;
         }
     else // Error
       {
          parseError(lineNo, line, "input format error");
       }

        } // End of for-loop

      /* Close the input stream */
      input.close();

      /* Initializing the window range parameters, they are currently */
      for(int i = 0; i < Constant.NUMVIEWS; i++)
        {
     xLeft[i]   = newCoord(xType, "0");
     xRight[i]  = newCoord(xType, "0");
     yBottom[i] = newCoord(yType, "0");
     yTop[i]    = newCoord(yType, "0");
        }

      /* Computing the window range */
      this.computeRange();

      /* Bump the coordinates. This is done in conjunction with the ticking algorithm. The step gets the
       * correct range related to the axis ticks. (A bit complicated). {Algorithm from Tim Shepard's xplot}
       */
      this.bumpCoord(xType, xRight[getViewNo()]);
      this.bumpCoord(yType, yTop[getViewNo()]);

      /* DEBUGGING ... printing the commands list
      int i = commands.size();
      Command cmd;
      while(i > 0)
        {
     cmd = (Command)commands.get(--i);
     System.out.println(i + " : " + cmd.toString());
        }
       */

   }
 catch(NoSuchElementException e)
   {
      System.out.println(e.toString());
   }
 catch(IndexOutOfBoundsException e)
   {
      System.out.println(e.toString());
   }
       catch(IOException e)
   {
      System.out.println(e.toString());
   }

 return(0);

    } // End of method readInput()

  /* Method      - parseError
   * Parameters  - line number, input line, error message
   * Returns     - NULL
   * Description - prints the error message for the error that occured during input parsing,
   * along with the line number and input line.
   */
  protected void parseError(int lineNo, String line, String error)
    {
 System.out.println("Plotter.java (file: "+ plotFile + "): in line number " +
        lineNo + " : " + error + "\n\toffending line: " + line
        );
 throw new RuntimeException("Plotter.java (file: "+ plotFile + "): in line number " +
     lineNo + " : " + error + "\n\toffending line: " + line);
// System.exit(1);

    } // End of method parseError()

}
