package jplot;
/*
 * This file is part of jPlot
 *
 * jPlot is a Java version of Tim Shepard's xplot which is distributed 
 * under the M.I.T. license (as below).
 *
 * Tim Shepard's original xplot is an amazing piece of software. It was
 * designed to be extraordinarily fast and efficient and as such, it has
 * only a very thin user interface. Those design goals, however, make
 * xplot extremely difficult to port to new architectures and also make it
 * difficult to use for the casual user. jPlot was designed to address
 * these limitations while keeping as much of the original efficiency as
 * possible. We thank Tim Shepard for his hard work on xplot and hope that
 * jPlot can live up to his high standards.
 *
 * jPlot was developed by Avinash Lakhiani at the Internetworking Research
 * Lab (IRG), Ohio University, as part of Dr. Shawn Ostermann's tcptrace
 * project. The main goal behind the development of jPlot was to make the 
 * plotting tool used with tcptrace more portable. As a result, jPlot
 * retains many of the original algorithms implemented in xplot, and as per
 * the terms and conditions of the M.I.T. license, continue to remain under
 * that license. The M.I.T license is as follows:
 *
 * --- M.I.T License Begin ---
 * 
 * Copyright 1992,1993 by the Massachusetts Institute of Technology.
 *                   All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
 * OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
 * limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
 * OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
 * PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 *
 * The name of the Massachusetts Institute of Technology or M.I.T. may
 * NOT be used in advertising or publicity pertaining to distribution of
 * the software.  Title to copyright in this software and any associated
 * documentation shall at all times remain with M.I.T., and USER agrees
 * to preserve same.
 * 
 * --- M.I.T. License End ---
 * 
 * jPlot also has a lot of added features that are not part of the original
 * xplot code. Those sections of code are distributed under the following
 * BSD License:
 *
 * --- BSD License Begin ---
 *
 * Copyright (c) 2002, 2003 by Avinash Lakhiani
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *	
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution. 
 *   - Neither the name of Ohio University nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission. 
 *	   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * --- BSD License End ---
 * 
 * You should have received a file named "DISTINCTION" along with this
 * distribution, that clearly identifies all the algorithms that were
 * retained from the original xplot code, and remain under the M.I.T.
 * license. The rest of the code was written for jPlot, and falls under
 * the BSD license.
 * 
 * jPlot is free software; you can redistribute it and/or modify it under the
 * terms and conditions of both the above licenses.
 *
 * jPlot is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the above licenses for more details.
 *
 * Author:  Avinash Lakhiani
 *          Internetworking Research Group
 *          Ohio University
 *          Athens, OH
 *          avinash.lakhiani@ohiou.edu
 *          http://www.tcptrace.org/jPlot
 *
 */

/*
 * $Id: jPlot.java,v 1.2 2002/12/04 01:58:53 alakhian Exp $
 */ 

/* Import Packages */
import java.awt.*;
import java.awt.GraphicsConfiguration;
import javax.swing.*;
import java.lang.String;
import java.lang.Object;
import java.util.ArrayList;

public class jPlot
{
   /* Member Variables */
   protected int countOfFrames;          // count of total number of frames ( = total number of files specified on the command line)
   private static int showingFrame;    // index of the frame currently being displayed
   private static jPlot parent;        // A handle to the parent
   private static Dimension frameSize; // The frame size to be set
   private static ArrayList afList;    // List of the application frames being displayed
   private static Point p;             // display point of the frame. Used for tiling and cascading 
   public static Arguments args;    // arguments read from the command line
   
   /* Method      - Constructor (called by default)
    * Parameters  - NULL
    * Returns     - NULL
    * Description - sets the count of frames to 0. This counter is used to implement proper
    * exit of the program when all windows are disposed.
    */
   public jPlot()
     {
	countOfFrames = 0;
        showingFrame  = 0;
	p = new Point(0, 0);
     }
   
   /* Method      - main
    * Parameters  - command line arguments
    * Returns     - NULL
    * Description - the main method that instantiates the jPlot class.
    */
   public static void main(String[] argv)
     {
	/* Output version */
	System.out.println(Constant.PROGRAM_NAME_LONG + "\n" +
			   "Version: " + Constant.VERSION_MAJOR + "." + Constant.VERSION_MINOR + "." + Constant.VERSION_BUGFIX + "\n" +
			   "Release Date: " + Constant.RELEASE_DATE + "\n" +
			   Constant.COPYRIGHT + "\n"
			   );
	
	/* Parse the command-line arguments */
	args = new Arguments();
	/* Arguments error checking */
	if(!args.parseArgs(argv))
	   {
	      args.argsError();
	      System.exit(1);
	   }
	
	/* Set the look and feel */
	try
	  {
	     UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	  }
	catch(UnsupportedLookAndFeelException e)
	  {
	     System.out.println(e.toString());
	     System.exit(1);
	  }
	catch(InstantiationException e)
	  {
	     System.out.println(e.toString());
	     System.exit(1);
	  }
	catch(ClassNotFoundException e)
	  {
	     System.out.println(e.toString());
	     System.exit(1);
	  }
	catch(IllegalAccessException e)
	  {
	     System.out.println(e.toString());
	     System.exit(1);
	  }

	/* Create a reference to the parent */
 	parent = new jPlot();
	
	/* Graphics environment needed for tiling */
	GraphicsEnvironment     ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
	GraphicsDevice[]        gs = ge.getScreenDevices();
	GraphicsConfiguration[] gc = gs[0].getConfigurations();
	Rectangle         gcBounds = gc[0].getBounds();
	int xDisplacement = 0;    // Displacement used during cascading
	/* If tiling or cascading is set, set the dimensions accordingly */
	if(args.isTile())
	  frameSize = new Dimension(Constant.TILE_WIDTH, Constant.TILE_HEIGHT);
	else if(args.isCascade())
	  frameSize = new Dimension(Constant.CASCADE_WIDTH, Constant.CASCADE_HEIGHT);
	/* The initial screen size is set to 800x600 here. (Change it in "Constant.java" if you need to).
	 * I may add this as a command line option too !!!
	 */
	else
	  frameSize = new Dimension(Constant.DEFAULT_WIDTH, Constant.DEFAULT_HEIGHT);
	/* Set the display location for tiling */
 	/* Instantiate the class that creates the frame */
	ApplicationFrame ApplicationFrame = null;;
	/* Maintain a list of all the Application Frames */
	afList = new ArrayList();
	/* Pop all the frames according to the flag '-1' */
	for(int i = 0; i < args.getFileCount(); i++)
	  {
	     /* Count the frames (counter in jPlot) */
	     parent.countOfFrames++;
	     /* Create the new Application Frame */
	     ApplicationFrame = new ApplicationFrame(args.getFileName(i), parent);
	     /* Add the new application frame to the list */
	     afList.add(ApplicationFrame);
	     /* Set the fram size to the dimension above */
	     ApplicationFrame.setSize(frameSize);
	     /* Set the title of the frame window */
	     ApplicationFrame.setTitle(args.getFileName(i));
	     /* Validates the size of all components within the frame. (Needed for correct display). */
	     ApplicationFrame.validate();
	     /* Setting the location at which the frame is to be displayed on the screen */
	     ApplicationFrame.setLocation(p.x, p.y);
	     /* Display the frame */
	     ApplicationFrame.show();
	     /* Update the status of showingFrame */
	     showingFrame = i;
	     /* Check for the '-1' flag, if set, show only the first frame */
	     if(args.isOne()) break;
	     /* Set the location for the next frame, if tiling/cascading is set */
	     if(args.isTile())
		{
		   /* Move to the next row */
		   p.y += frameSize.height;
		   if((p.y + frameSize.height) > gcBounds.height)   // Move to the next column
		     {
			/* Move to the next column */
			p.x += frameSize.width;
			/* Check if we've filled the screen */
			if((p.x + frameSize.width) > gcBounds.width) // Move back to the origin
			  p.x = 0;
			p.y = 0;
		     }
		}
	     if(args.isCascade())
	       {
		  p.x += Constant.CASCADE_OFFSET;
		  p.y += Constant.CASCADE_OFFSET;
		  /* Reset if limit exceeded */
		  if(((p.x + frameSize.width)  > gcBounds.width) ||
		     ((p.y + frameSize.height) > gcBounds.height)
		    )
		    {
		       xDisplacement += (2 * Constant.CASCADE_OFFSET);
		       p.x = xDisplacement;
		       p.y = 0;
		    }
	       }
	  }
		
     } //End of method main()
   
   /* Method      - killJFrame
    * Parameters  - flag indicating whether the mouse was right-clicked, or the x-button at the top
    * right corner of the window was pressed.
    * Returns     - status of processing i.e. whether the frame should go ahead and kill itselt, or just hide itself.
    * Description - keeps track of the number if displayed frmaes, and exits the program, when all frames
    * are disposed.
    */
   public boolean killJFrame(boolean xPressed)
     {
	if(args.isOne())
	  {
	     /* Exit if the x-button at the top right corner of the window was pressed */
	     if(xPressed)
	       System.exit(0);
	     
	     /* Check if all frames have been created */
	     if(parent.countOfFrames < args.getFileCount())        // All frames have not been created yet
	       {
		  /* Create the new Application Frame */
		  ApplicationFrame ApplicationFrame = new ApplicationFrame(args.getFileName(parent.countOfFrames), parent);
		  /* Add the new application frame to the list */
		  afList.add(ApplicationFrame);
		  /* Set the fram size to the dimension above */
		  ApplicationFrame.setSize(frameSize);
		  /* Set the title of the frame window */
		  ApplicationFrame.setTitle(args.getFileName(parent.countOfFrames));
		  /* Validates the size of all components within the frame. (Needed for correct display). */
		  ApplicationFrame.validate();
		  /* Setting the location at which the frame is to be displayed on the screen */
		  ApplicationFrame.setLocation(p.x, p.y);
		  /* Display the frame */
		  ApplicationFrame.show();
		  /* Update the status of showingFrame */
		  showingFrame = parent.countOfFrames;
		  /* Count the frames (counter in jPlot) */
		  parent.countOfFrames++;
	       }
	     else      // All frames have been created, just show the next one, and hide the previous
	       {
		  /* Cycle to the next frame */
		  parent.showingFrame++;
		  parent.showingFrame %= parent.countOfFrames;
		  /* Get the next frame from the list */
		  ApplicationFrame af = null;
		  try
		    {
		       af = (ApplicationFrame)afList.get(parent.showingFrame);
		    }
		  catch(IndexOutOfBoundsException e)
		    {
		       System.out.println(e.toString());
		       System.exit(1);
		    }
		  /* Set the next frame's focus */
		  af.setState(Frame.NORMAL);
		  /* Set the location back to the origin */
//		  af.setLocation(0, 0);
		  /* Show the next frame */
		  af.show();
	       }
	     return(false);   // Hide the calling frame
	  }
	else
	  {
	     if(--parent.countOfFrames == 0) System.exit(0);
	     return(true);    // Dispose the calling frame
	  }
	
     }

} //End of class jPlot 
