/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de
 * or contact brn@informatik.hu-berlin.de.
 */

/* To run this click configuration keep the following in mind:
 * 
 * This configuration has been tested against the madwifi-ng driver.
 * To setup the driver, run:
 *
 * $ insmod /lib/madwifi-ng-svn/ath/ath_hal.ko
 * $ insmod /lib/madwifi-ng-svn/net80211/wlan.ko
 * $ insmod /lib/madwifi-ng-svn/ath_rate/sample/ath_rate_sample.ko
 * $ insmod /lib/madwifi-ng-svn/net80211/wlan_scan_ap.ko
 * $ insmod /lib/madwifi-ng-svn/ath/ath_pci.ko countrycode=392
 *
    wlanconfig ath0 destroy
    wlanconfig ath0 create wlandev wifi0 wlanmode monitor
    echo '804' > /proc/sys/net/ath0/dev_type
    ifconfig ath0 mtu 2290
    ifconfig ath0 up
    iwconfig ath0 channel 8 essid test
 *
 * With countrycode 392 all 14 channels are usable. Run
 *
 * $ wlanconfig ath0 list chan
 *
 * to get a list of available channels.
 *
 * We use Atheros headers to set transmit-parameters per packet.
 * You can use SetTXRate(22) to send a packet with a bitrate of 11MB/s.
 * Further you can use SetTXRate(2, TRIES 10) to send a packet with a bitrate
 * of 1MB/s and 10 tries, which means 9 retries, if the transmission fails.
 * SetTXPower doesn't seem to work.
 *
 * Sent frames are feedbacked and annotated with the TX flag, which can be
 * checked for with element FilterTX. To test if the frame was acknowledged,
 * you can use the element FilterFailures. And to check the CRC checksum use
 * FilterPhyErr.
 *
 * =Service MAC and Service IP=
 *
 * For a proper working service IP and MAC, you have to delete a route with
 * 
 * $ route del -net 10.9.0.0/24 serv
 *
 * This is working, but more investigation may be needed. Is there a cleaner
 * solution?
 *
 * =Virtual station=
 * 
 * The virtual station acts like a real station, but is running on the meshnode
 * in userspace. This way it is possible to access a meshnode with IP protocol,
 * if the virtual station is running. To start up the virtual station on a wgt634u
 * run:
 *
 * $ udhcpc -i local
 *
 * This will obtain an IP address for the local device by which the virtual
 * station can be addressed.
 *
 * =Observations and Hints=
 *
 * - SetTXPower has no effect.  
 *
 * - Always make sure that the cards channel and the beacons channel (iwconfig
 * ath0 channel == main.click/access_point/winfo/channel) are the same. The
 * channels have to match, otherwise the station's association won't work.
 *
 */

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * Lots of utility elementclasses. The idea is to overwrite the standard PrintXXX elements.
 */

elementclass Print {
    __REST__ $rest |

  input[0]
  //-> Print($rest)
  -> [0]output;
}

elementclass IPPrint {
    __REST__ $rest |

  input[0]
  //-> IPPrint($rest)
  -> [0]output;
}

elementclass PrintWifi {
    __REST__ $rest |

  input[0]
  //-> PrintWifi($rest)
  -> [0]output;
}

elementclass ARPPrint {
    __REST__ $rest |

  input[0]
  //-> ARPPrint($rest)
  -> [0]output;
}

elementclass DHCPPrint {
    __REST__ $rest |

  input[0]
  //-> DHCPPrint($rest)
  -> [0]output;
}

/**
 * Define the ToDumpWifi as empty class (no dumping). To enable dumping,
 * uncomment the lines below.
 * 
 * For simulation purposes the element class is redefined in simdevices.click
 */
elementclass ToDumpWifi {
  $file_name |
//  dump_wifi  :: ToDump($file_name.pcap, SNAPLEN 3000, ENCAP 802_11);
||
  DUMP $dump_element |
//  input -> ToDumpDlg($dump_element/dump_wifi) -> output;
  input -> output;
}

/**
 * Define the ToDumpEther as empty class (no dumping). o enable dumping,
 * uncomment the lines below.
 * 
 * For simulation purposes the element class is redefined in simdevices.click
 */
elementclass ToDumpEther {
  $file_name |
//  dump_ether  :: ToDump($file_name.pcap, SNAPLEN 0, ENCAP ETHER);
||
  DUMP $dump_element |
//  input -> ToDumpDlg($dump_element/dump_ether) -> output;
    input -> output;
}

elementclass HostDualFilter { ADDR1 $addr1, ADDR2 $addr2, __REST__ $rest |
  input[0] -> hfilter1 :: HostEtherFilter($addr1, $rest) -> [0]output;
  hfilter1[1] -> hfilter2 :: HostEtherFilter($addr2, $rest) -> [0]output;
  hfilter2[1] -> [1]output;
}
  

// TODO uncomment to disable node dumps
/**
 * Redefine the ToDumpWifi element for simulation purposes.
 */
elementclass ToDumpWifi {
  $file_name |

  dump_wifi  :: ToDump($file_name.pcap, SNAPLEN 0, ENCAP 802_11, PER_NODE 1);
//  dump_wifi  :: ToDump($file_name.pcap, SNAPLEN 0, ENCAP PRISM, PER_NODE 1);
||
  DUMP $dump_element |
  
  input -> ToDumpDlg($dump_element/dump_wifi) -> output;
//  input -> tee :: Tee -> output;
//  tee[1] -> Prism2Encap() -> ToDumpDlg($dump_element/dump_wifi) -> Discard;
//  input -> output;
}

/**
 * Redefine the ToDumpEther element for simulation purposes.
 */
elementclass ToDumpEther {
  $file_name |

  dump_ether  :: ToDump($file_name.pcap, SNAPLEN 0, ENCAP ETHER, PER_NODE 1);
||
  DUMP $dump_element |
  
  input -> ToDumpDlg($dump_element/dump_ether) -> output;
//  input -> output;
}

// needed for simulation
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */


/**
 * Element class for a dhcp client. Uses the DHCPClient from the dhcp package.
 * 
 * input: ip-encaped dhcp packets
 * ouput dhcp packets encaped in ip/udp
 *
 * $addr - own hardware address.
 * $req_addr - the address to request.
 * $start_s - start time in sec.
 */
elementclass DHCPClient{ 
  $addr, REQ_ADDR $req_addr, START $start_s |
  
	client :: DHCPClient($addr, REQ_ADDR $req_addr, START $start_s);
	
	input
		-> CheckIPHeader(0)
		-> CheckUDPHeader()
		-> CheckDHCPMsg()
		-> [0]client;
		
	client[0]
		-> UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
		-> [0]output;		
	
	queue::DHCPOfferMsgQueue(client.client_ip_read) 
		-> [1]client; //pull 
	
	client[1] 
		-> udp_encap :: UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
		-> DHCPUnicastEncap(client.client_ip_read, client.server_ip_read)
		-> [1]output
	
	client[2] -> queue;
	client[3] -> Discard;
}

/**
 * NS2 needs ethernet headers, JiST not. If using ns2, uncomment the AddEtherNsclick.
 */
elementclass AddSimHeader {
  //input -> AddEtherNsclick() -> output;
  input -> output;
}

/**
 * NS2 needs ethernet headers, JiST not. If using ns2, uncomment the Strip.
 */
elementclass StripSimHeader {
  //input -> Strip(14) -> output;
  input -> output;
}

/**
 * Element class FromDevice for simulation purposes with JiST/SWANS. If it is
 * a wifi device, it will also put out transmission feedback.
 * 
 * output[0] Frames from the specified device. 
 */
elementclass FromDevice { 
  $dev_name |

  // only wifi frames are feedbacked
  FromSimDevice($dev_name, 4096, TXFEEDBACK true) 
		-> StripSimHeader()
	  -> SetTimestamp()
		-> [0]output;
}

/**
 * Element class ToDevice for simulation purposes with JiST/SWANS. 
 * 
 * Note: The encap is set to unknown, i.e. we conduct no runtime type checks
 * for packets given to that device. It is assumed that we get the right type.
 *
 * input[0] Input for frames from click to the simulator using the specified device.
 */
elementclass ToDevice { $dev_name |

	input[0]
  	-> AddSimHeader()
  	-> ToSimDevice($dev_name, ENCAP UNKNOWN);
}

/**
 * Element class FromHost for simulation purposes with JiST/SWANS. It issues 
 * ARP requests on its output which must be answered on through its input.
 *
 * If the second form without static ip is used, a DHCP client queries for an
 * ip address after 20s simulation time.
 * 
 * Limitation: JiST/SWANS currently supports only one FromHost element per
 * click instance (see ClickRouter in JiST).
 * 
 * TODO make IPFilter working
 * 
 * input[0]  ARP replies for the issued requests.
 * output[0] Frames from the specified device. 
 */
elementclass FromHost {
	  $dev_name, $ip, ETHER $addr |
  
  from_sim_device :: FromSimDevice($dev_name, 4096, TXFEEDBACK false, TUNNEL true);
  
  from_sim_device[0]
  	-> StripSimHeader()
  	-> CheckIPHeader(0)
  	-> ip_filter :: IPClassifier(src host $ip, -)
		-> arp :: ARPQuerier($ip, $addr)
	  -> SetTimestamp()
		-> [0]output;

	ip_filter[1]
	  //-> IPPrint("packet with wrong src ip from host")
	  -> Discard;

  from_sim_device[1]
    -> [1]arp;
||
  $dev_name, ETHER $addr |

  from_sim_device :: FromSimDevice($dev_name, 4096, TXFEEDBACK false, TUNNEL true);

  AddressInfo(req_addr $dev_name:eth)
  dhcp_client :: DHCPClient($addr, REQ_ADDR req_addr:ip, START 30);

  from_sim_device[0]
  	-> StripSimHeader()
  	-> CheckIPHeader(0)
  	-> ip_filter :: IPClassifier(src host req_addr:ip, -)
		-> arp :: ARPQuerier(req_addr:ip, $addr)
	  -> SetTimestamp()
		-> [0]output;

	ip_filter[1]
	  //-> IPPrint("packet with wrong src ip from host")
	  -> Discard;

  dhcp_output :: Null
//    -> UDPIPEncap(0.0.0.0, 68, 255.255.255.255, 67)
    -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
	  -> SetTimestamp()
    -> [0]output;

  dhcp_client[0]
    -> dhcp_output;

  dhcp_client[1]
    -> dhcp_output;

  //--------------------------------------------------------------------
  // handle tunneled packets
  from_sim_device[1]
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -);

  ethertype_clf[0]
    -> [1]arp;

  ethertype_clf[1]
    -> EtherDecap()	
	  -> CheckIPHeader(0)
//	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
//    -> Strip(28) // strip ip and udp
	  -> dhcp_client;
	
	bogus :: Null
	  -> Print("ERROR: got unexpected packet (waiting for ARP and DHCP)")
	  -> Discard;

	ethertype_clf[2]
	  -> bogus;
	  
//	ip_classifier[1]
//	  -> bogus;
	  
}

/**
 * Element class ToHost for simulation purposes with JiST/SWANS. 
 *
 * input[0] Input for frames from click to the simulator using the local device.
 */
elementclass ToHost { $dev_name |

  to_sim_device :: ToSimDevice($dev_name, ENCAP ETHER, TUNNEL true);

  // arp and dhcp is tunneled to the corresponding FromSimDevice
	input[0]
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -)
  	-> AddSimHeader()
    -> [1]to_sim_device;
  
  ethertype_clf[1]
	  -> CheckIPHeader(14)
	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
    -> [1]to_sim_device;

  // all except arp and dhcp goes to the simulator
  ethertype_clf[2]
  	-> AddSimHeader()
    -> [0]to_sim_device;

  ip_classifier[1]
  	-> AddSimHeader()
    -> [0]to_sim_device;
}

/**
 * Redefinition of the NotifierQueue, sets the sleepiness trigger to 0 (speeds
 * up simulation since unnecessary pulls are prevented).
 */
elementclass NotifierQueue {
    __REST__ $rest |

  input[0]
    -> NotifierQueue($rest, SLEEPINESS_TRIGGER 0)
    -> [0]output;
}

/**
 * Redefinition of the Queue, sets the sleepiness trigger to 0 (speeds
 * up simulation since unnecessary pulls are prevented).
 */
elementclass Queue {
    __REST__ $rest |

  input[0]
    -> Queue($rest, SLEEPINESS_TRIGGER 0)
    -> [0]output;
}

/**
 * Redefinition of the element ControlSocket.
 * Since we are simulating, we do not need a ControlSocket. Use the 
 * ClickSimController Tool instead.
 */
elementclass ControlSocket {
    __REST__ $rest |
}

/**
 * Redefinitions of the elements AthdescDecap and AthdescEncap.
 * Since we use extra header in simulation, redifine the decap.
 */
elementclass AthdescDecap {
  input -> ExtraDecap() -> output;
}
elementclass AthdescEncap {
  input -> ExtraEncap() -> output;
}
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/**
 * Element class offering the same interface as a virtual devices, 
 * but the purpose of this element is to syntesize arp and dhcp requests.
 * It acts as a set of simulated clients.
 *
 * USAGE: include this file after simdevices.click in main.click and use
 *        the elementclass DhtSimDevice for the element local_device.
 * 
 * input[0]  send to the simulated device
 * output[0] captured frames from the device
 *
 * @param $dev_name the name of the device, e.g. eth0
 * @param $addr the mac address to use with the device
 */
elementclass DhtSimDevice { 
  $dev_name, ETHER $addr |

  //----------------------------------------------------------------------------
  // element setup

  AddressInfo(req_addr $dev_name:eth)

  // Note: the arp client is configured through JiST
  arpclient :: ARPClient(req_addr:ip, // Client IP address
                         $addr, // Client ethernet address
                         10.9.0.0,  // Requested IP address Start
                         1024,      // Requested Address Range
                         40000,     // Start
                         450, // Interval
                         160, // Count
                         16,  // Requests at once
                         5000, // Timeout in ms
                         ACTIVE false );

  // Note: the dhcp client is configured through JiST
  dhcp_client :: DHCPRequester($addr, // First EtherAddress
                            req_addr:ip, // First IPAddress
                            1,     // Range
                            40000, // starttime (s)
                            400,   // time between dhcp_packets (s)
                            ACTIVE false );

  dump_ether :: ToDumpEther($dev_name);

  //----------------------------------------------------------------------------
  // inputs

  input[0]
    -> ToDumpEther(DUMP dump_ether)
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -)
    -> arpclient;

	ethertype_clf[1]
	  -> CheckIPHeader(14)
	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
    -> EtherDecap()	
    -> Strip(28) // strip ip and udp
	  -> dhcp_client;

	ethertype_clf[2]
		-> Print("ERROR: Got unexpected packet")
		-> Discard;
	
	ip_classifier[1]
		-> Print("ERROR: Got unexpected packet")
		-> Discard;

  //----------------------------------------------------------------------------
  // outputs
  
  to_output :: Null
	  -> SetTimestamp()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
    
  arpclient[0]
    -> to_output;
	
  dhcp_output :: Null
    -> UDPIPEncap(0.0.0.0, 68, 255.255.255.255, 67 )
    -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
    -> to_output;

  dhcp_client[0]
    -> dhcp_output;

  dhcp_client[1]
    -> dhcp_output;
  
}

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/**
 * Element class for wifi devices.
 *
 * input[0]  send to device
 * output[0] captured frames without feedback
 * output[1] frames with tx feedback
 */
elementclass WifiDevice {
  $dev_name |

  dump_wifi :: ToDumpWifi($dev_name);

  FromDevice($dev_name) 
    -> AthdescDecap() // You must have set "echo '804' > /proc/sys/net/ath0/dev_type" with madwifi-ng driver
    -> ToDumpWifi(DUMP dump_wifi)
    -> filter_phy :: FilterPhyErr()
    -> filter :: FilterTX()
    -> WifiDupeFilter()
    -> [0]output;
  
  filter_phy[1]
    -> Discard;

  filter[1]
    -> [1]output;

  input[0]
    -> ToDumpWifi(DUMP dump_wifi)
    -> AthdescEncap() // You must have set "echo '804' > /proc/sys/net/ath0/dev_type" with madwifi-ng driver
    -> ToDevice($dev_name);
}


/**
 * Element class for ethernet devices.
 * 
 * input[0]  send to device
 * output[0] captured frames from the device
 */
elementclass EthDevice {
  $dev_name |
  
  dump_ether :: ToDumpEther($dev_name);

  FromDevice($dev_name)
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;

  input[0]
    -> ToDumpEther(DUMP dump_ether)
    -> ToDevice($dev_name);
}

/**
 * Element class for virtual devices,
 * The first form is meant to be used with an external dhcp client,
 * the second form uses a static given ip address for the local device and
 * the third form uses an internal dhcp client to configure the device.
 * 
 * input[0]  send to device
 * output[0] captured frames from the device
 *
 * @param $dev_name the name of the device, e.g. eth0
 * @param $addr the mac address to use with the device
 * @param $ip the ip address to use with the local device
 * @param $dhcp_start the time in ms to start internal dhcp client.
 */
elementclass VirtualDevice { 
  $dev_name, ETHER $addr |
  
  dump_ether :: ToDumpEther($dev_name);

  from_host :: FromHost($dev_name, ETHER $addr)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
    -> SetPacketType(HOST)
    -> to_host :: ToHost($dev_name);
|| 
  $dev_name, $ip, ETHER $addr |

  dump_ether :: ToDumpEther($dev_name);

	from_host :: FromHost($dev_name, $ip, ETHER $addr)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
		-> SetPacketType(HOST)
    -> to_host :: ToHost($dev_name)
/*
|| 
  $dev_name, ETHER $addr, START $dhcp_start_s |

  dump_ether :: ToDumpEther($dev_name);

  AddressInfo(req_addr $dev_name:eth)
  dhcp_client :: DHCPClient($addr, req_addr:ip, $dhcp_start_s);

	from_host :: FromHost($dev_name, ADDR $addr, IP req_addr:ip)
    -> SetEtherAnno()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;
  
  input[0]
    -> ToDumpEther(DUMP dump_ether)
		-> ethertype_clf :: Classifier(12/0806, 12/0800, -)
		-> from_host;

	to_host :: Null
		-> SetPacketType(HOST)
    -> ToHost($dev_name)

	ethertype_clf[1]
	  -> CheckIPHeader(14)
	  -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -) 
    -> EtherDecap()	
    -> Strip(28) // strip ip and udp
	  -> dhcp_client;

	ethertype_clf[2]
		-> to_host;
	
	ip_classifier[1]
		-> to_host;
	
  dhcp_output :: Null
    -> UDPIPEncap(0.0.0.0, 68, 255.255.255.255, 67 )
    -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
	  -> SetTimestamp()
    -> ToDumpEther(DUMP dump_ether)
    -> [0]output;

  dhcp_client[0]
    -> dhcp_output;

  dhcp_client[1]
    -> dhcp_output;
*/
}


/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * BRN MeshNode config file for kernel click
 *
 * TODO: move disassociator to the iapp elementclass
 *
 * TODO: factor olsr* stuff out of main-hybrid, use the meshnode class also for olsr
 * 
 */

elementclass Meshnode {
  SSID $ssid, WIFI_DEV $wifi_dev, WIFI_CHANNEL $channel, 
  ETH_DEV $eth_dev, LOCAL_DEV $local_dev, 
  PREFIX $addr_prefix, SERVICE_IP $service_ip |
  
  
  // include compounds
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * 802.11b access point configuration in click
 */

/* Parameter:
 * ==========
 * - INTERFACE       := interface used by AP
 * - SSID            := name of wireless network
 * - CHANNEL         := the used 802.11 frequency (domain: 1-14)
 * - BEACON_INTERVAL := time between two AP beacons (in milliseconds)
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- 802.11 management frames (should be addressed to INTERFACE)
 *  - output[0]       -> 802.11 management frames (from this INTERFACE)
 */

elementclass AccessPoint {
    INTERFACE $device, SSID $ssid, CHANNEL $channel, 
    BEACON_INTERVAL $beacon_interval, RATES $rates, IAPP $iapp |

    AddressInfo(ether_address $device:eth);
    winfo :: WirelessInfo(SSID $ssid, BSSID ether_address, CHANNEL $channel, 
             INTERVAL $beacon_interval);
    rates :: AvailableRates($rates);

    assoc_resp :: BRNAssocResponder(DEBUG 0, WIRELESS_INFO winfo, RT rates, 
    		IAPP $iapp);

    input[0]
    -> mgt_cl :: Classifier(
          0/00%f0, // assoc req
          0/10%f0, // assoc resp
          0/20%f0, // reassoc req
          0/30%f0, // reassoc resp
          0/40%f0, // probe req
          0/50%f0, // probe resp
          0/80%f0, // beacon
          0/90%f0, // ATIM
          0/a0%f0, // disassoc
          0/b0%f0, // auth 
          0/c0%f0, // deauth
          -        // reserved
          );

    mgt_cl[0] // assoc req
    //-> PrintWifi(" Association request ")
    -> assoc_resp;
     
    mgt_cl[1] // assoc resp
    //-> PrintWifi(" Association response ")
    -> assoc_resp;

    mgt_cl[2] // reassoc req
    //-> PrintWifi(" Reassociation request ")
    -> assoc_resp;

    mgt_cl[3] /// reassoc resp
    //-> PrintWifi(" Reassociation response ")
    -> assoc_resp;

    mgt_cl[4] // probe req
    //-> PrintWifi(" Probe request ")
    -> beacon_source :: BeaconSource(WIRELESS_INFO winfo, RT rates, DEBUG false)
    //-> PrintWifi(" Probe response ")
    //-> PrintWifi(" MEIN BEACON ")
    -> [0]output;

    mgt_cl[5] // probe resp
    -> Discard;

    mgt_cl[6] // beacon
    //-> PrintWifi("BEACON")
    //-> BeaconScanner(RT rates)
    -> Discard; 

    mgt_cl[7] // ATIM
    -> Discard;

    mgt_cl[8] // disassoc
    //-> PrintWifi(" Disassociation ")
    -> assoc_resp;

    mgt_cl[9] // auth
    //-> PrintWifi(" Autentication ")
    //-> Print()
    -> OpenAuthResponder(WIRELESS_INFO winfo)
    //-> PrintWifi(" Autentication Response ")
    //-> Print()
    -> [0]output;
    
    mgt_cl[10] // deauth
    -> Discard;

    mgt_cl[11] // reserved
    -> Discard;

  
  assoc_resp
    //-> PrintWifi("from_assoc_responder")
    -> [0]output;

  all :: CompoundHandler("debug", "BRNAssocResponder",
	"2");
||
    INTERFACE $device, SSID $ssid, CHANNEL $channel, 
    BEACON_INTERVAL $beacon_interval, RATES $rates, IAPP $iapp, BRNVLAN $vlan |

    AddressInfo(ether_address $device:eth);
    winfo :: WirelessInfo(SSID $ssid, BSSID ether_address, CHANNEL $channel, 
             INTERVAL $beacon_interval);
    rates :: AvailableRates($rates);

    assoc_resp :: BRNAssocResponder(DEBUG 0, WIRELESS_INFO winfo, RT rates, 
    		IAPP $iapp, BRNVLAN $vlan);

    input[0]
    -> mgt_cl :: Classifier(
          0/00%f0, // assoc req
          0/10%f0, // assoc resp
          0/20%f0, // reassoc req
          0/30%f0, // reassoc resp
          0/40%f0, // probe req
          0/50%f0, // probe resp
          0/80%f0, // beacon
          0/90%f0, // ATIM
          0/a0%f0, // disassoc
          0/b0%f0, // auth 
          0/c0%f0, // deauth
          -        // reserved
          );

    mgt_cl[0] // assoc req
    //-> PrintWifi(" Association request ")
    -> assoc_resp;
     
    mgt_cl[1] // assoc resp
    //-> PrintWifi(" Association response ")
    -> assoc_resp;

    mgt_cl[2] // reassoc req
    //-> PrintWifi(" Reassociation request ")
    -> assoc_resp;

    mgt_cl[3] /// reassoc resp
    //-> PrintWifi(" Reassociation response ")
    -> assoc_resp;

    mgt_cl[4] // probe req
    //-> PrintWifi(" Probe request ")
    -> beacon_source :: BeaconSource(WIRELESS_INFO winfo, RT rates, DEBUG false, BRNVLAN $vlan)
    //-> PrintWifi(" Probe response ")
    //-> PrintWifi(" MEIN BEACON ")
    -> [0]output;

    mgt_cl[5] // probe resp
    -> Discard;

    mgt_cl[6] // beacon
    //-> PrintWifi("BEACON")
    //-> BeaconScanner(RT rates)
    -> Discard; 

    mgt_cl[7] // ATIM
    -> Discard;

    mgt_cl[8] // disassoc
    //-> PrintWifi(" Disassociation ")
    -> assoc_resp;

    mgt_cl[9] // auth
    //-> PrintWifi(" Autentication ")
    //-> Print()
    -> OpenAuthResponder(WIRELESS_INFO winfo)
    //-> PrintWifi(" Autentication Response ")
    //-> Print()
    -> [0]output;
    
    mgt_cl[10] // deauth
    -> Discard;

    mgt_cl[11] // reserved
    -> Discard;

  
  assoc_resp
    //-> PrintWifi("from_assoc_responder")
    -> [0]output;

  all :: CompoundHandler("debug", "BRNAssocResponder",
	"2");
}

/* Usage:
 * ======
 * ap :: AccessPoint(INTERFACE ath0, SSID MyWifiNetwork, CHANNEL 1, 
 *       BEACON_INTERVAL 100, RATES DEFAULT 2 4 11 12 18 22);
 *
 * Attention:
 * ==========
 * - device MUST! be set to the same CHANNEL (run "iwconfig ath0 channel CHANNEL")
 *   otherwise no station will associate!
 */

/* Examples:
 * =========
   
   AddressInfo(my_wifi_dev ath0:eth);
   
   FromDevice(ath0)
   -> Prism2Decap()
   -> ExtraDecap()
   -> frame_clf :: Classifier(0/00%0f)    // 802.11 management frames only
//   -> HostWifiFilter(DROP_OTHER TRUE, ETHER my_wifi_dev)
   -> PrintWifi(Before)
   -> ap :: AccessPoint(INTERFACE ath0, SSID MyWifiNetwork, CHANNEL 1, 
   BEACON_INTERVAL 100, RATES DEFAULT 2 4 11 12 18 22)
   -> PrintWifi(After)
   -> Queue()
   -> ToDevice(ath0);
   
 */
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * Dynamic Source Routing (DSR) configuration in click
 *
 * Assigned to layer 2
 */

/* Parameter:
 * ==========
 * - {n-th parameter}  := network device number n
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- ethernet (802.3) frames from stations (EtherType != 0x8086 == no BRN protocol)
 *  - input[1]        <- BRN DSR packets from other mesh nodes (BRN core)
 *  - input[2]        <- failed transmission of a BRN DSR packet (broken link) from ds
 *  - [0]output       -> ethernet (802.3) frames to stations or this node (no BRN protocol)
 *  - [1]output       -> BRN DSR packets to other mesh nodes (BRN DSR protocol)
 *  - [2]output       -> BRN DSR packets which could not be forwarded (BRN DSR protocol)
 */


elementclass DSR {
NODE_IDENTITY $id, ASSOC_STATIONS $assoc_stations, IAPP $iapp |

  /* definitions */
  brn_encap :: BRNEncap();
  dsr_decap :: DSRDecap($id);
  dsr_encap :: DSREncap($id);
  nb :: DstClassifier($id, $assoc_stations);
  querier :: RouteQuerier($id, dsr_encap, brn_encap, dsr_decap, $iapp);
  req_forwarder :: RequestForwarder($id, dsr_decap, dsr_encap, brn_encap, querier, $assoc_stations, 300, $iapp);
  rep_forwarder :: ReplyForwarder($id, dsr_decap, querier, $assoc_stations, dsr_encap);
  src_forwarder :: SrcForwarder($id, $assoc_stations, dsr_encap, dsr_decap);
  err_forwarder :: ErrorForwarder($id, $assoc_stations, dsr_encap, dsr_decap, querier, brn_encap);

  // ------------------
  // external packets
  // ------------------
  input[0]
  -> clf_bcast :: Classifier(0/ffffffffffff, -); // broadcast & unicast packets

  clf_bcast[0]
  -> Discard;

  clf_bcast[1]
  -> nb;

  nb[0] // packet is for me
  -> [0]output;

  nb[1] // packet for associated client (external)
  -> [0]output;

  nb[2] // packet for internal nodes
  -> SetTimestamp()
  //-> Print( "Data-Preinit",TIMESTAMP true )
  -> querier;

  querier[0]
  -> SetTimestamp()
  //-> Print( "RREQ-Init",TIMESTAMP true )
  //-> BRNPrint()
  -> [1]output; // rreq packets (broadcast)
  
  querier[1] 
  -> SetTimestamp()
  //-> Print( "Data-Init",TIMESTAMP true )
  -> [0]src_forwarder; // src routed packets (unicast)

  src_forwarder[0]
  //-> BRNPrint()
  -> [1]output;

  src_forwarder[1]
  -> [0]output;

  src_forwarder[2]
  //-> Print("from_src_fwd_to_err_fwd")
  -> tee_to_err_fwd :: Tee()
  //-> BRNPrint()
  -> [2]output;

  tee_to_err_fwd[1]
  -> [0]err_forwarder;

  // ------------------
  // internal packets
  // ------------------
  input[1]
  //-> Print(DSR_CLF, NBYTES 14)
  //-> PrintEtherAnno(for_clf)
  //-> Align(1, 0)
  //-> Classifier(0/03)
  //-> Print(DSR_CLFXXXXXXXX, NBYTES 14) 
  //-> PrintEtherAnno(for_clf2)
  //-> BRNPrint()
  -> dsrclf :: Classifier(6/01, //DSR_RREQ
                          6/02, //DSR_RREP
                          6/03, //DSR_RERR
                          6/04, //DSR_SRC
                          );

  dsrclf[0]
  //-> Print(DSR_CLF0, NBYTES 14)
  //-> BRNPrint()
  -> req_forwarder[0]
  //-> Print( "RREQ-Forward" )
  //-> BRNPrint()
  -> [1]output;

  req_forwarder[1]
  -> [0]rep_forwarder
  -> SetTimestamp()
  //-> Print( "RREPL" ,TIMESTAMP true )
  //-> BRNPrint()
  -> [1]output;

  dsrclf[1]
  //-> Print(DSR_CLF1, NBYTES 14)
  //-> BRNPrint()
  -> [1]rep_forwarder;

  dsrclf[2]
  //-> Print(DSR_CLF2, NBYTES 14)
  //-> BRNPrint()
  -> [1]err_forwarder
  //-> BRNPrint()
  -> [1]output;

  dsrclf[3]
  //-> Print(DSR_CLF3, NBYTES 14)
  //-> PrintEtherAnno(nach_clf) 
  //-> BRNPrint()
  -> [1]src_forwarder;

  // ------------------
  // undeliverable packets
  // ------------------
  input[2]
  //-> Print("from_input_to_err_fwd")
  //-> BRNPrint()
  -> [0]err_forwarder;


  all :: CompoundHandler("debug", "BRNEncap DSRDecap DSREncap DstClassifier
	RouteQuerier RequestForwarder ReplyForwarder SrcForwarder ErrorForwarder",
	"2");
}

/* Usage:
 * ======
 * dsr :: DSR(NODE_IDENTITY id, LINK_TABLE link_table, ASSOC_STATIONS ap/assoc_stations);
 */ 


/* Example:
 * ======

// TODO

 */
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/**
 *
 * Services available in BRN
 *
 */

/**
 * Parameter:
 * ==========
 *
 * TODO
 *
 */

/** 
 * In- and Output ports:
 * =====================
 *  - input[0]        <- 802.3 frame to virtual station (local)
 *  - input[1]        <- 802.3 frame with service mac or broadcasts
 *  - input[2]        <- BRN DHT
 *  - input[3]        <- BRN Gateway
 *  - input[4]        <- BRN IAPP Gateway (used for information about hand overs)
 *  - input[5]        <- BRN IAPP
 *  - [0]output       -> 802.3 frame from virtual station (local)
 *  - [1]output       -> 802.3 to ds (responses from services) broadcasts e.g. dhcp
 *  - [2]output       -> BRN DHT
 *  - [3]output       -> 802.3 to service_filter (responses from services)
 *  - [4]output       -> BRN IAPP Gateway (used for information about hand overs)
 *
 *
 */

elementclass Services {
    WIFI_MAC $wifi_mac,
    PREFIX $addr_prefix,
    LINKTABLE $link_table,
    SERVICE_MAC $service_mac,
    SERVICE_IP $service_ip,
    LOCAL_DEVNAME $local_dev,
    LOCAL_MAC $local_mac |

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * DHCP using DHT
 *
 */

/* Parameter:
 * ==========
 * - SERVICE_MAC        :=
 * - SERVICE_IP         :=
 *
 */

/* In- and Output ports:
 * =====================
 *  - [0]input        <- 802.3 IP UDP DHCP request
 *  - [1]input        <- BRN DHT DHCP
 *  - output[0]       -> 802.3 IP UDP DHCP response
 *  - output[1]       -> BRN DHT DHCP
 *
 */

elementclass DHCP {
	$addr_prefix, SERVICE_MAC $service_mac, SERVICE_IP $service_ip |
//IP/MASK, DNS_SERVER, DOMAIN, GATEWAY_IP, SERVER_IP, SERVER_NAME |

    input[0]
    -> EtherDecap()
    -> Strip(28) // strip ip and udp
    -> dhcp_server :: DHCPServer(my_wlan, $addr_prefix, $service_ip, $service_ip, 
        141.20.20.50 ,"dhcp.berlinroofnet.de","berlinroofnet.de") 
    -> UDPIPEncap($service_ip, 67, 255.255.255.255, 68)
    -> EtherEncap(0x0800, $service_mac, ff:ff:ff:ff:ff:ff) 
    -> [0]output;

    input[1]
    -> [1]dhcp_server[1]
    -> [1]output;

}

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * ARP using DHT
 *
 */

/* Parameter:
 * ==========
 * - SERVICE_IP         := 
 * - SERVICE_MAC        := 
 *
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- 802.3 ARP
 *  - input[1]        <- BRN DHT ARP
 *  - output[0]       -> 802.3 ARP
 *  - output[1]       -> BRN DHT ARP
 */

elementclass ARP {
    SERVICE_IP $service_ip, SERVICE_MAC $service_mac, PREFIX $addr_prefix |

  input[0]
  -> arp :: Arp($service_ip, $service_mac, PREFIX $addr_prefix)
  -> [0]output;

  input[1]
  -> [1]arp[1]
  -> [1]output;

}

/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * Gateway Service in Click
 */

/* Parameter:
 * ==========
 * - ETHER_ADDR               := ether address used for communication
 * - LINKTABLE                := linktable used by routing
 * - UPDATE_GATEWAYS_INTERVAL := interval (in s) to update list of gateways
 * - UPDATE_DHT_INTERVAL      := interval (in s) to update this node in dht
 * - PREFIX                   := networks prefix
 * - SERVICE_IP               := service IP
 *
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- 802.3 IP frames (to Gateway Service)
 *  - input[1]        <- 802.3 BRN Gateway
 *  - input[2]        <- 802.3 to local gateway (used if this node is a gateway)
 *  - input[3]        <- 802.3 from local gateway
 *  - input[4]        <- BRN DHT for communication with FalconDHT
 *  - input[5]        <- BRN IAPP Gateway (used to transfer hand over information) from other nodes
 *  - input[6]        <- BRN IAPP from this node (used to add flow info)
 *  - [0]output       -> 802.3 IP frames (from Gateway Service)
 *  - [1]output       -> 802.3 IP frames to chosen gateway
 *  - [2]output       -> 802.3 to local device
 *  - [3]output       -> 802.3 BRN Gateway feedback packet to orginator
 *  - [4]output       -> BRN DHT for communication with FalconDHT
 *  - [5]output       -> BRN IAPP Gateway (used to transfer hand over information)
 */

elementclass Gateway {
    ETHER_ADDR $my_wlan,
    LINKTABLE $lt,
    UPDATE_GATEWAYS_INTERVAL $up_gws,
    UPDATE_DHT_INTERVAL $up_gw,
    PREFIX $addr_prefix,
    SERVICE_IP $service_ip,
    |

    // stores clients IP/MAC combination
    mac_ip :: ARPTable();
    table :: ARPTable();
    clients :: StoreIPEthernet(mac_ip)
    setgwflow :: BRNSetGatewayOnFlow(gateway, flows, $lt, mac_ip, buffer, $addr_prefix); // implements AggregateListener
    buffer :: BRNPacketBuffer(setgwflow, 50);

    ///////
    // DHT communication
    ///////
    input[4]
    //-> Print("Got DHT response", NBYTES 100)
    -> gateway :: BRNGateway($my_wlan, setgwflow, UPDATE_GATEWAYS_INTERVAL $up_gws, UPDATE_DHT_INTERVAL $up_gw)
    //-> Print("Generated DHT request", NBYTES 100)
    ->[4]output;

    ///////
    // generate ICMP error
    ///////
    icmp_error2client :: Null
    -> StoreIPEthernet(table)
    -> EtherDecap()
    -> udp :: IPClassifier(udp, -)
    // answer UDP with port unreachable
    -> ICMPError($service_ip, unreachable, port)
    -> resolve :: ResolveEthernet($my_wlan, table)
    -> paint :: CheckPaint(0)
    // no gateway known
    -> [0]output;

    udp[1]
    // anwser everything else with host unreachable
    -> ICMPError($service_ip, unreachable, host)
    -> resolve;

    // remote gateway failed
    paint[1]
    -> paint2 :: CheckPaint(1)
    -> encap :: BRNGatewayEncap(gateway);

    paint2[1]
    -> Print("BOGUS - Should never happen")
    -> IPPrint()
    -> Discard;


    //////
    // packets from clients to Internet
    //////
    input[0]
    -> from_clients :: IPClassifier(udp && dst port 1194, tcp or udp, -)   // pass criteria for flow and non-flow packets
    -> setgw :: BRNSetGateway(gateway, $lt) // non-flow packets
    -> [1]output;

    from_clients[2] // also non-flow
    -> setgw; 

    // no gateway known
    setgw[1]
    //-> Print("No gateway known")
    // generate ICMP error
    -> Paint(0) // for identification
    -> icmp_error2client;


    from_clients[1] // flow packets
    //-> IPPrint("TO FLOW")
    -> flows :: AggregateIPFlows(TCP_TIMEOUT 60, TCP_DONE_TIMEOUT 10, UDP_TIMEOUT 60, ICMP false)
    -> direction :: IPClassifier(src $addr_prefix, -) // look only for our client for a gateway; not the reverse flow's packets
    -> clients
    -> buffer
    -> setgwflow
    -> [1]output;
	
    flows[1]
    -> Print("BOGUS - Should never happen")
    -> IPPrint()
    -> Discard;

    // no gateway known
    setgwflow[1]
    -> Print("No gateway known")
    // generate ICMP error
    -> Paint(0) // for identification
    -> icmp_error2client;


    //////
    // packets from Internet to clients
    //////
    input[1]
    -> decap :: BRNGatewayDecap(gateway)
    // flow packets have to pass AggregateIPFlows
    -> CheckIPHeader(14)
    -> to_clients :: IPClassifier(udp && src port 1194, tcp or udp or icmp type unreachable, -)
    -> [0]output;

    // send flow packet to flows (used for tracking)
    to_clients[1]
    //-> IPPrint("TO FLOW")
    -> flows;

    // ... but send them only to flow (not to choose a gateway)
    direction[1]
    //-> IPPrint("Reverse packets")
    -> [0]output;

    to_clients[2]
    -> [0]output;


    ///////
    // packets to Internet (this host was chosen as a Internet gateway)
    ///////
    input[2]
    //-> Print(" Packet to Internet ")
    -> before_local_gw :: IPClassifier(udp && src port 1194, tcp or udp, -)
    // supercise packet (this node may not a gateway be anymore)
    -> [1]gws :: BRNGatewaySupervisor(gateway, $lt);

    before_local_gw[2]
    -> [1]gws;

    before_local_gw[1]
    -> [0]gws;

    // passed supervisor
    gws
    //-> Print(" TO INTERNET ")
    //-> IPPrint
    -> [2]output;
    
    ///////
    // packet from local chosen gateway
    ///////
    input[3]
    //-> Print
    -> encap
    //-> Print
    -> [3]output;

    
    //
    // remote gateway failed
    //
    // failed supervisor - non-flow
    gws[1]
    //-> Print("Failed sending to this gateway, but is non-flow; Try again")
    -> from_clients;

    // failed supervisor - flow
    gws[2]
    // flow packet, but this node is no gateway
    // sending ICMP error
    -> Paint(1) // for identification
    -> icmp_error2client;


    ////////
    // handle hand over notify and reply
    ////////
    input[5]
    -> [1]setgwflow;
    input[6]
    -> [2]setgwflow[2]
    -> [5]output;
    

    all :: CompoundHandler("debug",
                           "BRNGatewayEncap BRNGatewayDecap
                            BRNGatewaySupervisor BRNSetGatewayOnFlow
                            BRNGateway BRNSetGateway BRNPacketBuffer",
                           "2");
}

    service_device :: VirtualDevice(serv, $service_ip, ETHER $service_mac);
    local_device :: VirtualDevice($local_dev, ETHER $local_mac);
    gw :: Gateway(ETHER_ADDR $wifi_mac, LINKTABLE $link_table, 
    							UPDATE_GATEWAYS_INTERVAL 60, UPDATE_DHT_INTERVAL 50, 
    							PREFIX $addr_prefix, SERVICE_IP $service_ip);

    input[4]
    -> [5]gw;
    
    input[5]
    -> [6]gw[5]
    -> [4]output;

    local_device[0]
    //-> Print("Packet from localhost")
    -> from_local_clf :: Classifier(12/0800, -)
    -> CheckIPHeader(14)
    -> from_local_ip ::IPClassifier(src net $addr_prefix or dst host 255.255.255.255, -)
    // TODO
    // packets from simulator have src 0.0.0.x
    // changed for simulation
    -> [0]output;

    from_local_clf[1]
    -> [0]output;

    from_local_ip[1]
    // encap feedback for packet sent back
    //-> Print
    //-> IPPrint("From local Internet response for gateway to encap")
    -> [3]gw[3]
    //-> Print("After encap", NBYTES 200)
    -> [0]output;

    input[0]
    -> local_clf :: Classifier(12/0800, -)
    -> CheckIPHeader(14)
    -> local_ip ::IPClassifier(dst net $addr_prefix or dst host 255.255.255.255, -)
    // ip packet for virtual station
    -> [0]local_device;


    local_ip[1]
    // ip packet for gateway
    //-> IPPrint("Packet for local gateway")
    -> [2]gw[2] // supervise packets sent to internet
    -> [0]local_device;

    
    local_clf[1]
    -> [0]local_device;


    

    input[1]
    //-> Print("802.3 frame to service mac")
    -> service_ether_clf :: Classifier(
                                        12/0800,
                                        12/0806,
                                        -
                                      );

    service_ether_clf[0]
    //-> Print("Got IP for services.")
    -> CheckIPHeader(14)
    -> service_ip_clf :: IPClassifier(
                dst udp port 67 and src udp port 68,  // dhcp request
                dst host $service_ip, // service IP 
                dst net $addr_prefix, // packet for other nodes
                - // packet for gateway
                                     )
    -> dhcp :: DHCP($addr_prefix, SERVICE_IP $service_ip, SERVICE_MAC $service_mac)
    -> SetEtherAnno()
    -> [1]output;

    
    service_ip_clf[1]
    //-> Print("Got IP for 10.9.0.1.")
    -> service_device;

    service_device[0]
    -> [3]output;

    service_ip_clf[2]
    -> bc :: HostEtherFilter(FF:FF:FF:FF:FF:FF) // only ARP requests are handled by the ARP service
    -> Discard;

    bc[1]
    -> IPPrint("IP-Packet for other stations with service IP. Discard.")
    -> Discard;

    service_ip_clf[3]
    -> [0]gw[0] // set gateway
    -> [3]output;

    input[3]
    -> [1]gw[1]
    -> [3]output;

    // only ARP requests are handled by the ARP service
    service_ether_clf[1]
    -> ARPPrint("Got ARP packet for services.")
    -> hef :: HostEtherFilter(FF:FF:FF:FF:FF:FF) 
    -> arp :: ARP(SERVICE_MAC $service_mac, SERVICE_IP $service_ip, PREFIX $addr_prefix)
    -> SetEtherAnno()
    -> ARPPrint("Sent ARP response.")
    -> [3]output;

    // pass ARP responses to service MAC
    hef[1]
    -> [0]service_device;

    service_ether_clf[2]
    -> Print("Got non-IP or non-ARP packet for services. How does this happen? Fix me.")
    -> Discard;


    /* packet for communication with DHT */
    input[2]
    -> dht_classifier :: Classifier(
                                    1/03 ,    //arp
                                    1/02 ,    //dhcp
                                    1/04 ,    //gateway
                                    -
                                   );

    dht_classifier[0]
    -> [1]arp[1]
    -> [2]output;
 
    dht_classifier[1]
    -> [1]dhcp[1]
    -> [2]output;

    dht_classifier[2]
    -> [4]gw[4]
    -> [2]output;

    dht_classifier[3]
    //-> Print("Strange packet from DHT")
    -> Discard;
}

/**
 * Usage:
 * ======
 *
 * TODO
 *
 */

/**
 * Examples:
 * =========
   
   TODO

   AddressInfo(my_wifi_dev ath0:eth);
   
   FromDevice(ath0)
   -> Prism2Decap()
   -> ExtraDecap()
   -> frame_clf :: Classifier(0/00%0f)    // 802.11 management frames only
//   -> HostWifiFilter(DROP_OTHER TRUE, ETHER my_wifi_dev)
   -> PrintWifi(Before)
   -> ap :: AccessPoint(INTERFACE ath0, SSID MyWifiNetwork, CHANNEL 1, 
   BEACON_INTERVAL 100, RATES DEFAULT 2 4 11 12 18 22)
   -> PrintWifi(After)
   -> Queue()
   -> ToDevice(ath0);
   
 */
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * DHT
 *
 */

/* Parameter:
 * ==========
 *
 * - LINK_STAT       := link_stat element
 *
 */

/* In- and Output ports:
 * =====================
 *  - input[0]        <- BRN DHT request
 *  - input[1]        <- BRN DHT to DHT packets
 *  - input[2]        <- BRN DSR peeked?
 *  - output[0]       -> BRN DHT response
 *  - output[1]       -> 802.3 BRN DHT to DHT packets broadcast
 *  - output[2]       -> 802.3 BRN DHT to DHT packets unicast
 *  - output[3]       -> BRN DSR peeked?
 */

elementclass DHT { 
WIFI_DEV $wifi_dev, LINK_STAT $link_stat, PREFIX $addr_prefix | 

  AddressInfo(my_wlan $wifi_dev:eth);

  dht :: FalconDHT(my_wlan, $link_stat, $addr_prefix, 5000 , 10 , 50 , 25 );

  input[0]
  -> [1]dht[1]
  -> [0]output;

  input[1]
  -> Strip(6) // TODO StripBRNHeader???
  -> [0]dht[0]
  -> dht_out_clf :: Classifier (0/ffffffffffff, -)
  -> [1]output;

  dht_out_clf[1]
  -> [2]output;

  input[2]
  -> [2]dht[2]
  -> [3]output;

}

elementclass DHT_Peek {
	
  //0: brn src und dst (dsr)   6: dsr-type (src_route)    
  // 163: dsr payload (dht)  163 = 16 (HOP_COUNT) * 8 + 35 
	input[0]
    -> dsr_src_clf :: Classifier(0/0303 6/04, -)
//    -> StripBRNHeader()
//    -> StripDSRHeader()
    -> dht_clf :: Classifier(163/02, -)
//    -> PushDSRHeader()
//    -> PushBRNHeader()
	  -> Print("CLICK:DHT_DSR: Packet fuer DHT",250)
	  -> [1]output;
    
  dsr_src_clf[1]
  	-> [0]output;
 
  dht_clf[1]
//    -> PushDSRHeader()
//    -> PushBRNHeader()
  	-> [0]output;
}     
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/*
 * inter-ap protocol configuration in click
 */

/* Parameter:
 * ==========
 * - ID                := node $identity
 * - LINKTABLE         := link table
 * - ASSOCLIST         := list of associated stations
 
 * =====================
 *  - input[0]        <- 802.11 frames from the queue to the interface ( q -> )
 *  - output[0]       -> 802.11 frames to the interface ( -> ToDevice)
 *
 *  - input[1]        <- BRN_IAPP packets (destinating, without further header)
 *                       (brn_clf[6] -> Strip(6) -> )
 *  - input[2]        <- BRN_IAPP packets (peeked, without further header)
 *  - input[3]        <- 802.3 frames which could not be forwarded 
 *                         (dsr[2] -> Strip(182) -> ) failure from dsr 
 *                         (FilterFailures[1] -> WifiDecap -> ) from dev no ack
 *  - input[4]        <- 802.11 infrastructure data with foreign BSSID
                            (filter_bssid[1] -> )
 *  - output[1]       -> 802.3 frames to be routed ( -> [0]dsr)
 *  - output[2]       -> ????
 *
 *  - output[3]       -> BRN_IAPP notify packets with further information
                         for other elements (Gateway needs to know about hand overs)
 */

elementclass IAPP {
  STALE $stale,
  ASSOCLIST $assoc_list,
  ASSOC_RESP $assoc_resp,
  |
  //SIG_ASSOC $sig_assoc |

  iapp_encap  :: BrnIappEncap();

  iapp_filter :: BrnIappRoamingFilter(ASSOCLIST $assoc_list);
  
  sta_tracker :: BrnIappStationTracker(
                  STALE $stale,
                  ASSOCLIST $assoc_list,
                  NOTIFYHDL notify_hdl,
                  DATAHDL data_hdl,
                  ASSOC_RESP $assoc_resp);
                  //SIG_ASSOC $sig_assoc);

  hello_hdl   :: BrnIappHelloHandler(
                  ASSOCLIST $assoc_list,
                  ENCAP iapp_encap);

  notify_hdl  :: BrnIappNotifyHandler(
                  RESEND_NOTIFY 100, 
                  NUM_RESEND 7, 
                  ASSOCLIST $assoc_list, 
                  ENCAP iapp_encap, 
                  STATRACK sta_tracker,
                  );

  route_hdl   :: BrnIappRouteUpdateHandler(
                  ASSOCLIST $assoc_list,
                  ENCAP iapp_encap,
                  HELLOHDL hello_hdl);
  
  data_hdl    :: BrnIappDataHandler(
                  ASSOCLIST $assoc_list, 
                  ENCAP iapp_encap, 
                  ROUTEHDL route_hdl);

  snoopy      :: BrnIappStationSnooper(
                  ASSOCLIST $assoc_list, 
                  STATRACK sta_tracker, 
                  HELLOHDL hello_hdl);

  all :: CompoundHandler("debug", "BrnIappEncap BrnIappRoamingFilter
    BrnIappStationTracker BrnIappHelloHandler BrnIappRouteUpdateHandler
    BrnIappDataHandler BrnIappStationSnooper", "2");

  optimize :: CompoundHandler("optimize", "BrnIappStationSnooper 
    BrnIappHelloHandler BrnIappDataHandler BrnIappStationTracker", "true");

  //----------------------------------------------------------------------------
  // Look into all packets from the queue and filter out those to roamed STAs.
  // If such a packet is found, it is duplicated and given to the iapp and
  // to the dsr error forwarder in order to generate a route errror, which
  // is send to the originator of the packet.
  
  elementclass ip_printer {  
    input[0]
    -> ethertype_clf :: Classifier(12/8086, 12/0800);
    
    ethertype_clf[0] // brn
    -> CheckIPHeader(OFFSET 58)
    //-> IPPrint("from_iapp_data_to_dsr0")
    -> [0]output;
  
    ethertype_clf[1] // ether
    -> CheckIPHeader(OFFSET 14)
    //-> IPPrint("from_iapp_data_to_dsr0")
    -> [0]output;
  }

  data2_hdl   :: BrnIappDataHandler(
                  ASSOCLIST $assoc_list, 
                  ENCAP iapp_encap, 
                  ROUTEHDL route_hdl);

  Idle()
    -> data2_hdl;

  input[0]
    -> iapp_filter
    -> [0]output;
  
  iapp_filter[1]
    -> WifiDecap()
    //-> Print("from_filter_to_iapp")
    -> [1]data2_hdl;
  
  data2_hdl[0]
    -> SetBrnTos(1)
    //-> Print("from_iapp_data2_to_dsr0")
    -> ip_printer // TODO remove
    -> [1]output;

  //----------------------------------------------------------------------------
  // Handle incoming IAPP packets
  
  input[1]
    //-> Print("from_input_to_iapp")
    -> iapp_clf :: Classifier(0/01, // notify
                              0/02, // reply
                              0/03, // data
                              0/04, // route update
                              0/05, // hello
                              - );
  
  iapp_clf[0] // notify
    -> [0]notify_hdl;

  iapp_clf[1] // reply
    -> [1]notify_hdl;

  iapp_clf[2] // data
    -> [0]data_hdl;

  iapp_clf[3] // route update
    -> [0]route_hdl;

  iapp_clf[4] // hello
    -> [0]hello_hdl;

  iapp_clf[5] // other
    -> Print("BOGUS --- invalid brn iapp type")
    -> Discard();

  //----------------------------------------------------------------------------
  // Handle iapp peeks
  
  input[2]
    //-> Print("from_peek_to_iapp")
    -> [0]sta_tracker;

  //----------------------------------------------------------------------------
  // Handle Ethernet frames which could not be forwarded (STA roamed?)

  input[3]
    //-> Print("from_failure_to_iapp")
    -> [1]data_hdl;

  //----------------------------------------------------------------------------
  // Handle Wifi with foreign BSSID 

  input[4]
    //-> PrintWifi("from_host_filter_to_iapp")
    //-> Print("from_host_filter_to_iapp")
    -> [0]snoopy;

  //----------------------------------------------------------------------------
  // Either IAPP packets encapsulated in BRN/Ethernet to be routet to other 
  // mesh nodes or packets for roamed STAs, which are sent to the new mesh node.
  
  notify_hdl[0]
  //-> Print("from_iapp_notify_to_dsr0")
  -> SetBrnTos(1)
  -> [1]output;

  notify_hdl[1]
  -> [3]output;

  data_hdl[0]
  //-> Print("from_iapp_data_to_dsr0")
    -> ip_printer // TODO remove
    -> [1]output;

  route_hdl[0]
  //-> Print("from_iapp_route_to_dsr0")
  -> SetBrnTos(1)
  -> [1]output;

  hello_hdl[0]
  //-> Print("from_iapp_hello_to_dsr0")
  -> [1]output;

  data2_hdl[1]
  -> [2]output;

  data_hdl[1]
  -> [2]output;
}

elementclass IAPP_Peek {

  input 
    -> dsr_src_clf :: Classifier(0/0303 6/04, -)
    -> StripBRNHeader()
    -> StripDSRHeader()
         -> iapp_peek :: Classifier(12/8086 14/0808, -)
         -> iapp_peek_tee :: Tee() // Duplicate because it is killed in iapp
         -> Strip(14) // strips an ethernet header
         -> StripBRNHeader()
         -> [1]output;
    
  dsr_src_clf[1]
       -> [0]output;
 
  iapp_peek[1]
    -> PushDSRHeader()
    -> PushBRNHeader()
    -> [0]output;
       
  iapp_peek_tee[1]
    -> PushDSRHeader()
    -> PushBRNHeader()
    -> [0]output;
}
/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA. 
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de 
 * or contact brn@informatik.hu-berlin.de. 
 */

/**
 *
 * Virtual LANs using 802.1Q
 *
 */

/**
 * Parameter:
 * ==========
 * - ASSOCLIST         := ASSOCLIST which stores stations
 * TODO
 *
 */

/** 
 * In- and Output ports:
 * =====================
 *  - input[0]        <- 802.3 frame to tag (from station)
 *  - input[1]        <- 802.1Q tagged frame to untag (to station)
 *  - input[2]        <- 802.3 frame to tag (from virtual station)
 *  - input[3]        <- 802.1Q tagged frame to untag (to virtual station)
 *  - input[4]        <- 802.3 BRN VLAN communication
 *  - input[5]        <- 802.1Q frame to decap (802.3 frame are passed through)
 *  - [0]output       -> 802.1Q tagged frame (from station)
 *  - [1]output       -> 802.3 frame (to station)
 *  - [2]output       -> 802.1Q tagged frame (from virtual station)
 *  - [3]output       -> 802.3 frame (to virtial station)
 *  - [4]output       -> 802.3 BRN VLAN communication
 *  - [5]output       -> 802.3 frame
 */

elementclass VLAN {
    
    /* empty elementclass
     * does nothing
     * used to disable VLAN
     */

    input[0]
    -> Null
    -> [0]output;

    input[1]
    -> Null
    -> [1]output;

    input[2]
    -> Null
    -> [2]output;

    input[3]
    -> Null
    -> [3]output;

    input[4]
    -> Null
    -> [4]output;

    input[5]
    -> Null
    -> [5]output;

||
    ETHERADDRESS $ether, ASSOCLIST $assoc_list, SSID $ssid |

    brn_vlans :: BRNVLAN($ssid);

    /*
     * For stations
     */
    input[0]
    //-> Print("802.3 frame from station to tag in")
    -> VLANEncap()
    -> BRNVLANTag(ETHERADDRESS $ether,ASSOCLIST $assoc_list, BRNVLAN brn_vlans)
    //-> Print("802.1Q tagged frame from station out")
    -> [0]output;
    
    input[1]
    //-> Print("802.1Q tagged frame from station in")
    -> check :: BRNCheckVLAN(ETHERADDRESS $ether, ASSOCLIST $assoc_list, BRNVLAN brn_vlans)
    -> VLANDecap()
    //-> Print("802.3 frame from station out")
    -> [1]output;

    check[1]
    //-> Print("PACKET UNABLE TO SEND TO VLAN - FIX ME")
    -> Discard;

    
    /*
     * For virtual station
     */
    input[2]
    //-> Print("802.3 frame from virtual station to tag in")
    -> VLANEncap()
    -> VLANTag(0) // TODO should be configurable via handler
    //-> Print("802.1Q tagged frame from virtual station out")
    -> [2]output;

    input[3]
    //-> Print("802.1Q tagged frame from virtual station in")
    -> CheckVLAN(0) // TODO should be configurable via handler; Setting both CheckVLAN and VLANTag would be best to avoid misconfiguration
    -> VLANDecap()
    //-> Print("802.3 frame from virtual station out")
    -> [3]output;

    // TODO CompoundHandler should work on instances (at the moment on classes)
    // and is write only
    //vlan_virtual_station :: CompoundHandler("vlanid", "VLANTag CheckVLAN", "0"); // set vlanid 0 as default

    // reading may be performed either on VLANTag or CheckVLAN


    input[4]
    //-> Print("VLAN Distribution System 802.3")
    -> brn_vlans
    //-> Print("VLAN Distribution System 802.3")
    -> [4]output;


    input[5]
    -> VLANDecap()
    -> [5]output;
    
    all :: CompoundHandler("debug", "BRNVLAN BRNCheckVLAN BRNVLANTag", "2");
}

/**
 * Usage:
 * ======
 *
 * TODO
 *
 */

/**
 * Examples:
 * =========
   
   TODO

   AddressInfo(my_wifi_dev ath0:eth);
   
   FromDevice(ath0)
   -> Prism2Decap()
   -> ExtraDecap()
   -> frame_clf :: Classifier(0/00%0f)    // 802.11 management frames only
//   -> HostWifiFilter(DROP_OTHER TRUE, ETHER my_wifi_dev)
   -> PrintWifi(Before)
   -> ap :: AccessPoint(INTERFACE ath0, SSID MyWifiNetwork, CHANNEL 1, 
   BEACON_INTERVAL 100, RATES DEFAULT 2 4 11 12 18 22)
   -> PrintWifi(After)
   -> Queue()
   -> ToDevice(ath0);
   
 */

//this is only to get an NodeIdentity element for the Gateway
//rc :: BrnRouteCache(ACTIVE true, DROP /* 1/20 = 5% */ 0, SLICE /* 100ms */ 0, TTL /* 4*100ms */4);
//lt :: BrnLinkTable(id, rc, STALE 500, SIMULATE false, CONSTMETRIC 1);
//id :: NodeIdentity(eth0, eth0, eth0, lt);

/*
AddressInfo(my_wlan eth0:eth)

al :: AssocList(id);


vlan :: VLAN(ASSOCLIST al)


RatedSource(\<FFFF>, 1, -1)
-> IPEncap(6, 192.168.0.1, 192.168.0.2) // TCP Packet
-> EtherEncap(0x0800, aa:aa:aa:aa:aa:aa, bb:bb:bb:bb:bb:bb)
// frames from stations
-> [0]vlan[0]
-> PrintVLAN()
// frames to stations
-> [1]vlan[1]
-> Print("After")
//-> PrintVLAN
-> Discard;

Idle()
-> [2]vlan[2]
-> Discard;


PokeHandlers(
            read vlan/brn_vlans.get_vlans,
            write vlan/brn_vlans.add_vlan FOO,
            write vlan/brn_vlans.add_vlan BAR,
            wait 2,
            read vlan/brn_vlans.get_vlans,
            wait 2,
            write vlan/brn_vlans.remove_vlan BAR,
            write vlan/brn_vlans.remove_vlan BAR2,
            wait 2,
            read vlan/brn_vlans.get_vlans,
            //write dht.debug 4,
             //wait 5,
             //read c.count,
             //loop,
            //read gateway.metric,
             //wait 5,
             //read ping.rtt_avg,
             //read gateway.known_gateways,
             //loop
             );



ControlSocket(TCP, 7777);
*/
  
  // network addresses
  //AddressInfo(my_wlan $eth_dev:eth);
  AddressInfo(my_wlan $wifi_dev:eth);
  AddressInfo(my_eth $eth_dev:eth);

  AddressInfo(service_ip $service_ip); 
	// the mac addresses 10:00:00:XX:XX:XX are private (according to wireshark)
  AddressInfo(service_mac 10:00:00:aa:aa:aa); 

  wifi_device :: WifiDevice($wifi_dev);

  eth_device :: EthDevice($eth_dev);

  route_cache :: BrnRouteCache(
    ACTIVE false, 
    DROP /* 1/20 = 5% */ 0, 
    SLICE /* 100ms */ 0, 
    TTL /* 4*100ms */4);
    
  link_table :: BrnLinkTable(
    route_cache, 
    STALE 500,  
    SIMULATE false, 
    CONSTMETRIC 1, 
    MIN_LINK_METRIC_IN_ROUTE 300);
    
  id :: NodeIdentity(
    $wifi_dev, 
    $eth_dev, 
    $eth_dev, 
    link_table);
  
  assoc_list :: AssocList(id);

  services :: Services(WIFI_MAC my_wlan, PREFIX $addr_prefix, LINKTABLE link_table, SERVICE_MAC service_mac, SERVICE_IP service_ip, LOCAL_DEVNAME $local_dev, LOCAL_MAC my_wlan)
  
  brn_iapp :: IAPP(
    STALE 100,
    ASSOCLIST assoc_list,
    ASSOC_RESP access_point/assoc_resp,
    );

  //vlan :: VLAN(ETHERADDRESS my_wlan, ASSOCLIST assoc_list, SSID $ssid);
  // disable vlan
  // don't forget to change ap :: AccessPoint too
  vlan :: VLAN();

  access_point :: AccessPoint(
    INTERFACE $wifi_dev, 
    SSID $ssid, 
    CHANNEL $channel, 
    BEACON_INTERVAL 1000, 
    RATES DEFAULT 2 4 11 22 12 18 24 36 48 72 96 108,
    //RATES DEFAULT 2 4 11 22, 
    IAPP brn_iapp/sta_tracker);//,
    //BRNVLAN vlan/brn_vlans);
  
  dht :: DHT(
    WIFI_DEV $wifi_dev, 
    LINK_STAT link_stat,
		PREFIX $addr_prefix
    );
  
  link_stat :: BRNLinkStat(
    ETHTYPE 0x0a04, 
     NODEIDENTITY id, 
     PERIOD 1000,
     TAU 30000,
     //PROBES "2 60 12 60 2 1400 4 1400 11 1400 22 1400 12 1400 18 1400 24 1400 36 1400 48 1400 72 1400 96 1400",
     //ETT ett_metric,
     ETX etx_metric,
     PROBES "22 1000",
     RT access_point/rates,
     DHT dht/dht
    );

  dsr :: DSR( 
    NODE_IDENTITY id, 
    ASSOC_STATIONS assoc_list, 
    IAPP brn_iapp/sta_tracker);

  // link metric
  etx_metric :: BRNETXMetric(LT link_table);



  ds :: SetSourceAndOutputForDevice(ASSOCLIST assoc_list);
  
  
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // packet that come into click
  
  // Handling frames from wifi device
  wifi_device[0]
  -> host_filter :: HostWifiFilter(my_wlan, access_point/winfo, MODE 2)
  // NEW classifier: WifiTypeClass.
  //                 - management frames
  //                 - control frames (discarded)
  //                 - data frames
  -> wifi_type_clf :: Classifier(0/00%0f,
                                 0/04%0f,
                                 0/08%ff,
                                 -)
  // -> Print(" Management  ", NBYTES 80)
  -> access_point;


  
  // Handling frames from ethernet device
  eth_device[0]
  -> SetEtherAnno
  -> ethertype_clf :: Classifier(12/8086, -);
  
  // Handling frames from local (node)
  services
  -> [2]vlan[2]
  -> service_filter :: HostEtherFilter(service_mac, DROP_OWN true);

  brn_iapp[3] -> [4]services;


  Idle
  -> [4]vlan[4]
  -> Discard;


  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  
  
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // packets that leave click
  
  arp_tab :: ARPTable();
  
  prio_sched_wifi :: PrioSched();
  
  wifi_out_queue :: Null
  -> brn_tos_clf :: BrnTosClassifier()
  -> be_q :: NotifierQueue(50)
  -> [1]prio_sched_wifi
  -> [0]brn_iapp[0]
  -> [0]wifi_device;
  
  brn_tos_clf[1]
  -> prio_q :: NotifierQueue(50)
  -> [0]prio_sched_wifi;
  
  // to stations or mesh neighbors (wifi)
  to_mesh_neighbors :: Null
  -> WifiEncap(0x00, WIRELESS_INFO access_point/winfo) // sollte das WDS Paket erzeugen
  -> SetTXRate(22, TRIES 10)
  -> wifi_out_queue;
  
  to_stations :: Null
  -> WifiEncap(0x02, WIRELESS_INFO access_point/winfo) // sollte das station Paket erzeugen
  -> SetTXRate(22, TRIES 10)
  -> wifi_out_queue;
  
  // to stations or mesh neighbors (ethernet)
  eth_out_queue :: Null
  -> NotifierQueue(50)
  -> [0]eth_device;
  
  // to this mesh node
  local_out_queue :: Null
  -> [3]vlan[3]
  -> [0]services;

  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  
  
  // Handling mgm frames from ap
  access_point
  -> SetTXRate(2, TRIES 1) // ap beacons send at constant bitrate
  -> wifi_out_queue;
  
  // Handling 802.11 control frames
  wifi_type_clf[1]
  -> Discard;
  
  // Clean all unknown incomming wifi packets
  wifi_type_clf[3]
  -> Discard;
 
  // Handling data frames from wifi device, check direction
  wifi_type_clf[2]
  -> wifi_data_clf :: Classifier(1/00%03,
                                 1/01%03,
                                 1/02%03,
                                 -)
  -> WifiDecap(STRICT true)
  -> ethertype_clf;

  wifi_data_clf[1]
  -> WifiDecap(STRICT true)
  -> [0]vlan[0] // tag station's frames
  -> disassociator :: Disassociator(ASSOC_RESP access_point/assoc_resp, 
                                    STA_TRACKER brn_iapp/sta_tracker)
  -> ethertype_clf;

  // Ignore frames from other access points to their assoc. stations
  wifi_data_clf[2]
  -> Discard;

  wifi_data_clf[3]
  -> Discard;

		
  ethertype_clf[0] // BRN protocol
  -> EtherDecap()
  -> CheckBrnHeader()
  -> nb_lst :: NeighborList() // collect information about brn mesh neighbors from
  -> brn_clf :: Classifier(0/01, //BrnSDP
                           0/02, //BrnTFTP
                           0/03, //BrnDSR
                           0/04, //BrnBcast
                           0/06, //LinkProbe
                           0/07, //DHT
                           0/08, //IAPP
                           0/09, //gateway
                           -     //other
                          );
  
  brn_clf[0] // sdp 
  -> PushMACHeader()
  -> Discard;
  //-> ToHostSniffers;
 
  brn_clf[1] // tftp
  -> Print("Got BRN TFTP")
  -> PushMACHeader()
  -> Discard;
  //-> ToHostSniffers;
  
  // handle DSR packets
  // with dht peek
  brn_clf[2]
  -> dht_peek :: DHT_Peek
  -> iapp_peek :: IAPP_Peek
  -> [1]dsr;
   
  dht_peek[1]
  -> [2]dht;
   
  iapp_peek[1]
  -> [2]brn_iapp;

  
  brn_clf[3] // bcast
  -> Discard;
  
  brn_clf[4] //linkprobe
  -> SetTimestamp()
  -> link_stat
  -> SetTimestamp()
  -> EtherEncap(0x8086, my_wlan, ff:ff:ff:ff:ff:ff)
  -> to_mesh_neighbors;
  
  
  // handle DHT packets
  brn_clf[5]
  -> [1]dht;
  
  // handle IAPP packets
  brn_clf[6] 
  -> StripBRNHeader()
  -> [1]brn_iapp;

  brn_clf[7] //other
  -> [3]services;

  brn_clf[8] //other
  -> Print("BOGUS --- not existing brn type ... discard")
  -> Discard(); //[0]dsr;
  
  
  ethertype_clf[1] // no BRN protocol
  -> service_filter
  -> [5]vlan[5] // services can be accessed by all VLANs
  -> [1]services[1]
  -> ds;

  dht[0]
  -> [2]services[2]
  -> [0]dht;

  services[3]
  -> service_filter;

  service_filter[1]
  -> hfilter :: HostDualFilter(ADDR1 my_wlan, ADDR2 my_eth, DROP_OWN true)
  -> local_out_queue;

  hfilter[1]
  -> [0]dsr;

  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // dsr outputs

  elementclass BrnInBrnClassifier
  {
    input[0]
    -> brn_in_brn_clf :: Classifier(12/8086 14/03, 12/8086, -); // handle brn-in-brn
  
    brn_in_brn_clf[0] // brn-in-brn with dsr
    -> Discard();
    
    brn_in_brn_clf[1] // brn-in-brn without dsr
    -> [1]output; 
    
    brn_in_brn_clf[2] // other, send to output 0
    -> [0]output;
  }  

  
  dsr[0]
  -> brn_in_brn_clf :: BrnInBrnClassifier // filter brn-in-brn
  -> ds;

  brn_in_brn_clf[1]
  -> EtherDecap()
  -> brn_clf; 
  
  dsr[1]
  -> dsr_ds :: BRNDS(id, nb_lst); // it seems difficult to get rid of the 
  // BRNDNS, since it looks inside the packets to adjust them. But it is more a 
  // "DSR distribution"
  
  dsr[2] 
  -> StripBRNHeader()
  -> StripDSRHeader()
  -> [3]brn_iapp;
  
  dsr_ds[0]
  -> to_mesh_neighbors;
  
  dsr_ds[1]
  -> eth_out_queue;
  
  dsr_ds[2]
  -> Discard;
  
  dsr_ds[3]
  -> StripBRNHeader()
  -> StripDSRHeader()
  -> [3]brn_iapp;

  
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // dht outputs
  
  dht[1]
  -> to_mesh_neighbors;
  
  dht[2]
  ->[0]dsr;
  
  dht[3]
  -> [1]dsr;
    
  
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // iapp outputs
  

  host_filter[1]
  -> [4]brn_iapp;

  brn_iapp[1]
  -> [5]services[4]
  -> [0]dsr
  
  brn_iapp[2]
  -> [2]dsr

  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
  // The distribution system
  // sets the source address and multiplies broadcasts to every device 
  // (MultiDeviceBroadcast)
  
  ds[0]
  -> to_sta :: ToStations(assoc_list)
  -> [1]vlan[1] // check frame to station
  -> to_stations;

  to_sta[1]
  -> dst_clf :: Classifier(12/8086, -) // ethernet frames with type 0x8086 are sent to mesh neighbors
  -> to_mesh :: ToMeshNeighbors(id)
  -> to_mesh_neighbors;

  dst_clf[1]
  -> Print("ERROR - I dropped an ethernet frame for a station") // Dropped a frame for a station, station must be unassociated
  -> Discard;
  
  
  ds[1]
  -> eth_out_queue;
  
  
  ds[2]
  -> local_out_queue;


  //////////////////////////////////////////////////////////////////////////////
  
  
  // What to do with tx annotated transmissions?

  wifi_device[1] //   
  -> failures :: FilterFailures
  -> Discard;
  
  failures[1]
  -> WifiDupeFilter
  -> mgm :: Classifier(0/00%0f,   // management
                       0/08%0f 1/02%03,  // type data, subtype data, FromDS
                       -)
  -> Discard;
  
  mgm[1] // type data, subtype data, FromDS = packets to assoc. stations
  -> WifiDecap(STRICT true)
  -> [3]brn_iapp;

  mgm[2]                     //other frames
  -> WifiDecap(STRICT true)
  -> Classifier(12/8086)   //handle only brn protocol
  -> EtherDecap()
  -> [2]dsr;

} /* End of elementclass Meshnode */


meshNode :: Meshnode( SSID "BerlinRoofNet", WIFI_DEV ath0, WIFI_CHANNEL 10,
                      ETH_DEV eth0, LOCAL_DEV local,
                      PREFIX 0.0.0.0/22, SERVICE_IP 0.0.0.1);

//todump_active :: CompoundHandler("active", "ToDump");

ControlSocket("TCP", 7777);

Script(
  write meshNode/ds.debug 2,
  write meshNode/to_sta.debug 2,
  write meshNode/to_mesh.debug 2,
  write meshNode/assoc_list.debug 2,
  write meshNode/disassociator.debug 2,
  write meshNode/host_filter.debug 2,

  // debug level of vlan
  //write meshNode/vlan/all.debug 2,

  // debug level of routing layer
  write meshNode/access_point/all.debug 2,

  // debug level of routing layer
  write meshNode/dsr/all.debug 2,
  write meshNode/dsr/querier.debug 2,

  // debug level of inter accesspoint protocol
  write meshNode/brn_iapp/all.debug 2,
  write meshNode/brn_iapp/sta_tracker.debug 2,
  write meshNode/brn_iapp/snoopy.debug 2,

  write meshNode/services/dhcp/dhcp_server.debug 2,
  write meshNode/services/arp/arp.debug 2,
  write meshNode/dht/dht.debug 2,

  // debug level of gateway
  write meshNode/services/gw/all.debug 2,
  write meshNode/services/gw/gateway.debug 2,
);
