







elementclass ToDumpWifi {
 $file_name |

||
 DUMP $dump_element |

 input -> output;
}


elementclass ToDumpEther {
 $file_name |

||
 DUMP $dump_element |

 input -> output;
}

elementclass HostDualFilter { ADDR1 $addr1, ADDR2 $addr2, __REST__ $rest |
 input[0] -> hfilter1 :: HostEtherFilter($addr1, $rest) -> [0]output;
 hfilter1[1] -> hfilter2 :: HostEtherFilter($addr2, $rest) -> [0]output;
 hfilter2[1] -> [1]output;
}
 




_simDeviceMaster :: SimDeviceMaster(TCP, 7777, HOTSWAP true);

 
elementclass DHCPClient{
 $addr, REQ_ADDR $req_addr, START $start_s |

 client :: DHCPClient($addr, REQ_ADDR $req_addr, START $start_s);

 input
 -> CheckIPHeader(0)
 -> CheckUDPHeader()
 -> CheckDHCPMsg()
 -> [0]client;

 client[0]
 -> UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
 -> [0]output;

 queue::DHCPOfferMsgQueue(client.client_ip_read)
 -> [1]client; 

 client[1]
 -> udp_encap :: UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67)
 -> DHCPUnicastEncap(client.client_ip_read, client.server_ip_read)
 -> [1]output

 client[2] -> queue;
 client[3] -> Discard;
}


elementclass FromHost {
 $dev_name, $ip, ETHER $addr |

 from_sim_device :: FromSimDevice($dev_name, 4096, TUNNEL true);

 from_sim_device[0]
 -> CheckIPHeader(0)
 -> ip_filter :: IPClassifier(src host $ip, -)
 -> arp :: ARPQuerier($ip, $addr)
 -> SetTimestamp()
 -> [0]output;

 ip_filter[1]
 -> Discard;

 from_sim_device[1]
 -> [1]arp;
||
 $dev_name, ETHER $addr |

 from_sim_device :: FromSimDevice($dev_name, 4096, TUNNEL true);

 AddressInfo(req_addr 0.0.0.2)
 dhcp_client :: DHCPClient($addr, REQ_ADDR req_addr:ip, START 30);

 from_sim_device[0]
 -> CheckIPHeader(0)
 -> ip_filter :: IPClassifier(src host req_addr:ip, -)
 -> arp :: ARPQuerier(req_addr:ip, $addr)
 -> SetTimestamp()
 -> [0]output;

 ip_filter[1]
 -> Discard;

 dhcp_output :: Null
 -> EtherEncap(0x0800, $addr, FF:FF:FF:FF:FF:FF)
 -> SetTimestamp()
 -> [0]output;

 dhcp_client[0]
 -> dhcp_output;

 dhcp_client[1]
 -> dhcp_output;

 
 
 from_sim_device[1]
 -> ethertype_clf :: Classifier(12/0806, 12/0800, -);

 ethertype_clf[0]
 -> [1]arp;

 ethertype_clf[1]
 -> EtherDecap()
 -> CheckIPHeader(0)
 -> dhcp_client;

 bogus :: Null
 -> Print("ERROR: got unexpected packet (waiting for ARP and DHCP)")
 -> Discard;

 ethertype_clf[2]
 -> bogus;
}


elementclass ToHost { $dev_name |

 to_sim_device :: ToSimDevice($dev_name, ENCAP ETHER, TUNNEL true);

 
 input[0]
 -> ethertype_clf :: Classifier(12/0806, 12/0800, -)
 -> [1]to_sim_device;

 ethertype_clf[1]
 -> CheckIPHeader(14)
 -> ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -)
 -> [1]to_sim_device;

 
 ethertype_clf[2]
 -> [0]to_sim_device;

 ip_classifier[1]
 -> [0]to_sim_device;
}




elementclass WifiDevice {
 $dev_name |

 dump_wifi :: ToDumpWifi($dev_name);

 FromDevice($dev_name) 
 -> AthdescDecap() 
 -> ToDumpWifi(DUMP dump_wifi)
 -> filter_phy :: FilterPhyErr()
 -> filter :: FilterTX()
 -> WifiDupeFilter()
 -> [0]output;
 
 filter_phy[1]
 -> Discard;

 filter[1]
 -> [1]output;

 input[0]
 -> ToDumpWifi(DUMP dump_wifi)
 -> AthdescEncap() 
 -> ToDevice($dev_name);
}



elementclass EthDevice {
 $dev_name |
 
 dump_ether :: ToDumpEther($dev_name);

 FromDevice($dev_name)
 -> ToDumpEther(DUMP dump_ether)
 -> [0]output;

 input[0]
 -> ToDumpEther(DUMP dump_ether)
 -> ToDevice($dev_name);
}


elementclass VirtualDevice { 
 $dev_name, ETHER $addr |
 
 dump_ether :: ToDumpEther($dev_name);

 from_host :: FromHost($dev_name, ETHER $addr)
 -> SetEtherAnno()
 -> ToDumpEther(DUMP dump_ether)
 -> [0]output;
 
 input[0]
 -> ToDumpEther(DUMP dump_ether)
 -> SetPacketType(HOST)
 -> to_host :: ToHost($dev_name);
|| 
 $dev_name, $ip, ETHER $addr |

 dump_ether :: ToDumpEther($dev_name);

  from_host :: FromHost($dev_name, $ip, ETHER $addr)
 -> SetEtherAnno()
 -> ToDumpEther(DUMP dump_ether)
 -> [0]output;
 
 input[0]
 -> ToDumpEther(DUMP dump_ether)
    -> SetPacketType(HOST)
 -> to_host :: ToHost($dev_name)

}






elementclass Meshnode {
 SSID $ssid, WIFI_DEV $wifi_dev, WIFI_CHANNEL $channel, 
 ETH_DEV $eth_dev, LOCAL_DEV $local_dev, 
 PREFIX $addr_prefix, SERVICE_IP $service_ip |
 
 
 








elementclass AccessPoint {
 INTERFACE $device, SSID $ssid, CHANNEL $channel, 
 BEACON_INTERVAL $beacon_interval, RATES $rates, IAPP $iapp |

 AddressInfo(ether_address $device:eth);
 winfo :: WirelessInfo(SSID $ssid, BSSID ether_address, CHANNEL $channel, 
 INTERVAL $beacon_interval);
 rates :: AvailableRates($rates);

 assoc_resp :: BRNAssocResponder(DEBUG 0, WIRELESS_INFO winfo, RT rates, 
    IAPP $iapp);

 input[0]
 -> mgt_cl :: Classifier(
 0/00%f0, 
 0/10%f0, 
 0/20%f0, 
 0/30%f0, 
 0/40%f0, 
 0/50%f0, 
 0/80%f0, 
 0/90%f0, 
 0/a0%f0, 
 0/b0%f0, 
 0/c0%f0, 
 - 
 );

 mgt_cl[0] 
 
 -> assoc_resp;
 
 mgt_cl[1] 
 
 -> assoc_resp;

 mgt_cl[2] 
 
 -> assoc_resp;

 mgt_cl[3] 
 
 -> assoc_resp;

 mgt_cl[4] 
 
 -> beacon_source :: BeaconSource(WIRELESS_INFO winfo, RT rates, DEBUG false)
 
 
 -> [0]output;

 mgt_cl[5] 
 -> Discard;

 mgt_cl[6] 
 
 
 -> Discard; 

 mgt_cl[7] 
 -> Discard;

 mgt_cl[8] 
 
 -> assoc_resp;

 mgt_cl[9] 
 
 
 -> OpenAuthResponder(WIRELESS_INFO winfo)
 
 
 -> [0]output;
 
 mgt_cl[10] 
 -> Discard;

 mgt_cl[11] 
 -> Discard;

 
 assoc_resp
 
 -> [0]output;

 all :: CompoundHandler("debug", "BRNAssocResponder",
  "2");
||
 INTERFACE $device, SSID $ssid, CHANNEL $channel, 
 BEACON_INTERVAL $beacon_interval, RATES $rates, IAPP $iapp, BRNVLAN $vlan |

 AddressInfo(ether_address $device:eth);
 winfo :: WirelessInfo(SSID $ssid, BSSID ether_address, CHANNEL $channel, 
 INTERVAL $beacon_interval);
 rates :: AvailableRates($rates);

 assoc_resp :: BRNAssocResponder(DEBUG 0, WIRELESS_INFO winfo, RT rates, 
    IAPP $iapp, BRNVLAN $vlan);

 input[0]
 -> mgt_cl :: Classifier(
 0/00%f0, 
 0/10%f0, 
 0/20%f0, 
 0/30%f0, 
 0/40%f0, 
 0/50%f0, 
 0/80%f0, 
 0/90%f0, 
 0/a0%f0, 
 0/b0%f0, 
 0/c0%f0, 
 - 
 );

 mgt_cl[0] 
 
 -> assoc_resp;
 
 mgt_cl[1] 
 
 -> assoc_resp;

 mgt_cl[2] 
 
 -> assoc_resp;

 mgt_cl[3] 
 
 -> assoc_resp;

 mgt_cl[4] 
 
 -> beacon_source :: BeaconSource(WIRELESS_INFO winfo, RT rates, DEBUG false, BRNVLAN $vlan)
 
 
 -> [0]output;

 mgt_cl[5] 
 -> Discard;

 mgt_cl[6] 
 
 
 -> Discard; 

 mgt_cl[7] 
 -> Discard;

 mgt_cl[8] 
 
 -> assoc_resp;

 mgt_cl[9] 
 
 
 -> OpenAuthResponder(WIRELESS_INFO winfo)
 
 
 -> [0]output;
 
 mgt_cl[10] 
 -> Discard;

 mgt_cl[11] 
 -> Discard;

 
 assoc_resp
 
 -> [0]output;

 all :: CompoundHandler("debug", "BRNAssocResponder",
  "2");
}













elementclass DSR {
NODE_IDENTITY $id, ASSOC_STATIONS $assoc_stations, IAPP $iapp |

 
 brn_encap :: BRNEncap();
 dsr_decap :: DSRDecap($id);
 dsr_encap :: DSREncap($id);
 nb :: DstClassifier($id, $assoc_stations);
 querier :: RouteQuerier($id, dsr_encap, brn_encap, dsr_decap, $iapp);
 req_forwarder :: RequestForwarder($id, dsr_decap, dsr_encap, brn_encap, querier, $assoc_stations, 300, $iapp);
 rep_forwarder :: ReplyForwarder($id, dsr_decap, querier, $assoc_stations, dsr_encap);
 src_forwarder :: SrcForwarder($id, $assoc_stations, dsr_encap, dsr_decap);
 err_forwarder :: ErrorForwarder($id, $assoc_stations, dsr_encap, dsr_decap, querier, brn_encap);

 
 
 
 input[0]
 -> clf_bcast :: Classifier(0/ffffffffffff, -); 

 clf_bcast[0]
 -> Discard;

 clf_bcast[1]
 -> nb;

 nb[0] 
 -> [0]output;

 nb[1] 
 -> [0]output;

 nb[2] 
 -> SetTimestamp()
 
 -> querier;

 querier[0]
 -> SetTimestamp()
 
 
 -> [1]output; 
 
 querier[1] 
 -> SetTimestamp()
 
 -> [0]src_forwarder; 

 src_forwarder[0]
 
 -> [1]output;

 src_forwarder[1]
 -> [0]output;

 src_forwarder[2]
 
 -> tee_to_err_fwd :: Tee()
 
 -> [2]output;

 tee_to_err_fwd[1]
 -> [0]err_forwarder;

 
 
 
 input[1]
 
 
 
 
 
 
 
 -> dsrclf :: Classifier(6/01, 
 6/02, 
 6/03, 
 6/04, 
 );

 dsrclf[0]
 
 
 -> req_forwarder[0]
 
 
 -> [1]output;

 req_forwarder[1]
 -> [0]rep_forwarder
 -> SetTimestamp()
 
 
 -> [1]output;

 dsrclf[1]
 
 
 -> [1]rep_forwarder;

 dsrclf[2]
 
 
 -> [1]err_forwarder
 
 -> [1]output;

 dsrclf[3]
 
 
 
 -> [1]src_forwarder;

 
 
 
 input[2]
 
 
 -> [0]err_forwarder;


 all :: CompoundHandler("debug", "BRNEncap DSRDecap DSREncap DstClassifier
  RouteQuerier RequestForwarder ReplyForwarder SrcForwarder ErrorForwarder",
  "2");
}

 











elementclass Services {
 WIFI_MAC $wifi_mac,
 PREFIX $addr_prefix,
 LINKTABLE $link_table,
 SERVICE_MAC $service_mac,
 SERVICE_IP $service_ip,
 LOCAL_DEVNAME $local_dev,
 LOCAL_MAC $local_mac |









elementclass DHCP {
  $addr_prefix, SERVICE_MAC $service_mac, SERVICE_IP $service_ip |


 input[0]
 -> EtherDecap()
 -> Strip(28) 
 -> dhcp_server :: DHCPServer(my_wlan, $addr_prefix, $service_ip, $service_ip, 
 141.20.20.50 ,"dhcp.berlinroofnet.de","berlinroofnet.de") 
 -> UDPIPEncap($service_ip, 67, 255.255.255.255, 68)
 -> EtherEncap(0x0800, $service_mac, ff:ff:ff:ff:ff:ff) 
 -> [0]output;

 input[1]
 -> [1]dhcp_server[1]
 -> [1]output;

}









elementclass ARP {
 SERVICE_IP $service_ip, SERVICE_MAC $service_mac, PREFIX $addr_prefix |

 input[0]
 -> arp :: Arp($service_ip, $service_mac, PREFIX $addr_prefix)
 -> [0]output;

 input[1]
 -> [1]arp[1]
 -> [1]output;

}









elementclass Gateway {
 ETHER_ADDR $my_wlan,
 LINKTABLE $lt,
 UPDATE_GATEWAYS_INTERVAL $up_gws,
 UPDATE_DHT_INTERVAL $up_gw,
 PREFIX $addr_prefix,
 SERVICE_IP $service_ip,
 |

 
 mac_ip :: ARPTable();
 table :: ARPTable();
 clients :: StoreIPEthernet(mac_ip)
 setgwflow :: BRNSetGatewayOnFlow(gateway, flows, $lt, mac_ip, buffer, $addr_prefix); 
 buffer :: BRNPacketBuffer(setgwflow, 50);

 
 
 
 input[4]
 
 -> gateway :: BRNGateway($my_wlan, setgwflow, UPDATE_GATEWAYS_INTERVAL $up_gws, UPDATE_DHT_INTERVAL $up_gw)
 
 ->[4]output;

 
 
 
 icmp_error2client :: Null
 -> StoreIPEthernet(table)
 -> EtherDecap()
 -> udp :: IPClassifier(udp, -)
 
 -> ICMPError($service_ip, unreachable, port)
 -> resolve :: ResolveEthernet($my_wlan, table)
 -> paint :: CheckPaint(0)
 
 -> [0]output;

 udp[1]
 
 -> ICMPError($service_ip, unreachable, host)
 -> resolve;

 
 paint[1]
 -> paint2 :: CheckPaint(1)
 -> encap :: BRNGatewayEncap(gateway);

 paint2[1]
 -> Print("BOGUS - Should never happen")
 -> IPPrint()
 -> Discard;


 
 
 
 input[0]
 -> from_clients :: IPClassifier(udp && dst port 1194, tcp or udp, -) 
 -> setgw :: BRNSetGateway(gateway, $lt) 
 -> [1]output;

 from_clients[2] 
 -> setgw; 

 
 setgw[1]
 
 
 -> Paint(0) 
 -> icmp_error2client;


 from_clients[1] 
 
 -> flows :: AggregateIPFlows(TCP_TIMEOUT 60, TCP_DONE_TIMEOUT 10, UDP_TIMEOUT 60, ICMP false)
 -> direction :: IPClassifier(src $addr_prefix, -) 
 -> clients
 -> buffer
 -> setgwflow
 -> [1]output;
  
 flows[1]
 -> Print("BOGUS - Should never happen")
 -> IPPrint()
 -> Discard;

 
 setgwflow[1]
 -> Print("No gateway known")
 
 -> Paint(0) 
 -> icmp_error2client;


 
 
 
 input[1]
 -> decap :: BRNGatewayDecap(gateway)
 
 -> CheckIPHeader(14)
 -> to_clients :: IPClassifier(udp && src port 1194, tcp or udp or icmp type unreachable, -)
 -> [0]output;

 
 to_clients[1]
 
 -> flows;

 
 direction[1]
 
 -> [0]output;

 to_clients[2]
 -> [0]output;


 
 
 
 input[2]
 
 -> before_local_gw :: IPClassifier(udp && src port 1194, tcp or udp, -)
 
 -> [1]gws :: BRNGatewaySupervisor(gateway, $lt);

 before_local_gw[2]
 -> [1]gws;

 before_local_gw[1]
 -> [0]gws;

 
 gws
 
 
 -> [2]output;
 
 
 
 
 input[3]
 
 -> encap
 
 -> [3]output;

 
 
 
 
 
 gws[1]
 
 -> from_clients;

 
 gws[2]
 
 
 -> Paint(1) 
 -> icmp_error2client;


 
 
 
 input[5]
 -> [1]setgwflow;
 input[6]
 -> [2]setgwflow[2]
 -> [5]output;
 

 all :: CompoundHandler("debug",
 "BRNGatewayEncap BRNGatewayDecap
 BRNGatewaySupervisor BRNSetGatewayOnFlow
 BRNGateway BRNSetGateway BRNPacketBuffer",
 "2");
}

 service_device :: VirtualDevice(serv, $service_ip, ETHER $service_mac);
 local_device :: VirtualDevice($local_dev, ETHER $local_mac);
 gw :: Gateway(ETHER_ADDR $wifi_mac, LINKTABLE $link_table, 
              UPDATE_GATEWAYS_INTERVAL 60, UPDATE_DHT_INTERVAL 50, 
              PREFIX $addr_prefix, SERVICE_IP $service_ip);

 input[4]
 -> [5]gw;
 
 input[5]
 -> [6]gw[5]
 -> [4]output;

 local_device[0]
 -> from_local_clf :: Classifier(12/0800, -)
 -> CheckIPHeader(14)
 -> from_local_ip ::IPClassifier(src net $addr_prefix or dst host 255.255.255.255, -)
 
 
 
 -> [0]output;

 from_local_clf[1]
 -> [0]output;

 from_local_ip[1]
 
 
 
 -> [3]gw[3]
 
 -> [0]output;

 input[0]
 -> local_clf :: Classifier(12/0800, -)
 -> CheckIPHeader(14)
 -> local_ip ::IPClassifier(dst net $addr_prefix or dst host 255.255.255.255, -)
 
 -> [0]local_device;


 local_ip[1]
 
 
 -> [2]gw[2] 
 -> [0]local_device;

 
 local_clf[1]
 -> [0]local_device;


 

 input[1]
 
 -> service_ether_clf :: Classifier(
 12/0800,
 12/0806,
 -
 );

 service_ether_clf[0]
 
 -> CheckIPHeader(14)
 -> service_ip_clf :: IPClassifier(
 dst udp port 67 and src udp port 68, 
 dst host $service_ip, 
 dst net $addr_prefix, 
 - 
 )
 -> dhcp :: DHCP($addr_prefix, SERVICE_IP $service_ip, SERVICE_MAC $service_mac)
 -> SetEtherAnno()
 -> [1]output;

 
 service_ip_clf[1]
 
 -> service_device;

 service_device[0]
 -> [3]output;

 service_ip_clf[2]
 -> bc :: HostEtherFilter(FF:FF:FF:FF:FF:FF) 
 -> Discard;

 bc[1]
 -> IPPrint("IP-Packet for other stations with service IP. Discard.")
 -> Discard;

 service_ip_clf[3]
 -> [0]gw[0] 
 -> [3]output;

 input[3]
 -> [1]gw[1]
 -> [3]output;

 
 service_ether_clf[1]
 -> ARPPrint("Got ARP packet for services.")
 -> hef :: HostEtherFilter(FF:FF:FF:FF:FF:FF) 
 -> arp :: ARP(SERVICE_MAC $service_mac, SERVICE_IP $service_ip, PREFIX $addr_prefix)
 -> SetEtherAnno()
 -> ARPPrint("Sent ARP response.")
 -> [3]output;

 
 hef[1]
 -> [0]service_device;

 service_ether_clf[2]
 -> Print("Got non-IP or non-ARP packet for services. How does this happen? Fix me.")
 -> Discard;


 
 input[2]
 -> dht_classifier :: Classifier(
 1/03 , 
 1/02 , 
 1/04 , 
 -
 );

 dht_classifier[0]
 -> [1]arp[1]
 -> [2]output;
 
 dht_classifier[1]
 -> [1]dhcp[1]
 -> [2]output;

 dht_classifier[2]
 -> [4]gw[4]
 -> [2]output;

 dht_classifier[3]
 
 -> Discard;
}












elementclass DHT { 
WIFI_DEV $wifi_dev, LINK_STAT $link_stat, PREFIX $addr_prefix | 

 AddressInfo(my_wlan $wifi_dev:eth);

 dht :: FalconDHT(my_wlan, $link_stat, $addr_prefix, 5000 , 10 , 50 , 25 );

 input[0]
 -> [1]dht[1]
 -> [0]output;

 input[1]
 -> Strip(6) 
 -> [0]dht[0]
 -> dht_out_clf :: Classifier (0/ffffffffffff, -)
 -> [1]output;

 dht_out_clf[1]
 -> [2]output;

 input[2]
 -> [2]dht[2]
 -> [3]output;

}

elementclass DHT_Peek {
  
 
 
  input[0]
 -> dsr_src_clf :: Classifier(0/0303 6/04, -)


 -> dht_clf :: Classifier(163/02, -)


   -> Print("CLICK:DHT_DSR: Packet fuer DHT",250)
   -> [1]output;
 
 dsr_src_clf[1]
  -> [0]output;
 
 dht_clf[1]


  -> [0]output;
} 






elementclass IAPP {
 STALE $stale,
 ASSOCLIST $assoc_list,
 ASSOC_RESP $assoc_resp,
 |
 

 iapp_encap :: BrnIappEncap();

 iapp_filter :: BrnIappRoamingFilter(ASSOCLIST $assoc_list);
 
 sta_tracker :: BrnIappStationTracker(
 STALE $stale,
 ASSOCLIST $assoc_list,
 NOTIFYHDL notify_hdl,
 DATAHDL data_hdl,
 ASSOC_RESP $assoc_resp);
 

 hello_hdl :: BrnIappHelloHandler(
 ASSOCLIST $assoc_list,
 ENCAP iapp_encap);

 notify_hdl :: BrnIappNotifyHandler(
 RESEND_NOTIFY 100, 
 NUM_RESEND 7, 
 ASSOCLIST $assoc_list, 
 ENCAP iapp_encap, 
 STATRACK sta_tracker,
 );

 route_hdl :: BrnIappRouteUpdateHandler(
 ASSOCLIST $assoc_list,
 ENCAP iapp_encap,
 HELLOHDL hello_hdl);
 
 data_hdl :: BrnIappDataHandler(
 ASSOCLIST $assoc_list, 
 ENCAP iapp_encap, 
 ROUTEHDL route_hdl);

 snoopy :: BrnIappStationSnooper(
 ASSOCLIST $assoc_list, 
 STATRACK sta_tracker, 
 HELLOHDL hello_hdl);

 all :: CompoundHandler("debug", "BrnIappEncap BrnIappRoamingFilter
 BrnIappStationTracker BrnIappHelloHandler BrnIappRouteUpdateHandler
 BrnIappDataHandler BrnIappStationSnooper", "2");

 optimize :: CompoundHandler("optimize", "BrnIappStationSnooper 
 BrnIappHelloHandler BrnIappDataHandler BrnIappStationTracker", "true");

 
 
 
 
 
 
 elementclass ip_printer { 
 input[0]
 -> ethertype_clf :: Classifier(12/8086, 12/0800);
 
 ethertype_clf[0] 
 -> CheckIPHeader(OFFSET 58)
 
 -> [0]output;
 
 ethertype_clf[1] 
 -> CheckIPHeader(OFFSET 14)
 
 -> [0]output;
 }

 data2_hdl :: BrnIappDataHandler(
 ASSOCLIST $assoc_list, 
 ENCAP iapp_encap, 
 ROUTEHDL route_hdl);

 Idle()
 -> data2_hdl;

 input[0]
 -> iapp_filter
 -> [0]output;
 
 iapp_filter[1]
 -> WifiDecap()
 
 -> [1]data2_hdl;
 
 data2_hdl[0]
 -> SetBrnTos(1)
 
 -> ip_printer 
 -> [1]output;

 
 
 
 input[1]
 
 -> iapp_clf :: Classifier(0/01, 
 0/02, 
 0/03, 
 0/04, 
 0/05, 
 - );
 
 iapp_clf[0] 
 -> [0]notify_hdl;

 iapp_clf[1] 
 -> [1]notify_hdl;

 iapp_clf[2] 
 -> [0]data_hdl;

 iapp_clf[3] 
 -> [0]route_hdl;

 iapp_clf[4] 
 -> [0]hello_hdl;

 iapp_clf[5] 
 -> Print("BOGUS --- invalid brn iapp type")
 -> Discard();

 
 
 
 input[2]
 
 -> [0]sta_tracker;

 
 

 input[3]
 
 -> [1]data_hdl;

 
 

 input[4]
 
 
 -> [0]snoopy;

 
 
 
 
 notify_hdl[0]
 
 -> SetBrnTos(1)
 -> [1]output;

 notify_hdl[1]
 -> [3]output;

 data_hdl[0]
 
 -> ip_printer 
 -> [1]output;

 route_hdl[0]
 
 -> SetBrnTos(1)
 -> [1]output;

 hello_hdl[0]
 
 -> [1]output;

 data2_hdl[1]
 -> [2]output;

 data_hdl[1]
 -> [2]output;
}

elementclass IAPP_Peek {

 input 
 -> dsr_src_clf :: Classifier(0/0303 6/04, -)
 -> StripBRNHeader()
 -> StripDSRHeader()
 -> iapp_peek :: Classifier(12/8086 14/0808, -)
 -> iapp_peek_tee :: Tee() 
 -> Strip(14) 
 -> StripBRNHeader()
 -> [1]output;
 
 dsr_src_clf[1]
 -> [0]output;
 
 iapp_peek[1]
 -> PushDSRHeader()
 -> PushBRNHeader()
 -> [0]output;
 
 iapp_peek_tee[1]
 -> PushDSRHeader()
 -> PushBRNHeader()
 -> [0]output;
}








elementclass VLAN {
 
 

 input[0]
 -> Null
 -> [0]output;

 input[1]
 -> Null
 -> [1]output;

 input[2]
 -> Null
 -> [2]output;

 input[3]
 -> Null
 -> [3]output;

 input[4]
 -> Null
 -> [4]output;

 input[5]
 -> Null
 -> [5]output;

||
 ETHERADDRESS $ether, ASSOCLIST $assoc_list, SSID $ssid |

 brn_vlans :: BRNVLAN($ssid);

 
 input[0]
 
 -> VLANEncap()
 -> BRNVLANTag(ETHERADDRESS $ether,ASSOCLIST $assoc_list, BRNVLAN brn_vlans)
 
 -> [0]output;
 
 input[1]
 
 -> check :: BRNCheckVLAN(ETHERADDRESS $ether, ASSOCLIST $assoc_list, BRNVLAN brn_vlans)
 -> VLANDecap()
 
 -> [1]output;

 check[1]
 
 -> Discard;

 
 
 input[2]
 
 -> VLANEncap()
 -> VLANTag(0) 
 
 -> [2]output;

 input[3]
 
 -> CheckVLAN(0) 
 -> VLANDecap()
 
 -> [3]output;

 
 
 

 


 input[4]
 
 -> brn_vlans
 
 -> [4]output;


 input[5]
 -> VLANDecap()
 -> [5]output;
 
 all :: CompoundHandler("debug", "BRNVLAN BRNCheckVLAN BRNVLANTag", "2");
}











 
 
 
 AddressInfo(my_wlan $wifi_dev:eth);
 AddressInfo(my_eth $eth_dev:eth);

 AddressInfo(service_ip $service_ip); 
  
 AddressInfo(service_mac 10:00:00:aa:aa:aa); 

 wifi_device :: WifiDevice($wifi_dev);

 

 route_cache :: BrnRouteCache(
 ACTIVE false, 
 DROP 0, 
 SLICE 0, 
 TTL 4);
 
 link_table :: BrnLinkTable(
 route_cache, 
 STALE 500, 
 SIMULATE false, 
 CONSTMETRIC 1, 
 MIN_LINK_METRIC_IN_ROUTE 300);
 
 id :: NodeIdentity(
 $wifi_dev, 
 $eth_dev, 
 $eth_dev, 
 link_table);
 
 assoc_list :: AssocList(id);

 services :: Services(WIFI_MAC my_wlan, PREFIX $addr_prefix, LINKTABLE link_table, SERVICE_MAC service_mac, SERVICE_IP service_ip, LOCAL_DEVNAME $local_dev, LOCAL_MAC my_wlan)
 
 brn_iapp :: IAPP(
 STALE 100,
 ASSOCLIST assoc_list,
 ASSOC_RESP access_point/assoc_resp,
 );

 
 
 
 vlan :: VLAN();

 access_point :: AccessPoint(
 INTERFACE $wifi_dev, 
 SSID $ssid, 
 CHANNEL $channel, 
 BEACON_INTERVAL 1000, 
 RATES DEFAULT 2 4 11 22 12 18 24 36 48 72 96 108,
 
 IAPP brn_iapp/sta_tracker);
 
 
 dht :: DHT(
 WIFI_DEV $wifi_dev, 
 LINK_STAT link_stat,
    PREFIX $addr_prefix
 );
 
 link_stat :: BRNLinkStat(
 ETHTYPE 0x0a04, 
 NODEIDENTITY id, 
 PERIOD 1000,
 TAU 30000,
 
 
 ETX etx_metric,
 PROBES "22 1000",
 RT access_point/rates,
 DHT dht/dht
 );

 dsr :: DSR( 
 NODE_IDENTITY id, 
 ASSOC_STATIONS assoc_list, 
 IAPP brn_iapp/sta_tracker);

 
 etx_metric :: BRNETXMetric(LT link_table);



 ds :: SetSourceAndOutputForDevice(ASSOCLIST assoc_list);
 
 
 
 
 
 
 wifi_device[0]
 -> host_filter :: HostWifiFilter(my_wlan, access_point/winfo, MODE 2)
 
 
 
 
 -> wifi_type_clf :: Classifier(0/00%0f,
 0/04%0f,
 0/08%ff,
 -)
 
 -> access_point;


 
 
 
 Idle()
 -> SetEtherAnno
 -> ethertype_clf :: Classifier(12/8086, -);
 
 
 services
 -> [2]vlan[2]
 -> service_filter :: HostEtherFilter(service_mac, DROP_OWN true);

 brn_iapp[3] -> [4]services;


 Idle
 -> [4]vlan[4]
 -> Discard;


 
 
 
 
 
 
 arp_tab :: ARPTable();
 
 prio_sched_wifi :: PrioSched();
 
 wifi_out_queue :: Null
 -> brn_tos_clf :: BrnTosClassifier()
 -> be_q :: NotifierQueue(50)
 -> [1]prio_sched_wifi
 -> [0]brn_iapp[0]
 -> [0]wifi_device;
 
 brn_tos_clf[1]
 -> prio_q :: NotifierQueue(50)
 -> [0]prio_sched_wifi;
 
 
 to_mesh_neighbors :: Null
 -> WifiEncap(0x00, WIRELESS_INFO access_point/winfo) 
 -> SetTXRate(22, TRIES 10)
 -> wifi_out_queue;
 
 to_stations :: Null
 -> WifiEncap(0x02, WIRELESS_INFO access_point/winfo) 
 -> SetTXRate(22, TRIES 10)
 -> wifi_out_queue;
 
 
 eth_out_queue :: Null
 -> NotifierQueue(50)
 -> Discard();
 
 
 local_out_queue :: Null
 -> [3]vlan[3]
 -> [0]services;

 
 
 
 
 access_point
 -> SetTXRate(2, TRIES 1) 
 -> wifi_out_queue;
 
 
 wifi_type_clf[1]
 -> Discard;
 
 
 wifi_type_clf[3]
 -> Discard;
 
 
 wifi_type_clf[2]
 -> wifi_data_clf :: Classifier(1/00%03,
 1/01%03,
 1/02%03,
 -)
 -> WifiDecap(STRICT true)
 -> ethertype_clf;

 wifi_data_clf[1]
 -> WifiDecap(STRICT true)
 -> [0]vlan[0] 
 -> disassociator :: Disassociator(ASSOC_RESP access_point/assoc_resp, 
 STA_TRACKER brn_iapp/sta_tracker)
 -> ethertype_clf;

 
 wifi_data_clf[2]
 -> Discard;

 wifi_data_clf[3]
 -> Discard;

    
 ethertype_clf[0] 
 -> EtherDecap()
 -> CheckBrnHeader()
 -> nb_lst :: NeighborList() 
 -> brn_clf :: Classifier(0/01, 
 0/02, 
 0/03, 
 0/04, 
 0/06, 
 0/07, 
 0/08, 
 0/09, 
 - 
 );
 
 brn_clf[0] 
 -> PushMACHeader()
 -> Discard;
 
 
 brn_clf[1] 
 -> Print("Got BRN TFTP")
 -> PushMACHeader()
 -> Discard;
 
 
 
 
 brn_clf[2]
 -> dht_peek :: DHT_Peek
 -> iapp_peek :: IAPP_Peek
 -> [1]dsr;
 
 dht_peek[1]
 -> [2]dht;
 
 iapp_peek[1]
 -> [2]brn_iapp;

 
 brn_clf[3] 
 -> Discard;
 
 brn_clf[4] 
 -> SetTimestamp()
 -> link_stat
 -> SetTimestamp()
 -> EtherEncap(0x8086, my_wlan, ff:ff:ff:ff:ff:ff)
 -> to_mesh_neighbors;
 
 
 
 brn_clf[5]
 -> [1]dht;
 
 
 brn_clf[6] 
 -> StripBRNHeader()
 -> [1]brn_iapp;

 brn_clf[7] 
 -> [3]services;

 brn_clf[8] 
 -> Print("BOGUS --- not existing brn type ... discard")
 -> Discard(); 
 
 
 ethertype_clf[1] 
 -> service_filter
 -> [5]vlan[5] 
 -> [1]services[1]
 -> ds;

 dht[0]
 -> [2]services[2]
 -> [0]dht;

 services[3]
 -> service_filter;

 service_filter[1]
 -> hfilter :: HostDualFilter(ADDR1 my_wlan, ADDR2 my_eth, DROP_OWN true)
 -> local_out_queue;

 hfilter[1]
 -> [0]dsr;

 
 
 

 elementclass BrnInBrnClassifier
 {
 input[0]
 -> brn_in_brn_clf :: Classifier(12/8086 14/03, 12/8086, -); 
 
 brn_in_brn_clf[0] 
 -> Discard();
 
 brn_in_brn_clf[1] 
 -> [1]output; 
 
 brn_in_brn_clf[2] 
 -> [0]output;
 } 

 
 dsr[0]
 -> brn_in_brn_clf :: BrnInBrnClassifier 
 -> ds;

 brn_in_brn_clf[1]
 -> EtherDecap()
 -> brn_clf; 
 
 dsr[1]
 -> dsr_ds :: BRNDS(id, nb_lst); 
 
 
 
 dsr[2] 
 -> StripBRNHeader()
 -> StripDSRHeader()
 -> [3]brn_iapp;
 
 dsr_ds[0]
 -> to_mesh_neighbors;
 
 dsr_ds[1]
 -> eth_out_queue;
 
 dsr_ds[2]
 -> Discard;
 
 dsr_ds[3]
 -> StripBRNHeader()
 -> StripDSRHeader()
 -> [3]brn_iapp;

 
 
 
 
 
 dht[1]
 -> to_mesh_neighbors;
 
 dht[2]
 ->[0]dsr;
 
 dht[3]
 -> [1]dsr;
 
 
 
 
 
 

 host_filter[1]
 -> [4]brn_iapp;

 brn_iapp[1]
 -> [5]services[4]
 -> [0]dsr
 
 brn_iapp[2]
 -> [2]dsr

 
 
 
 
 
 
 ds[0]
 -> to_sta :: ToStations(assoc_list)
 -> [1]vlan[1] 
 -> to_stations;

 to_sta[1]
 -> dst_clf :: Classifier(12/8086, -) 
 -> to_mesh :: ToMeshNeighbors(id)
 -> to_mesh_neighbors;

 dst_clf[1]
 -> Print("ERROR - I dropped an ethernet frame for a station") 
 -> Discard;
 
 
 ds[1]
 -> eth_out_queue;
 
 
 ds[2]
 -> local_out_queue;


 
 
 
 

 wifi_device[1] 
 -> failures :: FilterFailures
 -> Discard;
 
 failures[1]
 -> WifiDupeFilter
 -> mgm :: Classifier(0/00%0f, 
 0/08%0f 1/02%03, 
 -)
 -> Discard;
 
 mgm[1] 
 -> WifiDecap(STRICT true)
 -> [3]brn_iapp;

 mgm[2] 
 -> WifiDecap(STRICT true)
 -> Classifier(12/8086) 
 -> EtherDecap()
 -> [2]dsr;

} 


meshNode :: Meshnode( SSID "BerlinRoofNet", WIFI_DEV ath0, WIFI_CHANNEL 7,
 ETH_DEV eth0, LOCAL_DEV local,
 PREFIX 0.0.0.0/8, SERVICE_IP 0.0.0.1);



Script(
 write meshNode/ds.debug 2,
 write meshNode/to_sta.debug 2,
 write meshNode/to_mesh.debug 2,
 write meshNode/assoc_list.debug 2,
 write meshNode/disassociator.debug 2,
 
 write meshNode/host_filter.debug 2,

 
 

 
 write meshNode/access_point/all.debug 2,

 
 write meshNode/dsr/all.debug 1,

 
 write meshNode/brn_iapp/all.debug 2,
 write meshNode/brn_iapp/notify_hdl.debug 2,

 write meshNode/services/dhcp/dhcp_server.debug 2,
 write meshNode/services/arp/arp.debug 2,
 write meshNode/dht/dht.debug 2,

 
 write meshNode/services/gw/all.debug 2,
 
 
 
 
 



);  