_simDeviceMaster :: SimDeviceMaster(TCP, 7777, HOTSWAP true, SIMINTERFACES);

Script@3 :: Script(
  write meshNode/ds.debug 2,
  write meshNode/to_sta.debug 2,
  write meshNode/to_mesh.debug 2,
  write meshNode/assoc_list.debug 2,
  write meshNode/disassociator.debug 2,
  //write meshNode/sig_assoc.debug 2,
  write meshNode/host_filter.debug 2,

  // debug level of vlan
  //write meshNode/vlan/all.debug 2,

  // debug level of routing layer
  write meshNode/access_point/all.debug 2,

  // debug level of routing layer
  write meshNode/dsr/all.debug 2,
  write meshNode/dsr/querier.debug 2,

  // debug level of inter accesspoint protocol
  write meshNode/brn_iapp/all.debug 2,
  write meshNode/brn_iapp/sta_tracker.debug 2,
  write meshNode/brn_iapp/snoopy.debug 2,

  write meshNode/services/dhcp/dhcp_server.debug 2,
  write meshNode/services/arp/arp.debug 2,
  write meshNode/dht/dht.debug 2,

  // debug level of gateway
  write meshNode/services/gw/all.debug 2,
  //write meshNode/services/gw/all.debug 3,
  write meshNode/services/gw/gateway.debug 1,
  //write meshNode/services/gw/setgwflow.debug 3,
  //write meshNode/services/gw/encap.debug 2,
  //write meshNode/services/gw/decap.debug 2,

//  wait 10,
//  read meshNode/services/dhcp/dhcp_server.server_info,
);

meshNode/AddressInfo@1 :: AddressInfo(my_wlan ath0:eth);

meshNode/AddressInfo@2 :: AddressInfo(my_eth eth0:eth);

meshNode/AddressInfo@3 :: AddressInfo(service_ip 1.0.0.1);

meshNode/AddressInfo@4 :: AddressInfo(service_mac 10:00:00:aa:aa:aa);

meshNode/wifi_device/FromDevice@2 :: FromDevice(ath0);

meshNode/wifi_device/AthdescDecap@3 :: AthdescDecap;

meshNode/wifi_device/filter_phy :: FilterPhyErr;

meshNode/wifi_device/filter :: FilterTX;

meshNode/wifi_device/WifiDupeFilter@7 :: WifiDupeFilter;

meshNode/wifi_device/FilterTX@8 :: FilterTX;

meshNode/wifi_device/AthdescEncap@10 :: AthdescEncap;

meshNode/wifi_device/ToDevice@11 :: ToDevice(ath0);

meshNode/eth_device/Discard@1 :: Discard;

meshNode/eth_device/Idle@2 :: Idle;

meshNode/route_cache :: BrnRouteCache(
    ACTIVE false, 
    DROP  0, 
    SLICE  0, 
    TTL 4);

meshNode/link_table :: BrnLinkTable(
    route_cache, 
    STALE 500,  
    SIMULATE false, 
    CONSTMETRIC 1, 
    MIN_LINK_METRIC_IN_ROUTE 250);

meshNode/id :: NodeIdentity(
    ath0, 
    eth0, 
    eth0, 
    link_table);

meshNode/assoc_list :: AssocList(id);

meshNode/services/service_device/from_host/from_sim_device :: FromSimDevice(serv, 4096, TUNNEL true);

meshNode/services/service_device/from_host/CheckIPHeader@2 :: CheckIPHeader(0);

meshNode/services/service_device/from_host/ip_filter :: IPClassifier(src host service_ip, -);

meshNode/services/service_device/from_host/arp :: ARPQuerier(service_ip, service_mac);

meshNode/services/service_device/from_host/SetTimestamp@5 :: SetTimestamp;

meshNode/services/service_device/from_host/Discard@6 :: Discard;

meshNode/services/service_device/SetEtherAnno@3 :: SetEtherAnno;

meshNode/services/service_device/SetPacketType@6 :: SetPacketType(HOST);

meshNode/services/service_device/to_host/to_sim_device :: ToSimDevice(serv, ENCAP ETHER, TUNNEL true);

meshNode/services/service_device/to_host/ethertype_clf :: Classifier(12/0806, 12/0800, -);

meshNode/services/service_device/to_host/CheckIPHeader@3 :: CheckIPHeader(14);

meshNode/services/service_device/to_host/ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -);

meshNode/services/local_device/from_host/from_sim_device :: FromSimDevice(local, 4096, TUNNEL true);

meshNode/services/local_device/from_host/SimAddressInfo@2 :: SimAddressInfo(req_addr local:eth);

meshNode/services/local_device/from_host/dhcp_client/client :: DHCPClient(my_wlan, REQ_ADDR req_addr:ip, START 30);

meshNode/services/local_device/from_host/dhcp_client/CheckIPHeader@2 :: CheckIPHeader(0);

meshNode/services/local_device/from_host/dhcp_client/CheckUDPHeader@3 :: CheckUDPHeader;

meshNode/services/local_device/from_host/dhcp_client/CheckDHCPMsg@4 :: CheckDHCPMsg;

meshNode/services/local_device/from_host/dhcp_client/UDPIPEncap@5 :: UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67);

meshNode/services/local_device/from_host/dhcp_client/queue :: DHCPOfferMsgQueue(client.client_ip_read);

meshNode/services/local_device/from_host/dhcp_client/udp_encap :: UDPIPEncap(255.255.255.255, 68, 255.255.255.255, 67);

meshNode/services/local_device/from_host/dhcp_client/DHCPUnicastEncap@8 :: DHCPUnicastEncap(client.client_ip_read, client.server_ip_read);

meshNode/services/local_device/from_host/dhcp_client/Discard@9 :: Discard;

meshNode/services/local_device/from_host/CheckIPHeader@4 :: CheckIPHeader(0);

meshNode/services/local_device/from_host/ip_filter :: IPClassifier(src host req_addr:ip, -);

meshNode/services/local_device/from_host/arp :: ARPQuerier(req_addr:ip, my_wlan);

meshNode/services/local_device/from_host/SetTimestamp@7 :: SetTimestamp;

meshNode/services/local_device/from_host/Discard@8 :: Discard;

meshNode/services/local_device/from_host/dhcp_output :: Null;

meshNode/services/local_device/from_host/EtherEncap@10 :: EtherEncap(0x0800, my_wlan, FF:FF:FF:FF:FF:FF);

meshNode/services/local_device/from_host/SetTimestamp@11 :: SetTimestamp;

meshNode/services/local_device/from_host/ethertype_clf :: Classifier(12/0806, 12/0800, -);

meshNode/services/local_device/from_host/EtherDecap@13 :: EtherDecap;

meshNode/services/local_device/from_host/CheckIPHeader@14 :: CheckIPHeader(0);

meshNode/services/local_device/from_host/bogus :: Null;

meshNode/services/local_device/from_host/Print@16/Print@1 :: Print("ERROR: got unexpected packet (waiting for ARP and DHCP)");

meshNode/services/local_device/from_host/Discard@17 :: Discard;

meshNode/services/local_device/SetEtherAnno@3 :: SetEtherAnno;

meshNode/services/local_device/SetPacketType@6 :: SetPacketType(HOST);

meshNode/services/local_device/to_host/to_sim_device :: ToSimDevice(local, ENCAP ETHER, TUNNEL true);

meshNode/services/local_device/to_host/ethertype_clf :: Classifier(12/0806, 12/0800, -);

meshNode/services/local_device/to_host/CheckIPHeader@3 :: CheckIPHeader(14);

meshNode/services/local_device/to_host/ip_classifier :: IPClassifier(dst udp port 68 and src udp port 67, -);

meshNode/services/gw/mac_ip :: ARPTable;

meshNode/services/gw/table :: ARPTable;

meshNode/services/gw/clients :: StoreIPEthernet(mac_ip);

meshNode/services/gw/setgwflow :: BRNSetGatewayOnFlow(gateway, flows, link_table, mac_ip, buffer, 0.0.0.0/16);

meshNode/services/gw/buffer :: BRNPacketBuffer(setgwflow, 800);

meshNode/services/gw/gateway :: BRNGateway(my_wlan, setgwflow, UPDATE_GATEWAYS_INTERVAL 60, UPDATE_DHT_INTERVAL 60);

meshNode/services/gw/icmp_error2client :: Null;

meshNode/services/gw/StoreIPEthernet@8 :: StoreIPEthernet(table);

meshNode/services/gw/EtherDecap@9 :: EtherDecap;

meshNode/services/gw/udp :: IPClassifier(udp, -);

meshNode/services/gw/ICMPError@11 :: ICMPError(service_ip, unreachable, port);

meshNode/services/gw/resolve :: ResolveEthernet(my_wlan, table);

meshNode/services/gw/paint :: CheckPaint(0);

meshNode/services/gw/ICMPError@14 :: ICMPError(service_ip, unreachable, host);

meshNode/services/gw/paint2 :: CheckPaint(1);

meshNode/services/gw/encap :: BRNGatewayEncap(gateway);

meshNode/services/gw/Print@17/Print@1 :: Print("BOGUS - Should never happen");

meshNode/services/gw/IPPrint@18/IPPrint@1 :: IPPrint($rest);

meshNode/services/gw/Discard@19 :: Discard;

meshNode/services/gw/from_clients :: IPClassifier(udp && dst port 1194, tcp or udp, -);

meshNode/services/gw/setgw :: BRNSetGateway(gateway, link_table);

meshNode/services/gw/Paint@22 :: Paint(0);

meshNode/services/gw/flows :: AggregateIPFlows(TCP_TIMEOUT 60, TCP_DONE_TIMEOUT 10, UDP_TIMEOUT 60, ICMP false);

meshNode/services/gw/direction :: IPClassifier(src 0.0.0.0/16, -);

meshNode/services/gw/Print@25/Print@1 :: Print("BOGUS - Should never happen");

meshNode/services/gw/IPPrint@26/IPPrint@1 :: IPPrint($rest);

meshNode/services/gw/Discard@27 :: Discard;

meshNode/services/gw/Print@28/Print@1 :: Print("No gateway known");

meshNode/services/gw/Paint@29 :: Paint(0);

meshNode/services/gw/decap :: BRNGatewayDecap(gateway);

meshNode/services/gw/CheckIPHeader@31 :: CheckIPHeader(14);

meshNode/services/gw/to_clients :: IPClassifier(udp && src port 1194, tcp or udp or icmp type unreachable, -);

meshNode/services/gw/before_local_gw :: IPClassifier(udp && src port 1194, tcp or udp, -);

meshNode/services/gw/gws :: BRNGatewaySupervisor(gateway, link_table);

meshNode/services/gw/Paint@35 :: Paint(1);

meshNode/services/gw/all :: CompoundHandler("debug",
                           "BRNGatewayEncap BRNGatewayDecap
                            BRNGatewaySupervisor BRNSetGatewayOnFlow
                            BRNGateway BRNSetGateway BRNPacketBuffer",
                           "2");

meshNode/services/from_local_clf :: Classifier(12/0800, -);

meshNode/services/CheckIPHeader@5 :: CheckIPHeader(14);

meshNode/services/from_local_ip :: IPClassifier(src net 0.0.0.0/16 or dst host 255.255.255.255, -);

meshNode/services/local_clf :: Classifier(12/0800, -);

meshNode/services/CheckIPHeader@8 :: CheckIPHeader(14);

meshNode/services/local_ip :: IPClassifier(dst net 0.0.0.0/16 or dst host 255.255.255.255, -);

meshNode/services/service_ether_clf :: Classifier(
                                        12/0800,
                                        12/0806,
                                        -
                                      );

meshNode/services/CheckIPHeader@11 :: CheckIPHeader(14);

meshNode/services/service_ip_clf :: IPClassifier(
                dst udp port 67 and src udp port 68,  // dhcp request
                dst host service_ip, // service IP 
                dst net 0.0.0.0/16, // packet for other nodes
                - // packet for gateway
                                     );

meshNode/services/dhcp/EtherDecap@1 :: EtherDecap;

meshNode/services/dhcp/Strip@2 :: Strip(28);

meshNode/services/dhcp/dhcp_server :: DHCPServer(my_wlan, 0.0.0.0/16, service_ip, service_ip, 
        141.20.20.50 ,"dhcp.berlinroofnet.de","berlinroofnet.de");

meshNode/services/dhcp/UDPIPEncap@4 :: UDPIPEncap(service_ip, 67, 255.255.255.255, 68);

meshNode/services/dhcp/EtherEncap@5 :: EtherEncap(0x0800, service_mac, ff:ff:ff:ff:ff:ff);

meshNode/services/SetEtherAnno@14 :: SetEtherAnno;

meshNode/services/bc :: HostEtherFilter(FF:FF:FF:FF:FF:FF);

meshNode/services/Discard@16 :: Discard;

meshNode/services/IPPrint@17/IPPrint@1 :: IPPrint("IP-Packet for other stations with service IP. Discard.");

meshNode/services/Discard@18 :: Discard;

meshNode/services/ARPPrint@19/ARPPrint@1 :: ARPPrint("Got ARP packet for services.");

meshNode/services/hef :: HostEtherFilter(FF:FF:FF:FF:FF:FF);

meshNode/services/arp/arp :: Arp(service_ip, service_mac);

meshNode/services/SetEtherAnno@22 :: SetEtherAnno;

meshNode/services/ARPPrint@23/ARPPrint@1 :: ARPPrint("Sent ARP response.");

meshNode/services/Print@24/Print@1 :: Print("Got non-IP or non-ARP packet for services. How does this happen? Fix me.");

meshNode/services/Discard@25 :: Discard;

meshNode/services/dht_classifier :: Classifier(
                                    1/03 ,    //arp
                                    1/02 ,    //dhcp
                                    1/04 ,    //gateway
                                    -
                                   );

meshNode/services/Discard@27 :: Discard;

meshNode/brn_iapp/iapp_encap :: BrnIappEncap;

meshNode/brn_iapp/iapp_filter :: BrnIappRoamingFilter(ASSOCLIST assoc_list);

meshNode/brn_iapp/sta_tracker :: BrnIappStationTracker(
                  STALE 100,
                  ASSOCLIST assoc_list,
                  NOTIFYHDL notify_hdl,
                  DATAHDL data_hdl,
                  ASSOC_RESP access_point/assoc_resp);

meshNode/brn_iapp/hello_hdl :: BrnIappHelloHandler(
                  ASSOCLIST assoc_list,
                  ENCAP iapp_encap);

meshNode/brn_iapp/notify_hdl :: BrnIappNotifyHandler(
                  RESEND_NOTIFY 100, 
                  NUM_RESEND 7, 
                  ASSOCLIST assoc_list, 
                  ENCAP iapp_encap, 
                  STATRACK sta_tracker,
                  );

meshNode/brn_iapp/route_hdl :: BrnIappRouteUpdateHandler(
                  ASSOCLIST assoc_list,
                  ENCAP iapp_encap,
                  HELLOHDL hello_hdl);

meshNode/brn_iapp/data_hdl :: BrnIappDataHandler(
                  ASSOCLIST assoc_list, 
                  ENCAP iapp_encap, 
                  ROUTEHDL route_hdl);

meshNode/brn_iapp/snoopy :: BrnIappStationSnooper(
                  ASSOCLIST assoc_list, 
                  STATRACK sta_tracker, 
                  HELLOHDL hello_hdl);

meshNode/brn_iapp/all :: CompoundHandler("debug", "BrnIappEncap BrnIappRoamingFilter
    BrnIappStationTracker BrnIappHelloHandler BrnIappRouteUpdateHandler
    BrnIappDataHandler BrnIappStationSnooper", "2");

meshNode/brn_iapp/optimize :: CompoundHandler("optimize", "BrnIappStationSnooper 
    BrnIappHelloHandler BrnIappDataHandler BrnIappStationTracker", "true");

meshNode/brn_iapp/data2_hdl :: BrnIappDataHandler(
                  ASSOCLIST assoc_list, 
                  ENCAP iapp_encap, 
                  ROUTEHDL route_hdl);

meshNode/brn_iapp/Idle@12 :: Idle;

meshNode/brn_iapp/WifiDecap@13 :: WifiDecap;

meshNode/brn_iapp/SetBrnTos@14 :: SetBrnTos(1);

meshNode/brn_iapp/ip_printer@15/ethertype_clf :: Classifier(12/8086, 12/0800);

meshNode/brn_iapp/ip_printer@15/CheckIPHeader@2 :: CheckIPHeader(OFFSET 58);

meshNode/brn_iapp/ip_printer@15/CheckIPHeader@3 :: CheckIPHeader(OFFSET 14);

meshNode/brn_iapp/iapp_clf :: Classifier(0/01, // notify
                              0/02, // reply
                              0/03, // data
                              0/04, // route update
                              0/05, // hello
                              - );

meshNode/brn_iapp/Print@17/Print@1 :: Print("BOGUS --- invalid brn iapp type");

meshNode/brn_iapp/Discard@18 :: Discard;

meshNode/brn_iapp/SetBrnTos@19 :: SetBrnTos(1);

meshNode/brn_iapp/ip_printer@20/ethertype_clf :: Classifier(12/8086, 12/0800);

meshNode/brn_iapp/ip_printer@20/CheckIPHeader@2 :: CheckIPHeader(OFFSET 58);

meshNode/brn_iapp/ip_printer@20/CheckIPHeader@3 :: CheckIPHeader(OFFSET 14);

meshNode/brn_iapp/SetBrnTos@21 :: SetBrnTos(1);

meshNode/vlan/Null@1 :: Null;

meshNode/vlan/Null@2 :: Null;

meshNode/vlan/Null@3 :: Null;

meshNode/vlan/Null@4 :: Null;

meshNode/vlan/Null@5 :: Null;

meshNode/vlan/Null@6 :: Null;

meshNode/access_point/AddressInfo@1 :: AddressInfo(ether_address ath0:eth);

meshNode/access_point/winfo :: WirelessInfo(SSID "NetEmuCoding", BSSID ether_address, CHANNEL 14, 
             INTERVAL 1000);

meshNode/access_point/rates :: AvailableRates(DEFAULT 2 2);

meshNode/access_point/assoc_resp :: BRNAssocResponder(DEBUG 0, WIRELESS_INFO winfo, RT rates, 
        IAPP brn_iapp/sta_tracker);

meshNode/access_point/mgt_cl :: Classifier(
          0/00%f0, // assoc req
          0/10%f0, // assoc resp
          0/20%f0, // reassoc req
          0/30%f0, // reassoc resp
          0/40%f0, // probe req
          0/50%f0, // probe resp
          0/80%f0, // beacon
          0/90%f0, // ATIM
          0/a0%f0, // disassoc
          0/b0%f0, // auth 
          0/c0%f0, // deauth
          -        // reserved
          );

meshNode/access_point/beacon_source :: BeaconSource(WIRELESS_INFO winfo, RT rates, DEBUG false);

meshNode/access_point/Discard@7 :: Discard;

meshNode/access_point/Discard@8 :: Discard;

meshNode/access_point/Discard@9 :: Discard;

meshNode/access_point/OpenAuthResponder@10 :: OpenAuthResponder(WIRELESS_INFO winfo);

meshNode/access_point/Discard@11 :: Discard;

meshNode/access_point/Discard@12 :: Discard;

meshNode/access_point/all :: CompoundHandler("debug", "BRNAssocResponder",
  "2");

meshNode/dht/AddressInfo@1 :: AddressInfo(my_wlan ath0:eth);

meshNode/dht/dht :: FalconDHT(my_wlan, link_stat, 0.0.0.0/16, 5000 , 10 , 50 , 25 );

meshNode/dht/Strip@3 :: Strip(6);

meshNode/dht/dht_out_clf :: Classifier(0/ffffffffffff, -);

meshNode/link_stat :: BRNLinkStat(
    ETHTYPE 0x0a04, 
     NODEIDENTITY id, 
     PERIOD 500,
   STOP 80000,
     TAU 100000,
     //PROBES "2 60 12 60 2 1400 4 1400 11 1400 22 1400 12 1400 18 1400 24 1400 36 1400 48 1400 72 1400 96 1400",
     //ETT ett_metric,
     ETX etx_metric,
     PROBES "2 1500",
     RT access_point/rates,
     DHT dht/dht
    );

meshNode/ncdsr/brn_encap :: BRNEncap;

meshNode/ncdsr/dsr_decap :: DSRDecap(id);

meshNode/ncdsr/dsr_encap :: DSREncap(id);

meshNode/ncdsr/nb :: DstClassifier(id, assoc_list);

meshNode/ncdsr/querier :: RouteQuerier(id, dsr_encap, brn_encap, dsr_decap, brn_iapp/sta_tracker);

meshNode/ncdsr/req_forwarder :: RequestForwarder(id, dsr_decap, dsr_encap, brn_encap, querier, assoc_list, 300, brn_iapp/sta_tracker);

meshNode/ncdsr/rep_forwarder :: ReplyForwarder(id, dsr_decap, querier, assoc_list, dsr_encap);

meshNode/ncdsr/src_forwarder :: SrcForwarder(id, assoc_list, dsr_encap, dsr_decap);

meshNode/ncdsr/route_updater :: SrcForwarder(id, assoc_list, dsr_encap, dsr_decap);

meshNode/ncdsr/err_forwarder :: ErrorForwarder(id, assoc_list, dsr_encap, dsr_decap, querier, brn_encap);

meshNode/ncdsr/encoder :: NetcodingEncoder(NC_CACHE cache, NODE_IDENTITY id, 
    SEND_QUEUE send_queue, BITRATE 2, FRAGMENTS_IN_PACKET 2);

meshNode/ncdsr/decoder :: NetcodingDecoder(NC_CACHE cache, HARD_TIMEOUT 10000000, TRACE_COLLECTOR trace_collector);

meshNode/ncdsr/cache :: NetcodingCache(NODE_IDENTITY id, ASSOC_LIST assoc_list, 
    UPDATE_ROUTE false, FRAGMENTS_IN_BATCH 32, 
    BITS_IN_MULTIPLIER 8);

meshNode/ncdsr/dec_clf :: Classifier(
        0/0a, //BRN_PORT_NETCODING
        0/0b, //BRN_PORT_NETCODING_STOP
        - //everything else
        );

meshNode/ncdsr/fragmenter :: Fragmenter(FRAGMENT_LENGTH 751);

meshNode/ncdsr/defragmenter :: Defragmenter;

meshNode/ncdsr/fragmentsender :: FragmentSender(PACKER packer);

meshNode/ncdsr/fragmentreceiver :: FragmentReceiver(NODE_IDENTITY id, NC_CACHE cache, 
    TRACE_COLLECTOR trace_collector, PACKER packer, FRAGMENT_LENGTH 751,
    OPPORTUNISTIC true);

meshNode/ncdsr/send_queue :: NotifierQueue(20);

meshNode/ncdsr/monitor :: QueueMonitor(QUEUE send_queue, CLIENT encoder);

meshNode/ncdsr/packer :: HeaderPacker(FRAGMENTS_IN_BATCH 32, BITS_IN_MULTIPLIER 8);

meshNode/ncdsr/Print@22/Print@1 :: Print("received packet for encoding");

meshNode/ncdsr/clf_bcast :: Classifier(0/ffffffffffff, -);

meshNode/ncdsr/Discard@24 :: Discard;

meshNode/ncdsr/SetTimestamp@25 :: SetTimestamp;

meshNode/ncdsr/SetTimestamp@26 :: SetTimestamp;

meshNode/ncdsr/SetTimestamp@27 :: SetTimestamp;

meshNode/ncdsr/tee_to_err_fwd :: Tee;

meshNode/ncdsr/Idle@29 :: Idle;

meshNode/ncdsr/Discard@30 :: Discard;

meshNode/ncdsr/dsrclf :: Classifier(6/01, //DSR_RREQ
                          6/02, //DSR_RREP
                          6/03, //DSR_RERR
                          6/04, //DSR_SRC
                          );

meshNode/ncdsr/SetTimestamp@32 :: SetTimestamp;

meshNode/ncdsr/NetcodingPrint@33 :: NetcodingPrint("received fragment");

meshNode/ncdsr/Strip@34 :: Strip(182);

meshNode/ncdsr/CheckCRC32@35 :: CheckCRC32;

meshNode/ncdsr/Unstrip@36 :: Unstrip(182);

meshNode/ncdsr/route_upd_clf :: Classifier(31/00, -);

meshNode/ncdsr/Unstrip@38 :: Unstrip(14);

meshNode/ncdsr/Strip@39 :: Strip(14);

meshNode/ncdsr/errclf :: Classifier(0/0b, -);

meshNode/ncdsr/Strip@41 :: Strip(182);

meshNode/ncdsr/SetCRC32@42 :: SetCRC32;

meshNode/ncdsr/Unstrip@43 :: Unstrip(182);

meshNode/ncdsr/all :: CompoundHandler("debug", "BRNEncap DSRDecap DSREncap DstClassifier
  RouteQuerier RequestForwarder ReplyForwarder SrcForwarder ErrorForwarder",
  "2");

meshNode/dsr/brn_encap :: BRNEncap;

meshNode/dsr/dsr_decap :: DSRDecap(id);

meshNode/dsr/dsr_encap :: DSREncap(id);

meshNode/dsr/nb :: DstClassifier(id, assoc_list);

meshNode/dsr/querier :: RouteQuerier(id, dsr_encap, brn_encap, dsr_decap, brn_iapp/sta_tracker);

meshNode/dsr/req_forwarder :: RequestForwarder(id, dsr_decap, dsr_encap, brn_encap, querier, assoc_list, 300, brn_iapp/sta_tracker);

meshNode/dsr/rep_forwarder :: ReplyForwarder(id, dsr_decap, querier, assoc_list, dsr_encap);

meshNode/dsr/src_forwarder :: SrcForwarder(id, assoc_list, dsr_encap, dsr_decap);

meshNode/dsr/err_forwarder :: ErrorForwarder(id, assoc_list, dsr_encap, dsr_decap, querier, brn_encap);

meshNode/dsr/clf_bcast :: Classifier(0/ffffffffffff, -);

meshNode/dsr/Discard@11 :: Discard;

meshNode/dsr/SetTimestamp@12 :: SetTimestamp;

meshNode/dsr/SetTimestamp@13 :: SetTimestamp;

meshNode/dsr/SetTimestamp@14 :: SetTimestamp;

meshNode/dsr/tee_to_err_fwd :: Tee;

meshNode/dsr/dsrclf :: Classifier(6/01, //DSR_RREQ
                          6/02, //DSR_RREP
                          6/03, //DSR_RERR
                          6/04, //DSR_SRC
                          );

meshNode/dsr/SetTimestamp@17 :: SetTimestamp;

meshNode/dsr/TraceReporter@18 :: TraceReporter(TRACE_COLLECTOR trace_collector, MODE 0);

meshNode/dsr/all :: CompoundHandler("debug", "BRNEncap DSRDecap DSREncap DstClassifier
  RouteQuerier RequestForwarder ReplyForwarder SrcForwarder ErrorForwarder",
  "2");

meshNode/trace_collector :: TraceCollector;

meshNode/etx_metric :: BRNETXMetric(LT link_table);

meshNode/ds :: SetSourceAndOutputForDevice(ASSOCLIST assoc_list);

meshNode/host_filter :: HostWifiFilter(my_wlan, access_point/winfo, MODE 2);

meshNode/wifi_type_clf :: Classifier(0/00%0f,
                                 0/08%ff);

meshNode/promisc_stop_clf :: Classifier(32/0b, -);

meshNode/Classifier@25 :: Classifier(0/08%ff);

meshNode/Classifier@26 :: Classifier(1/00%02);

meshNode/WifiDecap@27 :: WifiDecap(STRICT true);

meshNode/Classifier@28 :: Classifier(12/8086);

meshNode/EtherDecap@29 :: EtherDecap;

meshNode/CheckBrnHeader@30 :: CheckBrnHeader;

meshNode/HostWifiFilter@31 :: HostWifiFilter(my_wlan, access_point/winfo, MODE 2);

meshNode/Classifier@32 :: Classifier(0/08%ff);

meshNode/Classifier@33 :: Classifier(1/00%02);

meshNode/WifiDecap@34 :: WifiDecap(STRICT true);

meshNode/Classifier@35 :: Classifier(12/8086);

meshNode/EtherDecap@36 :: EtherDecap;

meshNode/CheckBrnHeader@37 :: CheckBrnHeader;

meshNode/Classifier@38 :: Classifier(0/0a);

meshNode/ethertype_clf :: Classifier(12/8086, -);

meshNode/service_filter :: HostEtherFilter(service_mac, DROP_OWN true);

meshNode/Idle@41 :: Idle;

meshNode/Discard@42 :: Discard;

meshNode/arp_tab :: ARPTable;

meshNode/prio_sched_wifi :: PrioSched;

meshNode/wifi_out_queue :: Null;

meshNode/brn_tos_clf :: BrnTosClassifier;

meshNode/be_q :: NotifierQueue(50);

meshNode/prio_q :: NotifierQueue(50);

meshNode/Print@49/Print@1 :: Print("ncdsr[4]");

meshNode/EtherEncap@50 :: EtherEncap(0x8086, ath0, ff:ff:ff:ff:ff:ff);

meshNode/WifiEncap@51 :: WifiEncap(0x00, WIRELESS_INFO access_point/winfo);

meshNode/SetTXRate@52 :: SetTXRate(2, TRIES 10);

meshNode/to_mesh_neighbors :: Null;

meshNode/WifiEncap@54 :: WifiEncap(0x00, WIRELESS_INFO access_point/winfo);

meshNode/SetTXRate@55 :: SetTXRate(2, TRIES 10);

meshNode/to_stations :: Null;

meshNode/WifiEncap@57 :: WifiEncap(0x02, WIRELESS_INFO access_point/winfo);

meshNode/SetTXRate@58 :: SetTXRate(2, TRIES 10);

meshNode/eth_out_queue :: Null;

meshNode/NotifierQueue@60 :: NotifierQueue(50);

meshNode/local_out_queue :: Null;

meshNode/SetTXRate@62 :: SetTXRate(2, TRIES 1);

meshNode/wifi_data_clf :: Classifier(1/00%03,
                                 1/01%03);

meshNode/WifiDecap@64 :: WifiDecap(STRICT true);

meshNode/WifiDecap@65 :: WifiDecap(STRICT true);

meshNode/disassociator :: Disassociator(ASSOC_RESP access_point/assoc_resp, 
                                    STA_TRACKER brn_iapp/sta_tracker);

meshNode/EtherDecap@67 :: EtherDecap;

meshNode/CheckBrnHeader@68 :: CheckBrnHeader;

meshNode/nb_lst :: NeighborList;

meshNode/brn_clf :: Classifier(0/03, //BrnDSR
                           0/06, //LinkProbe
                           0/07, //DHT
                           0/08, //IAPP
                           0/09, //gateway
                           0/0a, //netcoding data
                           0/0b, //netcoding stop
                           -     //other
                          );

meshNode/dht_peek/dsr_src_clf :: Classifier(0/0303 6/04, -);

meshNode/dht_peek/dht_clf :: Classifier(163/02, -);

meshNode/dht_peek/Print@3/Print@1 :: Print("CLICK:DHT_DSR: Packet fuer DHT", 250);

meshNode/iapp_peek/dsr_src_clf :: Classifier(0/0303 6/04, -);

meshNode/iapp_peek/StripBRNHeader@2 :: StripBRNHeader;

meshNode/iapp_peek/StripDSRHeader@3 :: StripDSRHeader;

meshNode/iapp_peek/iapp_peek :: Classifier(12/8086 14/0808, -);

meshNode/iapp_peek/iapp_peek_tee :: Tee;

meshNode/iapp_peek/Strip@6 :: Strip(14);

meshNode/iapp_peek/StripBRNHeader@7 :: StripBRNHeader;

meshNode/iapp_peek/PushDSRHeader@8 :: PushDSRHeader;

meshNode/iapp_peek/PushBRNHeader@9 :: PushBRNHeader;

meshNode/iapp_peek/PushDSRHeader@10 :: PushDSRHeader;

meshNode/iapp_peek/PushBRNHeader@11 :: PushBRNHeader;

meshNode/SetTimestamp@73 :: SetTimestamp;

meshNode/SetTimestamp@74 :: SetTimestamp;

meshNode/EtherEncap@75 :: EtherEncap(0x8086, my_wlan, ff:ff:ff:ff:ff:ff);

meshNode/StripBRNHeader@76 :: StripBRNHeader;

meshNode/Discard@77 :: Discard;

meshNode/hfilter :: HostEtherFilter(my_wlan, DROP_OWN true);

meshNode/tcpackfilter :: CheckLength(54);

meshNode/Print@80/Print@1 :: Print("dsr[0]");

meshNode/brn_in_brn_clf/brn_in_brn_clf :: Classifier(12/8086 14/03, 12/8086, -);

meshNode/brn_in_brn_clf/Discard@2 :: Discard;

meshNode/Print@82/Print@1 :: Print("ncdsr[0]", 512);

meshNode/EtherDecap@83 :: EtherDecap;

meshNode/Print@84/Print@1 :: Print("dsr[1]");

meshNode/dsr_ds :: BRNDS(id, nb_lst);

meshNode/Print@86/Print@1 :: Print("ncdsr[1]");

meshNode/Print@87/Print@1 :: Print("dsr[2]");

meshNode/StripBRNHeader@88 :: StripBRNHeader;

meshNode/StripDSRHeader@89 :: StripDSRHeader;

meshNode/Print@90/Print@1 :: Print("ncdsr[2]");

meshNode/StripBRNHeader@91 :: StripBRNHeader;

meshNode/StripDSRHeader@92 :: StripDSRHeader;

meshNode/Print@93/Print@1 :: Print("ncdsr[3]", 28);

meshNode/WifiEncap@94 :: WifiEncap(0x00, WIRELESS_INFO access_point/winfo);

meshNode/SetTXRate@95 :: SetTXRate(2, TRIES 10);

meshNode/Discard@96 :: Discard;

meshNode/StripBRNHeader@97 :: StripBRNHeader;

meshNode/StripDSRHeader@98 :: StripDSRHeader;

meshNode/to_sta :: ToStations(assoc_list);

meshNode/dst_clf :: Classifier(12/8086);

meshNode/to_mesh :: ToMeshNeighbors(id);

meshNode/failures :: FilterFailures;

meshNode/Discard@103 :: Discard;

meshNode/WifiDupeFilter@104 :: WifiDupeFilter;

meshNode/mgm :: Classifier(0/00%0f,   // management
                       0/08%0f 1/02%03,  // type data, subtype data, FromDS
                       -);

meshNode/Discard@106 :: Discard;

meshNode/WifiDecap@107 :: WifiDecap(STRICT true);

meshNode/WifiDecap@108 :: WifiDecap(STRICT true);

meshNode/Classifier@109 :: Classifier(12/8086);

meshNode/EtherDecap@110 :: EtherDecap;

Align@click_align@345 :: Align(4, 0);

Align@click_align@348 :: Align(2, 0);

Align@click_align@360 :: Align(4, 0);

Align@click_align@364 :: Align(4, 0);

Align@click_align@377 :: Align(4, 2);

Align@click_align@382 :: Align(4, 0);

Align@click_align@395 :: Align(4, 0);

Align@click_align@402 :: Align(4, 0);

Align@click_align@404 :: Align(4, 0);

Align@click_align@415 :: Align(4, 0);

Align@click_align@416 :: Align(4, 2);

Align@click_align@447 :: Align(4, 0);

Align@click_align@449 :: Align(4, 2);

Align@click_align@461 :: Align(4, 0);

Align@click_align@469 :: Align(4, 0);

Align@click_align@470 :: Align(4, 0);

Align@click_align@471 :: Align(4, 0);

Align@click_align@472 :: Align(4, 0);

Align@click_align@474 :: Align(4, 0);

Align@click_align@475 :: Align(4, 0);

Align@click_align@476 :: Align(4, 0);

Align@click_align@477 :: Align(4, 0);

Align@click_align@478 :: Align(4, 0);

Align@click_align@479 :: Align(4, 0);

Align@click_align@480 :: Align(4, 0);

AlignmentInfo@click_align@370 :: AlignmentInfo(_simDeviceMaster,
  Script@3,
  meshNode/AddressInfo@1,
  meshNode/AddressInfo@2,
  meshNode/AddressInfo@3,
  meshNode/AddressInfo@4,
  meshNode/wifi_device/FromDevice@2,
  meshNode/wifi_device/AthdescDecap@3  4 2,
  meshNode/wifi_device/filter_phy  4 2,
  meshNode/wifi_device/filter  4 2,
  meshNode/wifi_device/WifiDupeFilter@7  4 2,
  meshNode/wifi_device/FilterTX@8  4 2,
  meshNode/wifi_device/AthdescEncap@10  4 0,
  meshNode/wifi_device/ToDevice@11  4 0,
  meshNode/eth_device/Discard@1  4 0,
  meshNode/eth_device/Idle@2,
  meshNode/route_cache,
  meshNode/link_table,
  meshNode/id,
  meshNode/assoc_list,
  meshNode/services/service_device/from_host/from_sim_device,
  meshNode/services/service_device/from_host/CheckIPHeader@2  4 0,
  meshNode/services/service_device/from_host/ip_filter  4 0,
  meshNode/services/service_device/from_host/arp  4 0  2 0,
  meshNode/services/service_device/from_host/SetTimestamp@5  2 0,
  meshNode/services/service_device/from_host/Discard@6  4 0,
  meshNode/services/service_device/SetEtherAnno@3  2 0,
  meshNode/services/service_device/SetPacketType@6  4 0,
  meshNode/services/service_device/to_host/to_sim_device  4 0  4 0,
  meshNode/services/service_device/to_host/ethertype_clf  4 0,
  meshNode/services/service_device/to_host/CheckIPHeader@3  4 0,
  meshNode/services/service_device/to_host/ip_classifier  4 0,
  meshNode/services/local_device/from_host/from_sim_device,
  meshNode/services/local_device/from_host/SimAddressInfo@2,
  meshNode/services/local_device/from_host/dhcp_client/client  4 0  4 0,
  meshNode/services/local_device/from_host/dhcp_client/CheckIPHeader@2  4 0,
  meshNode/services/local_device/from_host/dhcp_client/CheckUDPHeader@3  4 0,
  meshNode/services/local_device/from_host/dhcp_client/CheckDHCPMsg@4  4 0,
  meshNode/services/local_device/from_host/dhcp_client/UDPIPEncap@5  4 0,
  meshNode/services/local_device/from_host/dhcp_client/queue  4 0,
  meshNode/services/local_device/from_host/dhcp_client/udp_encap  4 0,
  meshNode/services/local_device/from_host/dhcp_client/DHCPUnicastEncap@8  4 0,
  meshNode/services/local_device/from_host/dhcp_client/Discard@9  4 0,
  meshNode/services/local_device/from_host/CheckIPHeader@4  4 0,
  meshNode/services/local_device/from_host/ip_filter  4 0,
  meshNode/services/local_device/from_host/arp  4 0  4 0,
  meshNode/services/local_device/from_host/SetTimestamp@7  4 0,
  meshNode/services/local_device/from_host/Discard@8  4 0,
  meshNode/services/local_device/from_host/dhcp_output  4 0,
  meshNode/services/local_device/from_host/EtherEncap@10  4 0,
  meshNode/services/local_device/from_host/SetTimestamp@11  4 2,
  meshNode/services/local_device/from_host/ethertype_clf  4 0,
  meshNode/services/local_device/from_host/EtherDecap@13  4 0,
  meshNode/services/local_device/from_host/CheckIPHeader@14  4 0,
  meshNode/services/local_device/from_host/bogus  4 0,
  meshNode/services/local_device/from_host/Print@16/Print@1  4 0,
  meshNode/services/local_device/from_host/Discard@17  4 0,
  meshNode/services/local_device/SetEtherAnno@3  2 0,
  meshNode/services/local_device/SetPacketType@6  4 0,
  meshNode/services/local_device/to_host/to_sim_device  4 0  4 0,
  meshNode/services/local_device/to_host/ethertype_clf  4 0,
  meshNode/services/local_device/to_host/CheckIPHeader@3  4 0,
  meshNode/services/local_device/to_host/ip_classifier  4 0,
  meshNode/services/gw/mac_ip,
  meshNode/services/gw/table,
  meshNode/services/gw/clients  4 0,
  meshNode/services/gw/setgwflow  4 0  4 0  4 0,
  meshNode/services/gw/buffer  4 0,
  meshNode/services/gw/gateway  4 0,
  meshNode/services/gw/icmp_error2client  4 0,
  meshNode/services/gw/StoreIPEthernet@8  4 0,
  meshNode/services/gw/EtherDecap@9  4 0,
  meshNode/services/gw/udp  4 0,
  meshNode/services/gw/ICMPError@11  4 0,
  meshNode/services/gw/resolve  4 0,
  meshNode/services/gw/paint  4 0,
  meshNode/services/gw/ICMPError@14  4 0,
  meshNode/services/gw/paint2  4 0,
  meshNode/services/gw/encap  4 0,
  meshNode/services/gw/Print@17/Print@1  4 0,
  meshNode/services/gw/IPPrint@18/IPPrint@1  4 0,
  meshNode/services/gw/Discard@19  4 0,
  meshNode/services/gw/from_clients  4 0,
  meshNode/services/gw/setgw  4 0,
  meshNode/services/gw/Paint@22  4 0,
  meshNode/services/gw/flows  4 0,
  meshNode/services/gw/direction  4 0,
  meshNode/services/gw/Print@25/Print@1  4 0,
  meshNode/services/gw/IPPrint@26/IPPrint@1  4 0,
  meshNode/services/gw/Discard@27  4 0,
  meshNode/services/gw/Print@28/Print@1  4 0,
  meshNode/services/gw/Paint@29  4 0,
  meshNode/services/gw/decap  4 0,
  meshNode/services/gw/CheckIPHeader@31  4 0,
  meshNode/services/gw/to_clients  4 0,
  meshNode/services/gw/before_local_gw  4 0,
  meshNode/services/gw/gws  4 0  4 0,
  meshNode/services/gw/Paint@35  4 0,
  meshNode/services/gw/all,
  meshNode/services/from_local_clf  4 0,
  meshNode/services/CheckIPHeader@5  4 0,
  meshNode/services/from_local_ip  4 0,
  meshNode/services/local_clf  4 0,
  meshNode/services/CheckIPHeader@8  4 0,
  meshNode/services/local_ip  4 0,
  meshNode/services/service_ether_clf  4 0,
  meshNode/services/CheckIPHeader@11  4 0,
  meshNode/services/service_ip_clf  4 0,
  meshNode/services/dhcp/EtherDecap@1  4 0,
  meshNode/services/dhcp/Strip@2  4 0,
  meshNode/services/dhcp/dhcp_server  4 0  4 0,
  meshNode/services/dhcp/UDPIPEncap@4  4 0,
  meshNode/services/dhcp/EtherEncap@5  4 2,
  meshNode/services/SetEtherAnno@14  4 0,
  meshNode/services/bc  4 0,
  meshNode/services/Discard@16  4 0,
  meshNode/services/IPPrint@17/IPPrint@1  4 0,
  meshNode/services/Discard@18  4 0,
  meshNode/services/ARPPrint@19/ARPPrint@1  4 0,
  meshNode/services/hef  4 0,
  meshNode/services/arp/arp  4 0  4 0,
  meshNode/services/SetEtherAnno@22  4 0,
  meshNode/services/ARPPrint@23/ARPPrint@1  4 0,
  meshNode/services/Print@24/Print@1  4 0,
  meshNode/services/Discard@25  4 0,
  meshNode/services/dht_classifier  4 0,
  meshNode/services/Discard@27  4 0,
  meshNode/brn_iapp/iapp_encap,
  meshNode/brn_iapp/iapp_filter  4 0,
  meshNode/brn_iapp/sta_tracker  4 2,
  meshNode/brn_iapp/hello_hdl  4 0,
  meshNode/brn_iapp/notify_hdl  4 0  4 0,
  meshNode/brn_iapp/route_hdl  4 0,
  meshNode/brn_iapp/data_hdl  4 0  4 0,
  meshNode/brn_iapp/snoopy  4 2,
  meshNode/brn_iapp/all,
  meshNode/brn_iapp/optimize,
  meshNode/brn_iapp/data2_hdl  4 0  4 0,
  meshNode/brn_iapp/Idle@12,
  meshNode/brn_iapp/WifiDecap@13  4 0,
  meshNode/brn_iapp/SetBrnTos@14  4 0,
  meshNode/brn_iapp/ip_printer@15/ethertype_clf  4 0,
  meshNode/brn_iapp/ip_printer@15/CheckIPHeader@2  4 0,
  meshNode/brn_iapp/ip_printer@15/CheckIPHeader@3  4 0,
  meshNode/brn_iapp/iapp_clf  4 0,
  meshNode/brn_iapp/Print@17/Print@1  4 0,
  meshNode/brn_iapp/Discard@18  4 0,
  meshNode/brn_iapp/SetBrnTos@19  4 0,
  meshNode/brn_iapp/ip_printer@20/ethertype_clf  4 0,
  meshNode/brn_iapp/ip_printer@20/CheckIPHeader@2  4 0,
  meshNode/brn_iapp/ip_printer@20/CheckIPHeader@3  4 0,
  meshNode/brn_iapp/SetBrnTos@21  4 0,
  meshNode/vlan/Null@1  4 2,
  meshNode/vlan/Null@2  4 0,
  meshNode/vlan/Null@3  4 0,
  meshNode/vlan/Null@4  4 0,
  meshNode/vlan/Null@5  0 0,
  meshNode/vlan/Null@6  2 0,
  meshNode/access_point/AddressInfo@1,
  meshNode/access_point/winfo,
  meshNode/access_point/rates,
  meshNode/access_point/assoc_resp  4 0,
  meshNode/access_point/mgt_cl  4 0,
  meshNode/access_point/beacon_source  4 0,
  meshNode/access_point/Discard@7  4 0,
  meshNode/access_point/Discard@8  4 0,
  meshNode/access_point/Discard@9  4 0,
  meshNode/access_point/OpenAuthResponder@10  4 0,
  meshNode/access_point/Discard@11  4 0,
  meshNode/access_point/Discard@12  4 0,
  meshNode/access_point/all,
  meshNode/dht/AddressInfo@1,
  meshNode/dht/dht  4 2  4 0  4 0,
  meshNode/dht/Strip@3  4 0,
  meshNode/dht/dht_out_clf  4 0,
  meshNode/link_stat  4 2,
  meshNode/ncdsr/brn_encap,
  meshNode/ncdsr/dsr_decap,
  meshNode/ncdsr/dsr_encap,
  meshNode/ncdsr/nb  4 0,
  meshNode/ncdsr/querier  4 0,
  meshNode/ncdsr/req_forwarder  4 0,
  meshNode/ncdsr/rep_forwarder  4 0  4 0,
  meshNode/ncdsr/src_forwarder  4 0  4 0,
  meshNode/ncdsr/route_updater  4 0  4 0,
  meshNode/ncdsr/err_forwarder  4 0  4 0,
  meshNode/ncdsr/encoder  4 0  4 0,
  meshNode/ncdsr/decoder  2 0  4 2,
  meshNode/ncdsr/cache,
  meshNode/ncdsr/dec_clf  4 0,
  meshNode/ncdsr/fragmenter  4 0,
  meshNode/ncdsr/defragmenter  2 0,
  meshNode/ncdsr/fragmentsender  4 2,
  meshNode/ncdsr/fragmentreceiver  4 0  2 0,
  meshNode/ncdsr/send_queue  4 2,
  meshNode/ncdsr/monitor  4 2,
  meshNode/ncdsr/packer,
  meshNode/ncdsr/Print@22/Print@1  2 0,
  meshNode/ncdsr/clf_bcast  4 0,
  meshNode/ncdsr/Discard@24  4 0,
  meshNode/ncdsr/SetTimestamp@25  4 0,
  meshNode/ncdsr/SetTimestamp@26  4 0,
  meshNode/ncdsr/SetTimestamp@27  4 0,
  meshNode/ncdsr/tee_to_err_fwd  4 0,
  meshNode/ncdsr/Idle@29,
  meshNode/ncdsr/Discard@30  4 0,
  meshNode/ncdsr/dsrclf  4 0,
  meshNode/ncdsr/SetTimestamp@32  4 0,
  meshNode/ncdsr/NetcodingPrint@33  2 0,
  meshNode/ncdsr/Strip@34  2 0,
  meshNode/ncdsr/CheckCRC32@35  2 0,
  meshNode/ncdsr/Unstrip@36  2 0,
  meshNode/ncdsr/route_upd_clf  4 0,
  meshNode/ncdsr/Unstrip@38  4 2,
  meshNode/ncdsr/Strip@39  4 2,
  meshNode/ncdsr/errclf  4 2,
  meshNode/ncdsr/Strip@41  4 0,
  meshNode/ncdsr/SetCRC32@42  4 2,
  meshNode/ncdsr/Unstrip@43  4 2,
  meshNode/ncdsr/all,
  meshNode/dsr/brn_encap,
  meshNode/dsr/dsr_decap,
  meshNode/dsr/dsr_encap,
  meshNode/dsr/nb  4 0,
  meshNode/dsr/querier  4 0,
  meshNode/dsr/req_forwarder  4 0,
  meshNode/dsr/rep_forwarder  4 0  4 0,
  meshNode/dsr/src_forwarder  4 0  4 0,
  meshNode/dsr/err_forwarder  4 0  4 0,
  meshNode/dsr/clf_bcast  4 0,
  meshNode/dsr/Discard@11  4 0,
  meshNode/dsr/SetTimestamp@12  4 0,
  meshNode/dsr/SetTimestamp@13  4 0,
  meshNode/dsr/SetTimestamp@14  4 0,
  meshNode/dsr/tee_to_err_fwd  4 0,
  meshNode/dsr/dsrclf  4 0,
  meshNode/dsr/SetTimestamp@17  4 0,
  meshNode/dsr/TraceReporter@18  4 0,
  meshNode/dsr/all,
  meshNode/trace_collector,
  meshNode/etx_metric,
  meshNode/ds  4 0,
  meshNode/host_filter  4 2,
  meshNode/wifi_type_clf  4 2,
  meshNode/promisc_stop_clf  4 2,
  meshNode/Classifier@25  4 2,
  meshNode/Classifier@26  4 2,
  meshNode/WifiDecap@27  4 2,
  meshNode/Classifier@28  4 2,
  meshNode/EtherDecap@29  4 2,
  meshNode/CheckBrnHeader@30  4 2,
  meshNode/HostWifiFilter@31  4 2,
  meshNode/Classifier@32  4 2,
  meshNode/Classifier@33  4 2,
  meshNode/WifiDecap@34  4 2,
  meshNode/Classifier@35  4 2,
  meshNode/EtherDecap@36  4 2,
  meshNode/CheckBrnHeader@37  4 2,
  meshNode/Classifier@38  4 2,
  meshNode/ethertype_clf  4 2,
  meshNode/service_filter  2 0,
  meshNode/Idle@41,
  meshNode/Discard@42  0 0,
  meshNode/arp_tab,
  meshNode/prio_sched_wifi  4 0  4 0  4 0,
  meshNode/wifi_out_queue  4 0,
  meshNode/brn_tos_clf  4 0,
  meshNode/be_q  4 0,
  meshNode/prio_q  4 0,
  meshNode/Print@49/Print@1  4 2,
  meshNode/EtherEncap@50  4 2,
  meshNode/WifiEncap@51  4 0,
  meshNode/SetTXRate@52  4 0,
  meshNode/to_mesh_neighbors  4 0,
  meshNode/WifiEncap@54  4 0,
  meshNode/SetTXRate@55  4 0,
  meshNode/to_stations  4 0,
  meshNode/WifiEncap@57  4 0,
  meshNode/SetTXRate@58  4 0,
  meshNode/eth_out_queue  4 0,
  meshNode/NotifierQueue@60  4 0,
  meshNode/local_out_queue  4 0,
  meshNode/SetTXRate@62  4 0,
  meshNode/wifi_data_clf  4 2,
  meshNode/WifiDecap@64  4 2,
  meshNode/WifiDecap@65  4 2,
  meshNode/disassociator  4 2,
  meshNode/EtherDecap@67  4 2,
  meshNode/CheckBrnHeader@68  4 2,
  meshNode/nb_lst  4 2,
  meshNode/brn_clf  4 0,
  meshNode/dht_peek/dsr_src_clf  4 0,
  meshNode/dht_peek/dht_clf  4 0,
  meshNode/dht_peek/Print@3/Print@1  4 0,
  meshNode/iapp_peek/dsr_src_clf  4 0,
  meshNode/iapp_peek/StripBRNHeader@2  4 0,
  meshNode/iapp_peek/StripDSRHeader@3  4 0,
  meshNode/iapp_peek/iapp_peek  4 0,
  meshNode/iapp_peek/iapp_peek_tee  4 0,
  meshNode/iapp_peek/Strip@6  4 0,
  meshNode/iapp_peek/StripBRNHeader@7  4 2,
  meshNode/iapp_peek/PushDSRHeader@8  4 0,
  meshNode/iapp_peek/PushBRNHeader@9  4 0,
  meshNode/iapp_peek/PushDSRHeader@10  4 0,
  meshNode/iapp_peek/PushBRNHeader@11  4 0,
  meshNode/SetTimestamp@73  4 2,
  meshNode/SetTimestamp@74  4 2,
  meshNode/EtherEncap@75  4 2,
  meshNode/StripBRNHeader@76  4 0,
  meshNode/Discard@77  4 0,
  meshNode/hfilter  2 0,
  meshNode/tcpackfilter  2 0,
  meshNode/Print@80/Print@1  4 0,
  meshNode/brn_in_brn_clf/brn_in_brn_clf  4 0,
  meshNode/brn_in_brn_clf/Discard@2  4 0,
  meshNode/Print@82/Print@1  4 0,
  meshNode/EtherDecap@83  4 0,
  meshNode/Print@84/Print@1  4 0,
  meshNode/dsr_ds  4 0,
  meshNode/Print@86/Print@1  4 0,
  meshNode/Print@87/Print@1  4 0,
  meshNode/StripBRNHeader@88  4 0,
  meshNode/StripDSRHeader@89  4 0,
  meshNode/Print@90/Print@1  4 0,
  meshNode/StripBRNHeader@91  4 0,
  meshNode/StripDSRHeader@92  4 0,
  meshNode/Print@93/Print@1  4 0,
  meshNode/WifiEncap@94  4 0,
  meshNode/SetTXRate@95  4 0,
  meshNode/Discard@96  4 0,
  meshNode/StripBRNHeader@97  4 0,
  meshNode/StripDSRHeader@98  4 0,
  meshNode/to_sta  4 0,
  meshNode/dst_clf  4 0,
  meshNode/to_mesh  4 0,
  meshNode/failures  4 2,
  meshNode/Discard@103  4 2,
  meshNode/WifiDupeFilter@104  4 2,
  meshNode/mgm  4 2,
  meshNode/Discard@106  4 2,
  meshNode/WifiDecap@107  4 0,
  meshNode/WifiDecap@108  4 2,
  meshNode/Classifier@109  4 2,
  meshNode/EtherDecap@110  4 2,
  Align@click_align@345  1 0,
  Align@click_align@348  1 0,
  Align@click_align@360  1 0,
  Align@click_align@364  1 0,
  Align@click_align@377  4 0,
  Align@click_align@382  0 0,
  Align@click_align@395  4 2,
  Align@click_align@402  0 0,
  Align@click_align@404  4 2,
  Align@click_align@415  2 0,
  Align@click_align@416  4 0,
  Align@click_align@447  2 0,
  Align@click_align@449  4 0,
  Align@click_align@461  2 0,
  Align@click_align@469  4 2,
  Align@click_align@470  2 0,
  Align@click_align@471  2 0,
  Align@click_align@472  2 0,
  Align@click_align@474  2 0,
  Align@click_align@475  4 2,
  Align@click_align@476  2 0,
  Align@click_align@477  2 0,
  Align@click_align@478  2 0,
  Align@click_align@479  2 0,
  Align@click_align@480  4 2);

meshNode/wifi_device/filter [1] -> meshNode/failures
    -> meshNode/Discard@103;
meshNode/wifi_device/FromDevice@2 -> meshNode/wifi_device/AthdescDecap@3
    -> meshNode/wifi_device/filter_phy
    -> meshNode/wifi_device/filter
    -> meshNode/wifi_device/WifiDupeFilter@7
    -> meshNode/host_filter
    -> meshNode/wifi_type_clf
    -> Align@click_align@395
    -> meshNode/access_point/mgt_cl
    -> meshNode/access_point/assoc_resp
    -> meshNode/SetTXRate@62
    -> meshNode/wifi_out_queue
    -> meshNode/brn_tos_clf
    -> meshNode/be_q
    -> [1] meshNode/prio_sched_wifi;
meshNode/wifi_device/filter_phy [1] -> meshNode/wifi_device/FilterTX@8
    -> meshNode/HostWifiFilter@31
    -> meshNode/Classifier@32
    -> meshNode/Classifier@33
    -> meshNode/WifiDecap@34
    -> meshNode/Classifier@35
    -> meshNode/EtherDecap@36
    -> meshNode/CheckBrnHeader@37
    -> meshNode/Classifier@38
    -> Align@click_align@475
    -> meshNode/ncdsr/dec_clf
    -> meshNode/ncdsr/fragmentreceiver
    -> meshNode/ncdsr/NetcodingPrint@33
    -> meshNode/ncdsr/Strip@34
    -> meshNode/ncdsr/CheckCRC32@35
    -> meshNode/ncdsr/Unstrip@36
    -> meshNode/ncdsr/decoder
    -> meshNode/ncdsr/defragmenter
    -> Align@click_align@477
    -> meshNode/ncdsr/dsrclf
    -> meshNode/ncdsr/req_forwarder
    -> meshNode/Print@86/Print@1
    -> meshNode/dsr_ds
    -> meshNode/to_mesh_neighbors
    -> meshNode/WifiEncap@54
    -> meshNode/SetTXRate@55
    -> meshNode/wifi_out_queue;
meshNode/brn_in_brn_clf/brn_in_brn_clf [2] -> meshNode/ds
    -> meshNode/to_sta
    -> meshNode/vlan/Null@2
    -> meshNode/to_stations
    -> meshNode/WifiEncap@57
    -> meshNode/SetTXRate@58
    -> meshNode/wifi_out_queue;
meshNode/brn_in_brn_clf/brn_in_brn_clf [1] -> meshNode/EtherDecap@83
    -> meshNode/brn_clf
    -> meshNode/dht_peek/dsr_src_clf
    -> meshNode/dht_peek/dht_clf
    -> meshNode/dht_peek/Print@3/Print@1
    -> [2] meshNode/dht/dht;
meshNode/services/service_device/from_host/from_sim_device -> Align@click_align@345
    -> meshNode/services/service_device/from_host/CheckIPHeader@2
    -> meshNode/services/service_device/from_host/ip_filter
    -> meshNode/services/service_device/from_host/arp
    -> meshNode/services/service_device/from_host/SetTimestamp@5
    -> meshNode/services/service_device/SetEtherAnno@3
    -> meshNode/service_filter
    -> meshNode/vlan/Null@6
    -> Align@click_align@471
    -> meshNode/services/service_ether_clf
    -> meshNode/services/CheckIPHeader@11
    -> meshNode/services/service_ip_clf
    -> meshNode/services/dhcp/EtherDecap@1
    -> meshNode/services/dhcp/Strip@2
    -> meshNode/services/dhcp/dhcp_server
    -> meshNode/services/dhcp/UDPIPEncap@4
    -> Align@click_align@377
    -> meshNode/services/dhcp/EtherEncap@5
    -> meshNode/services/SetEtherAnno@14
    -> meshNode/ds;
meshNode/services/service_device/to_host/ethertype_clf [1] -> meshNode/services/service_device/to_host/CheckIPHeader@3
    -> meshNode/services/service_device/to_host/ip_classifier
    -> [1] meshNode/services/service_device/to_host/to_sim_device;
meshNode/services/service_device/from_host/ip_filter [1] -> meshNode/services/service_device/from_host/Discard@6;
meshNode/services/service_device/from_host/from_sim_device [1] -> Align@click_align@348
    -> [1] meshNode/services/service_device/from_host/arp;
meshNode/services/gw/direction [1] -> meshNode/service_filter;
meshNode/services/gw/to_clients [2] -> meshNode/service_filter;
meshNode/services/service_device/to_host/ethertype_clf [2] -> meshNode/services/service_device/to_host/to_sim_device;
meshNode/services/service_device/to_host/ip_classifier [1] -> meshNode/services/service_device/to_host/to_sim_device;
meshNode/services/local_device/from_host/dhcp_client/client [1] -> meshNode/services/local_device/from_host/dhcp_client/udp_encap
    -> meshNode/services/local_device/from_host/dhcp_client/DHCPUnicastEncap@8
    -> meshNode/services/local_device/from_host/dhcp_output
    -> meshNode/services/local_device/from_host/EtherEncap@10
    -> meshNode/services/local_device/from_host/SetTimestamp@11
    -> meshNode/services/local_device/SetEtherAnno@3
    -> Align@click_align@470
    -> meshNode/services/from_local_clf
    -> meshNode/services/CheckIPHeader@5
    -> meshNode/services/from_local_ip
    -> meshNode/vlan/Null@3
    -> meshNode/service_filter;
meshNode/services/local_device/from_host/dhcp_client/client [2] -> meshNode/services/local_device/from_host/dhcp_client/queue
    -> [1] meshNode/services/local_device/from_host/dhcp_client/client;
meshNode/services/local_device/from_host/dhcp_client/client [3] -> meshNode/services/local_device/from_host/dhcp_client/Discard@9;
meshNode/services/local_device/from_host/from_sim_device -> Align@click_align@360
    -> meshNode/services/local_device/from_host/CheckIPHeader@4
    -> meshNode/services/local_device/from_host/ip_filter
    -> meshNode/services/local_device/from_host/arp
    -> meshNode/services/local_device/from_host/SetTimestamp@7
    -> meshNode/services/local_device/SetEtherAnno@3;
meshNode/eth_device/Idle@2 -> meshNode/ethertype_clf
    -> meshNode/EtherDecap@67
    -> meshNode/CheckBrnHeader@68
    -> meshNode/nb_lst
    -> Align@click_align@480
    -> meshNode/brn_clf;
meshNode/services/local_device/from_host/ip_filter [1] -> meshNode/services/local_device/from_host/Discard@8;
meshNode/ncdsr/fragmentreceiver [2] -> Align@click_align@461
    -> meshNode/Print@93/Print@1
    -> meshNode/WifiEncap@94
    -> meshNode/SetTXRate@95
    -> meshNode/wifi_out_queue;
meshNode/services/local_device/from_host/from_sim_device [1] -> Align@click_align@364
    -> meshNode/services/local_device/from_host/ethertype_clf
    -> [1] meshNode/services/local_device/from_host/arp;
meshNode/services/local_device/from_host/ethertype_clf [1] -> meshNode/services/local_device/from_host/EtherDecap@13
    -> meshNode/services/local_device/from_host/CheckIPHeader@14
    -> meshNode/services/local_device/from_host/dhcp_client/CheckIPHeader@2
    -> meshNode/services/local_device/from_host/dhcp_client/CheckUDPHeader@3
    -> meshNode/services/local_device/from_host/dhcp_client/CheckDHCPMsg@4
    -> meshNode/services/local_device/from_host/dhcp_client/client
    -> meshNode/services/local_device/from_host/dhcp_client/UDPIPEncap@5
    -> meshNode/services/local_device/from_host/dhcp_output;
meshNode/ncdsr/encoder [1] -> meshNode/Print@93/Print@1;
meshNode/services/local_device/from_host/ethertype_clf [2] -> meshNode/services/local_device/from_host/bogus
    -> meshNode/services/local_device/from_host/Print@16/Print@1
    -> meshNode/services/local_device/from_host/Discard@17;
meshNode/services/local_device/to_host/ethertype_clf [1] -> meshNode/services/local_device/to_host/CheckIPHeader@3
    -> meshNode/services/local_device/to_host/ip_classifier
    -> [1] meshNode/services/local_device/to_host/to_sim_device;
meshNode/services/local_device/to_host/ethertype_clf [2] -> meshNode/services/local_device/to_host/to_sim_device;
meshNode/services/local_device/to_host/ip_classifier [1] -> meshNode/services/local_device/to_host/to_sim_device;
meshNode/ncdsr/nb [1] -> meshNode/Print@82/Print@1
    -> meshNode/brn_in_brn_clf/brn_in_brn_clf
    -> meshNode/brn_in_brn_clf/Discard@2;
meshNode/ncdsr/src_forwarder [1] -> meshNode/Print@82/Print@1;
meshNode/dht_peek/dsr_src_clf [1] -> meshNode/iapp_peek/dsr_src_clf
    -> meshNode/iapp_peek/StripBRNHeader@2
    -> meshNode/iapp_peek/StripDSRHeader@3
    -> meshNode/iapp_peek/iapp_peek
    -> meshNode/iapp_peek/iapp_peek_tee
    -> meshNode/iapp_peek/Strip@6
    -> meshNode/iapp_peek/StripBRNHeader@7
    -> meshNode/brn_iapp/sta_tracker;
meshNode/dsr/nb [1] -> meshNode/Print@80/Print@1
    -> meshNode/brn_in_brn_clf/brn_in_brn_clf;
meshNode/dsr/src_forwarder [1] -> meshNode/Print@80/Print@1;
meshNode/dht_peek/dht_clf [1] -> meshNode/iapp_peek/dsr_src_clf;
meshNode/brn_iapp/data2_hdl [1] -> meshNode/dsr/err_forwarder
    -> meshNode/Print@84/Print@1
    -> meshNode/dsr_ds;
meshNode/services/gw/udp [1] -> meshNode/services/gw/ICMPError@14
    -> meshNode/services/gw/resolve
    -> meshNode/services/gw/paint
    -> meshNode/service_filter;
meshNode/services/gw/paint [1] -> meshNode/services/gw/paint2
    -> meshNode/services/gw/encap
    -> meshNode/vlan/Null@3;
meshNode/brn_iapp/data_hdl [1] -> meshNode/dsr/err_forwarder;
meshNode/iapp_peek/dsr_src_clf [1] -> meshNode/dsr/dsrclf
    -> meshNode/dsr/req_forwarder
    -> meshNode/Print@84/Print@1;
meshNode/dht/dht_out_clf [1] -> meshNode/dsr/clf_bcast
    -> meshNode/dsr/Discard@11;
meshNode/services/gw/from_clients [2] -> meshNode/services/gw/setgw
    -> meshNode/service_filter;
meshNode/services/gw/setgw [1] -> meshNode/services/gw/Paint@22
    -> meshNode/services/gw/icmp_error2client
    -> meshNode/services/gw/StoreIPEthernet@8
    -> meshNode/services/gw/EtherDecap@9
    -> meshNode/services/gw/udp
    -> meshNode/services/gw/ICMPError@11
    -> meshNode/services/gw/resolve;
meshNode/services/gw/from_clients [1] -> meshNode/services/gw/flows
    -> meshNode/services/gw/direction
    -> meshNode/services/gw/clients
    -> meshNode/services/gw/buffer
    -> meshNode/services/gw/setgwflow
    -> meshNode/service_filter;
meshNode/dht/dht [2] -> Align@click_align@479
    -> meshNode/dsr/dsrclf;
meshNode/services/gw/setgwflow [2] -> meshNode/dsr/clf_bcast;
meshNode/brn_clf [5] -> meshNode/ncdsr/dec_clf;
meshNode/brn_clf [6] -> meshNode/ncdsr/dec_clf;
meshNode/services/gw/to_clients [1] -> meshNode/services/gw/flows;
meshNode/tcpackfilter [1] -> meshNode/ncdsr/Print@22/Print@1
    -> Align@click_align@476
    -> meshNode/ncdsr/clf_bcast
    -> meshNode/ncdsr/Discard@24;
meshNode/services/gw/before_local_gw [2] -> [1] meshNode/services/gw/gws;
meshNode/services/gw/before_local_gw [1] -> meshNode/services/gw/gws
    -> meshNode/services/local_device/SetPacketType@6
    -> meshNode/services/local_device/to_host/ethertype_clf
    -> [1] meshNode/services/local_device/to_host/to_sim_device;
meshNode/brn_clf [2] -> meshNode/dht/Strip@3
    -> meshNode/dht/dht
    -> Align@click_align@474
    -> meshNode/dht/dht_out_clf
    -> meshNode/to_mesh_neighbors;
meshNode/services/arp/arp [1] -> [1] meshNode/dht/dht;
meshNode/services/gw/gws [1] -> meshNode/services/gw/from_clients
    -> meshNode/services/gw/setgw;
meshNode/services/gw/gws [2] -> meshNode/services/gw/Paint@35
    -> meshNode/services/gw/icmp_error2client;
meshNode/services/dhcp/dhcp_server [1] -> [1] meshNode/dht/dht;
meshNode/Idle@41 -> meshNode/vlan/Null@5
    -> meshNode/Discard@42;
meshNode/services/from_local_clf [1] -> meshNode/vlan/Null@3;
meshNode/promisc_stop_clf [1] -> meshNode/brn_iapp/snoopy;
meshNode/brn_iapp/iapp_clf [5] -> meshNode/brn_iapp/Print@17/Print@1
    -> meshNode/brn_iapp/Discard@18;
meshNode/dht/dht [1] -> Align@click_align@472
    -> meshNode/services/dht_classifier
    -> [1] meshNode/services/arp/arp;
meshNode/services/service_ether_clf [2] -> meshNode/services/Print@24/Print@1
    -> meshNode/services/Discard@25;
meshNode/brn_clf [4] -> meshNode/services/gw/decap
    -> meshNode/services/gw/CheckIPHeader@31
    -> meshNode/services/gw/to_clients
    -> meshNode/service_filter;
meshNode/services/service_ether_clf [1] -> meshNode/services/ARPPrint@19/ARPPrint@1
    -> meshNode/services/hef
    -> meshNode/services/arp/arp
    -> meshNode/services/SetEtherAnno@22
    -> meshNode/services/ARPPrint@23/ARPPrint@1
    -> meshNode/service_filter;
meshNode/services/bc [1] -> meshNode/services/IPPrint@17/IPPrint@1
    -> meshNode/services/Discard@18;
meshNode/services/service_ip_clf [2] -> meshNode/services/bc
    -> meshNode/services/Discard@16;
meshNode/services/dht_classifier [1] -> [1] meshNode/services/dhcp/dhcp_server;
meshNode/brn_iapp/notify_hdl [1] -> [1] meshNode/services/gw/setgwflow;
meshNode/services/from_local_ip [1] -> meshNode/services/gw/encap;
meshNode/services/local_ip [1] -> meshNode/services/gw/before_local_gw
    -> [1] meshNode/services/gw/gws;
meshNode/services/service_ip_clf [3] -> meshNode/services/gw/from_clients;
meshNode/services/dht_classifier [2] -> meshNode/services/gw/gateway
    -> [1] meshNode/dht/dht;
meshNode/services/gw/setgwflow [1] -> meshNode/services/gw/Print@28/Print@1
    -> meshNode/services/gw/Paint@29
    -> meshNode/services/gw/icmp_error2client;
meshNode/services/gw/flows [1] -> meshNode/services/gw/Print@25/Print@1
    -> meshNode/services/gw/IPPrint@26/IPPrint@1
    -> meshNode/services/gw/Discard@27;
meshNode/services/dht_classifier [3] -> meshNode/services/Discard@27;
meshNode/services/gw/paint2 [1] -> meshNode/services/gw/Print@17/Print@1
    -> meshNode/services/gw/IPPrint@18/IPPrint@1
    -> meshNode/services/gw/Discard@19;
meshNode/brn_iapp/ip_printer@15/ethertype_clf [1] -> meshNode/brn_iapp/ip_printer@15/CheckIPHeader@3
    -> [2] meshNode/services/gw/setgwflow;
meshNode/services/local_clf [1] -> meshNode/services/local_device/SetPacketType@6;
meshNode/brn_iapp/ip_printer@20/ethertype_clf [1] -> meshNode/brn_iapp/ip_printer@20/CheckIPHeader@3
    -> [2] meshNode/services/gw/setgwflow;
meshNode/brn_iapp/iapp_filter [1] -> meshNode/brn_iapp/WifiDecap@13
    -> [1] meshNode/brn_iapp/data2_hdl;
meshNode/brn_iapp/Idle@12 -> Align@click_align@382
    -> meshNode/brn_iapp/data2_hdl
    -> meshNode/brn_iapp/SetBrnTos@14
    -> meshNode/brn_iapp/ip_printer@15/ethertype_clf
    -> meshNode/brn_iapp/ip_printer@15/CheckIPHeader@2
    -> [2] meshNode/services/gw/setgwflow;
meshNode/services/service_ip_clf [1] -> meshNode/services/service_device/SetPacketType@6
    -> meshNode/services/service_device/to_host/ethertype_clf
    -> [1] meshNode/services/service_device/to_host/to_sim_device;
meshNode/brn_iapp/iapp_clf [2] -> meshNode/brn_iapp/data_hdl
    -> meshNode/brn_iapp/ip_printer@20/ethertype_clf
    -> meshNode/brn_iapp/ip_printer@20/CheckIPHeader@2
    -> [2] meshNode/services/gw/setgwflow;
meshNode/brn_iapp/iapp_clf [1] -> [1] meshNode/brn_iapp/notify_hdl;
meshNode/services/hef [1] -> meshNode/services/service_device/SetPacketType@6;
meshNode/brn_iapp/iapp_clf [3] -> meshNode/brn_iapp/route_hdl
    -> meshNode/brn_iapp/SetBrnTos@21
    -> [2] meshNode/services/gw/setgwflow;
meshNode/brn_iapp/iapp_clf [4] -> meshNode/brn_iapp/hello_hdl
    -> [2] meshNode/services/gw/setgwflow;
meshNode/ds [2] -> meshNode/local_out_queue
    -> meshNode/vlan/Null@4
    -> meshNode/services/local_clf
    -> meshNode/services/CheckIPHeader@8
    -> meshNode/services/local_ip
    -> meshNode/services/local_device/SetPacketType@6;
meshNode/mgm [2] -> meshNode/WifiDecap@108
    -> meshNode/Classifier@109
    -> meshNode/EtherDecap@110
    -> meshNode/ncdsr/errclf
    -> [1] meshNode/ncdsr/decoder;
meshNode/mgm [1] -> Align@click_align@469
    -> meshNode/WifiDecap@107
    -> [1] meshNode/brn_iapp/data_hdl;
meshNode/failures [1] -> meshNode/WifiDupeFilter@104
    -> meshNode/mgm
    -> meshNode/Discard@106;
meshNode/ds [1] -> meshNode/eth_out_queue
    -> meshNode/NotifierQueue@60
    -> meshNode/eth_device/Discard@1;
meshNode/to_sta [1] -> meshNode/dst_clf
    -> meshNode/to_mesh
    -> meshNode/to_mesh_neighbors;
meshNode/dsr_ds [3] -> meshNode/StripBRNHeader@97
    -> meshNode/StripDSRHeader@98
    -> [1] meshNode/brn_iapp/data_hdl;
meshNode/dsr_ds [2] -> meshNode/Discard@96;
meshNode/dsr_ds [1] -> meshNode/eth_out_queue;
meshNode/access_point/mgt_cl [1] -> meshNode/access_point/assoc_resp;
meshNode/access_point/mgt_cl [2] -> meshNode/access_point/assoc_resp;
meshNode/access_point/mgt_cl [3] -> meshNode/access_point/assoc_resp;
meshNode/access_point/mgt_cl [4] -> meshNode/access_point/beacon_source
    -> meshNode/SetTXRate@62;
meshNode/access_point/mgt_cl [8] -> meshNode/access_point/assoc_resp;
meshNode/access_point/mgt_cl [5] -> meshNode/access_point/Discard@7;
meshNode/access_point/mgt_cl [6] -> meshNode/access_point/Discard@8;
meshNode/access_point/mgt_cl [7] -> meshNode/access_point/Discard@9;
meshNode/access_point/mgt_cl [9] -> meshNode/access_point/OpenAuthResponder@10
    -> meshNode/SetTXRate@62;
meshNode/access_point/mgt_cl [10] -> meshNode/access_point/Discard@11;
meshNode/access_point/mgt_cl [11] -> meshNode/access_point/Discard@12;
meshNode/hfilter [1] -> meshNode/tcpackfilter
    -> Align@click_align@478
    -> meshNode/dsr/clf_bcast;
meshNode/service_filter [1] -> meshNode/hfilter
    -> Align@click_align@447
    -> meshNode/local_out_queue;
meshNode/ethertype_clf [1] -> meshNode/service_filter;
meshNode/brn_clf [7] -> meshNode/Discard@77;
meshNode/brn_clf [3] -> meshNode/StripBRNHeader@76
    -> meshNode/brn_iapp/iapp_clf
    -> meshNode/brn_iapp/notify_hdl
    -> meshNode/brn_iapp/SetBrnTos@19
    -> [2] meshNode/services/gw/setgwflow;
meshNode/ncdsr/clf_bcast [1] -> meshNode/ncdsr/nb
    -> meshNode/Print@82/Print@1;
meshNode/brn_clf [1] -> Align@click_align@449
    -> meshNode/SetTimestamp@73
    -> meshNode/link_stat
    -> meshNode/SetTimestamp@74
    -> meshNode/EtherEncap@75
    -> meshNode/to_mesh_neighbors;
meshNode/ncdsr/nb [2] -> meshNode/ncdsr/SetTimestamp@25
    -> meshNode/ncdsr/querier
    -> meshNode/ncdsr/SetTimestamp@26
    -> meshNode/Print@86/Print@1;
meshNode/ncdsr/querier [1] -> meshNode/ncdsr/SetTimestamp@27
    -> meshNode/ncdsr/src_forwarder
    -> meshNode/ncdsr/fragmenter
    -> meshNode/ncdsr/encoder
    -> meshNode/ncdsr/Strip@41
    -> meshNode/ncdsr/SetCRC32@42
    -> meshNode/ncdsr/Unstrip@43
    -> meshNode/ncdsr/fragmentsender
    -> meshNode/ncdsr/send_queue
    -> meshNode/ncdsr/monitor
    -> meshNode/Print@49/Print@1
    -> meshNode/EtherEncap@50
    -> meshNode/WifiEncap@51
    -> meshNode/SetTXRate@52
    -> [2] meshNode/prio_sched_wifi;
meshNode/ncdsr/src_forwarder [2] -> meshNode/ncdsr/tee_to_err_fwd
    -> meshNode/Print@90/Print@1
    -> meshNode/StripBRNHeader@91
    -> meshNode/StripDSRHeader@92
    -> [1] meshNode/brn_iapp/data_hdl;
meshNode/ncdsr/route_updater [2] -> meshNode/ncdsr/tee_to_err_fwd;
meshNode/ncdsr/Idle@29 -> Align@click_align@402
    -> meshNode/ncdsr/route_updater
    -> meshNode/ncdsr/encoder;
meshNode/ncdsr/route_updater [1] -> meshNode/ncdsr/Discard@30;
meshNode/ncdsr/tee_to_err_fwd [1] -> meshNode/ncdsr/err_forwarder
    -> meshNode/Print@86/Print@1;
meshNode/ncdsr/req_forwarder [1] -> meshNode/ncdsr/rep_forwarder
    -> meshNode/ncdsr/SetTimestamp@32
    -> meshNode/Print@86/Print@1;
meshNode/ncdsr/dsrclf [1] -> [1] meshNode/ncdsr/rep_forwarder;
meshNode/wifi_data_clf [1] -> meshNode/WifiDecap@65
    -> meshNode/vlan/Null@1
    -> meshNode/disassociator
    -> meshNode/ethertype_clf;
meshNode/ncdsr/dsrclf [2] -> [1] meshNode/ncdsr/err_forwarder;
meshNode/ncdsr/route_upd_clf [1] -> [1] meshNode/ncdsr/route_updater;
meshNode/ncdsr/dsrclf [3] -> [1] meshNode/ncdsr/src_forwarder;
meshNode/ncdsr/fragmentreceiver [1] -> Align@click_align@415
    -> meshNode/ncdsr/route_upd_clf
    -> meshNode/ncdsr/encoder;
meshNode/wifi_type_clf [1] -> meshNode/wifi_data_clf
    -> meshNode/WifiDecap@64
    -> meshNode/ethertype_clf;
meshNode/ncdsr/dec_clf [1] -> Align@click_align@416
    -> meshNode/ncdsr/Unstrip@38
    -> meshNode/ncdsr/Strip@39
    -> [1] meshNode/ncdsr/encoder;
meshNode/ncdsr/dec_clf [2] -> meshNode/ncdsr/dsrclf;
meshNode/ncdsr/decoder [1] -> [1] meshNode/ncdsr/fragmentreceiver;
meshNode/ncdsr/errclf [1] -> Align@click_align@404
    -> meshNode/ncdsr/err_forwarder;
meshNode/dsr/clf_bcast [1] -> meshNode/dsr/nb
    -> meshNode/Print@80/Print@1;
meshNode/dsr/nb [2] -> meshNode/dsr/SetTimestamp@12
    -> meshNode/dsr/querier
    -> meshNode/dsr/SetTimestamp@13
    -> meshNode/Print@84/Print@1;
meshNode/dsr/querier [1] -> meshNode/dsr/SetTimestamp@14
    -> meshNode/dsr/src_forwarder
    -> meshNode/Print@84/Print@1;
meshNode/dsr/src_forwarder [2] -> meshNode/dsr/tee_to_err_fwd
    -> meshNode/Print@87/Print@1
    -> meshNode/StripBRNHeader@88
    -> meshNode/StripDSRHeader@89
    -> [1] meshNode/brn_iapp/data_hdl;
meshNode/dsr/tee_to_err_fwd [1] -> meshNode/dsr/err_forwarder;
meshNode/dsr/req_forwarder [1] -> meshNode/dsr/rep_forwarder
    -> meshNode/dsr/SetTimestamp@17
    -> meshNode/Print@84/Print@1;
meshNode/brn_tos_clf [1] -> meshNode/prio_q
    -> meshNode/prio_sched_wifi
    -> meshNode/brn_iapp/iapp_filter
    -> meshNode/wifi_device/AthdescEncap@10
    -> meshNode/wifi_device/ToDevice@11;
meshNode/dsr/dsrclf [1] -> [1] meshNode/dsr/rep_forwarder;
meshNode/dsr/dsrclf [2] -> [1] meshNode/dsr/err_forwarder;
meshNode/dsr/dsrclf [3] -> meshNode/dsr/TraceReporter@18
    -> [1] meshNode/dsr/src_forwarder;
meshNode/iapp_peek/iapp_peek [1] -> meshNode/iapp_peek/PushDSRHeader@8
    -> meshNode/iapp_peek/PushBRNHeader@9
    -> meshNode/dsr/dsrclf;
meshNode/iapp_peek/iapp_peek_tee [1] -> meshNode/iapp_peek/PushDSRHeader@10
    -> meshNode/iapp_peek/PushBRNHeader@11
    -> meshNode/dsr/dsrclf;
meshNode/host_filter [1] -> meshNode/promisc_stop_clf
    -> meshNode/Classifier@25
    -> meshNode/Classifier@26
    -> meshNode/WifiDecap@27
    -> meshNode/Classifier@28
    -> meshNode/EtherDecap@29
    -> meshNode/CheckBrnHeader@30
    -> Align@click_align@475;  