/* Copyright (C) 2005 BerlinRoofNet Lab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 * For additional licensing options, consult http://www.BerlinRoofNet.de
 * or contact brn@informatik.hu-berlin.de.
 */

include(README)

include(util.click);

// needed for simulation
include(sim-devices.click);
include(sim-dht-device.click);

include(devices.click);

//include(enable-dump.click);

include(meshnode.click);


meshNode :: Meshnode( SSID "BerlinRoofNet", WIFI_DEV ath0, WIFI_CHANNEL 10,
                      ETH_DEV eth0, LOCAL_DEV local,
                      PREFIX 0.0.0.0/16, SERVICE_IP 0.0.0.1);

//todump_active :: CompoundHandler("active", "ToDump");

Script(
 // debug level of routing layer
  write meshNode/access_point/all.debug 2,

  // turn off beacons
  write meshNode/access_point/beacon_source.active false,

  // TODO turn off link probes
  write meshNode/link_stat.probes  12 1000,
  write meshNode/link_stat.period  100000,
  write meshNode/link_stat.tau     3000000,

	write meshNode/dsr/querier.fixed_route
	  00:00:00:00:00:01
	  00:00:00:00:00:02
	  00:00:00:00:00:03
	  00:00:00:00:00:04

);
